/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.DefaultIOContext;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.ReadOnceHint;

public interface IOContext {
    public static final IOContext DEFAULT = new DefaultIOContext(new FileOpenHint[0]);
    public static final IOContext READONCE = new DefaultIOContext(DataAccessHint.SEQUENTIAL, ReadOnceHint.INSTANCE);

    public static IOContext merge(final MergeInfo mergeInfo) {
        Objects.requireNonNull(mergeInfo);
        return new IOContext(){

            @Override
            public Context context() {
                return Context.MERGE;
            }

            @Override
            public MergeInfo mergeInfo() {
                return mergeInfo;
            }

            @Override
            public FlushInfo flushInfo() {
                return null;
            }

            @Override
            public Set<FileOpenHint> hints() {
                return Set.of();
            }

            @Override
            public IOContext withHints(FileOpenHint ... hints) {
                return this;
            }
        };
    }

    public static IOContext flush(final FlushInfo flushInfo) {
        Objects.requireNonNull(flushInfo);
        return new IOContext(){

            @Override
            public Context context() {
                return Context.FLUSH;
            }

            @Override
            public MergeInfo mergeInfo() {
                return null;
            }

            @Override
            public FlushInfo flushInfo() {
                return flushInfo;
            }

            @Override
            public Set<FileOpenHint> hints() {
                return Set.of();
            }

            @Override
            public IOContext withHints(FileOpenHint ... hints) {
                return this;
            }
        };
    }

    public Context context();

    public MergeInfo mergeInfo();

    public FlushInfo flushInfo();

    public Set<FileOpenHint> hints();

    default public <T extends FileOpenHint> Stream<T> hints(Class<T> cls) {
        return this.hints().stream().filter(cls::isInstance).map(cls::cast);
    }

    public IOContext withHints(FileOpenHint ... var1);

    public static interface FileOpenHint {
    }

    public static enum Context {
        MERGE,
        FLUSH,
        DEFAULT;

    }
}

