/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.internal.ui.mapping.IEmptyTreeListener;
import org.eclipse.team.internal.ui.mapping.ModelSynchronizePage;
import org.eclipse.team.internal.ui.mapping.ResourceDragAdapterAssistant;
import org.eclipse.team.internal.ui.mapping.TeamViewerComparator;
import org.eclipse.team.internal.ui.synchronize.AbstractTreeViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerComparator;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.IPageSite;

public class CommonViewerAdvisor
extends AbstractTreeViewerAdvisor
implements INavigatorContentServiceListener,
IEmptyTreeListener,
IPropertyChangeListener {
    public static final String TEAM_NAVIGATOR_CONTENT = "org.eclipse.team.ui.navigatorViewer";
    private static final String PROP_ACTION_SERVICE_ACTION_BARS = "org.eclipse.team.ui.actionServiceActionBars";
    private final Set<INavigatorContentExtension> extensions = new HashSet<INavigatorContentExtension>();
    private NavigatorActionService actionService;
    private IEmptyTreeListener emptyTreeListener;

    private static CommonViewer createViewer(Composite parent, ISynchronizePageConfiguration configuration, IEmptyTreeListener listener) {
        NavigableCommonViewer v = new NavigableCommonViewer(configuration.getViewerId(), parent, 770, listener);
        v.setComparator((ViewerComparator)new CommonViewerComparator());
        v.setComparator((ViewerComparator)new TeamViewerComparator((CommonViewerComparator)v.getComparator()));
        ISynchronizationScope scope = CommonViewerAdvisor.getScope(configuration);
        CommonViewerAdvisor.bindTeamContentProviders(v);
        scope.addScopeChangeListener((scope1, newMappings, newTraversals) -> {
            CommonViewerAdvisor.enableContentProviders(v, configuration);
            Utils.asyncExec(() -> v.refresh(), (StructuredViewer)v);
        });
        CommonViewerAdvisor.enableContentProviders(v, configuration);
        configuration.getSite().setSelectionProvider((ISelectionProvider)v);
        return v;
    }

    private static void enableContentProviders(CommonViewer v, ISynchronizePageConfiguration configuration) {
        v.getNavigatorContentService().getActivationService().activateExtensions(CommonViewerAdvisor.getEnabledContentProviders(configuration), true);
    }

    private static String[] getEnabledContentProviders(ISynchronizePageConfiguration configuration) {
        ITeamContentProviderDescriptor desc;
        String visibleModel = (String)configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        if (visibleModel != null && !visibleModel.equals("org.eclipse.team.ui.activeModelProvider") && (desc = TeamUI.getTeamContentProviderManager().getDescriptor(visibleModel)) != null && desc.isEnabled()) {
            return new String[]{desc.getContentExtensionId()};
        }
        configuration.setProperty("org.eclipse.team.ui.activeModelProvider", "org.eclipse.team.ui.activeModelProvider");
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)configuration.getParticipant();
        ModelProvider[] providers = participant.getEnabledModelProviders();
        HashSet<String> result = new HashSet<String>();
        Object property = configuration.getProperty("org.eclipse.team.ui.pageLayout");
        boolean isFlatLayout = property != null && property.equals("org.eclipse.team.ui.flatLayout");
        ModelProvider[] modelProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            ITeamContentProviderDescriptor desc2 = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
            if (desc2 != null && desc2.isEnabled() && (!isFlatLayout || desc2.isFlatLayoutSupported())) {
                result.add(desc2.getContentExtensionId());
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static void bindTeamContentProviders(CommonViewer v) {
        ITeamContentProviderManager teamContentProviderManager = TeamUI.getTeamContentProviderManager();
        ITeamContentProviderDescriptor[] descriptors = teamContentProviderManager.getDescriptors();
        HashSet<String> toBind = new HashSet<String>();
        ITeamContentProviderDescriptor[] iTeamContentProviderDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamContentProviderDescriptor descriptor = iTeamContentProviderDescriptorArray[n2];
            toBind.add(descriptor.getContentExtensionId());
            ++n2;
        }
        v.getNavigatorContentService().bindExtensions(toBind.toArray(new String[toBind.size()]), true);
    }

    private static ISynchronizationScope getScope(ISynchronizePageConfiguration configuration) {
        return (ISynchronizationScope)configuration.getProperty("org.eclipse.team.ui.synchronizationScope");
    }

    public CommonViewerAdvisor(Composite parent, ISynchronizePageConfiguration configuration) {
        super(configuration);
        CommonViewer viewer = CommonViewerAdvisor.createViewer(parent, configuration, this);
        TeamUI.getTeamContentProviderManager().addPropertyChangeListener(this);
        configuration.addPropertyChangeListener(this);
        GridData data = new GridData(1808);
        viewer.getControl().setLayoutData((Object)data);
        viewer.getNavigatorContentService().addListener((INavigatorContentServiceListener)this);
        this.initializeViewer((StructuredViewer)viewer);
        IBaseLabelProvider provider = viewer.getLabelProvider();
        if (provider instanceof DecoratingLabelProvider) {
            DecoratingLabelProvider dlp = (DecoratingLabelProvider)provider;
            ILabelDecorator decorator = ((SynchronizePageConfiguration)configuration).getLabelDecorator();
            if (decorator != null) {
                ILabelProvider lp = dlp.getLabelProvider();
                dlp = new DecoratingLabelProvider((ILabelProvider)new DecoratingLabelProvider(lp, decorator), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
                viewer.setLabelProvider((IBaseLabelProvider)dlp);
            }
            DecorationContext decorationContext = new DecorationContext();
            decorationContext.putProperty("org.eclipse.team.ui.syncStateTester", (Object)new SynchronizationStateTester(){

                @Override
                public boolean isStateDecorationEnabled() {
                    return false;
                }
            });
            dlp.setDecorationContext((IDecorationContext)decorationContext);
        } else if (provider instanceof DecoratingStyledCellLabelProvider) {
            DecoratingStyledCellLabelProvider dsclp = (DecoratingStyledCellLabelProvider)provider;
            ILabelDecorator decorator = ((SynchronizePageConfiguration)configuration).getLabelDecorator();
            if (decorator != null) {
                DelegatingStyledCellLabelProvider.IStyledLabelProvider slp = dsclp.getStyledStringProvider();
                dsclp = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MyDecoratingStyledCellLabelProvider(slp, decorator), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
                viewer.setLabelProvider((IBaseLabelProvider)dsclp);
            }
            DecorationContext decorationContext = new DecorationContext();
            decorationContext.putProperty("org.eclipse.team.ui.syncStateTester", (Object)new SynchronizationStateTester(){

                @Override
                public boolean isStateDecorationEnabled() {
                    return false;
                }
            });
            dsclp.setDecorationContext((IDecorationContext)decorationContext);
        }
    }

    @Override
    public void setInitialInput() {
        CommonViewer viewer = (CommonViewer)this.getViewer();
        viewer.setInput(this.getInitialInput());
        viewer.expandToLevel(2);
    }

    @Override
    public void initializeViewer(StructuredViewer viewer) {
        this.createActionService((CommonViewer)viewer, this.getConfiguration());
        super.initializeViewer(viewer);
    }

    private void createActionService(CommonViewer viewer, ISynchronizePageConfiguration configuration) {
        ICommonViewerSite commonSite = this.createCommonViewerSite(viewer, configuration);
        this.actionService = new NavigatorActionService(commonSite, (StructuredViewer)viewer, viewer.getNavigatorContentService());
    }

    private ICommonViewerSite createCommonViewerSite(CommonViewer viewer, ISynchronizePageConfiguration configuration) {
        IWorkbenchSite site = configuration.getSite().getWorkbenchSite();
        if (site instanceof IEditorSite) {
            IEditorSite es = (IEditorSite)site;
            return CommonViewerSiteFactory.createCommonViewerSite((IEditorSite)es);
        }
        if (site instanceof IViewSite) {
            IViewSite vs = (IViewSite)site;
            return CommonViewerSiteFactory.createCommonViewerSite((IViewSite)vs);
        }
        if (site instanceof IPageSite) {
            IPageSite ps = (IPageSite)site;
            return CommonViewerSiteFactory.createCommonViewerSite((String)configuration.getViewerId(), (IPageSite)ps);
        }
        return CommonViewerSiteFactory.createCommonViewerSite((String)configuration.getViewerId(), (ISelectionProvider)viewer, (Shell)configuration.getSite().getShell());
    }

    private Object getInitialInput() {
        String visible = (String)this.getConfiguration().getProperty("org.eclipse.team.ui.activeModelProvider");
        if (visible != null && !visible.equals("org.eclipse.team.ui.activeModelProvider")) {
            try {
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)visible);
                if (desc != null) {
                    return desc.getModelProvider();
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    public void onLoad(INavigatorContentExtension anExtension) {
        this.extensions.add(anExtension);
        ISynchronizationContext context = this.getParticipant().getContext();
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationScope", (Object)context.getScope());
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationPageConfiguration", (Object)this.getConfiguration());
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationContext", (Object)context);
    }

    private ModelSynchronizeParticipant getParticipant() {
        return (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
    }

    @Override
    protected String getContextMenuId(StructuredViewer viewer) {
        return ((CommonViewer)viewer).getNavigatorContentService().getViewerDescriptor().getPopupMenuId();
    }

    @Override
    protected void registerContextMenu(StructuredViewer viewer, MenuManager menuMgr) {
        this.actionService.prepareMenuForPlatformContributions(menuMgr, (ISelectionProvider)viewer, false);
    }

    @Override
    protected void fillContextMenu(StructuredViewer viewer, IMenuManager manager) {
        if (manager instanceof CommonMenuManager) {
            CommonMenuManager cmm = (CommonMenuManager)manager;
            cmm.clearHandlers();
        }
        ISelection selection = this.getViewer().getSelection();
        this.actionService.setContext(new ActionContext(selection));
        this.actionService.fillContextMenu(manager);
        super.fillContextMenu(viewer, manager);
    }

    @Override
    public void dispose() {
        TeamUI.getTeamContentProviderManager().removePropertyChangeListener(this);
        this.getConfiguration().removePropertyChangeListener(this);
        this.actionService.dispose();
        super.dispose();
    }

    @Override
    protected void updateActionBars(IStructuredSelection selection) {
        super.updateActionBars(selection);
        if (!this.getConfiguration().getSite().isModal()) {
            this.actionService.setContext(new ActionContext((ISelection)selection));
            SubActionBars subActionBars = (SubActionBars)this.getConfiguration().getProperty(PROP_ACTION_SERVICE_ACTION_BARS);
            if (subActionBars == null) {
                subActionBars = new CommonSubActionBars(this.getConfiguration().getSite().getActionBars());
                this.getConfiguration().setProperty(PROP_ACTION_SERVICE_ACTION_BARS, subActionBars);
            }
            this.actionService.fillActionBars((IActionBars)subActionBars);
        }
    }

    @Override
    protected MenuManager createContextMenuManager(String targetID) {
        return new CommonMenuManager(targetID);
    }

    @Override
    protected void addContextMenuGroups(IMenuManager manager) {
    }

    public void addEmptyTreeListener(IEmptyTreeListener emptyTreeListener) {
        this.emptyTreeListener = emptyTreeListener;
    }

    @Override
    public void treeEmpty(TreeViewer viewer) {
        if (this.emptyTreeListener != null) {
            this.emptyTreeListener.treeEmpty(viewer);
        }
    }

    @Override
    public void notEmpty(TreeViewer viewer) {
        if (this.emptyTreeListener != null) {
            this.emptyTreeListener.notEmpty(viewer);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.ENABLED_MODEL_PROVIDERS")) {
            CommonViewerAdvisor.enableContentProviders((CommonViewer)this.getViewer(), this.getConfiguration());
        } else if (event.getProperty().equals("org.eclipse.team.ui.activeModelProvider")) {
            CommonViewerAdvisor.enableContentProviders((CommonViewer)this.getViewer(), this.getConfiguration());
            StructuredViewer viewer = this.getViewer();
            Utils.syncExec(() -> this.lambda$2(event, (Viewer)viewer), viewer);
        } else if (event.getProperty().equals("org.eclipse.team.ui.pageLayout")) {
            CommonViewerAdvisor.enableContentProviders((CommonViewer)this.getViewer(), this.getConfiguration());
        }
    }

    @Override
    protected boolean handleDoubleClick(StructuredViewer viewer, DoubleClickEvent event) {
        if (this.isOpenable(event.getSelection())) {
            return true;
        }
        return super.handleDoubleClick(viewer, event);
    }

    private boolean isOpenable(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object object = ss.getFirstElement();
        if (object == null) {
            return false;
        }
        return this.getParticipant().hasCompareInputFor(object);
    }

    @Override
    protected void expandToNextDiff(Object element) {
        ((TreeViewer)this.getViewer()).expandToLevel(element, -1);
    }

    private /* synthetic */ void lambda$2(PropertyChangeEvent propertyChangeEvent, Viewer viewer) {
        Object viewerInput = ModelSynchronizePage.getViewerInput(this.getConfiguration(), (String)propertyChangeEvent.getNewValue());
        if (viewer != null && viewerInput != null) {
            viewer.setInput(viewerInput);
        }
    }

    private class CommonSubActionBars
    extends SubActionBars {
        public CommonSubActionBars(IActionBars parent) {
            super(parent);
        }

        public void setGlobalActionHandler(String actionID, IAction handler) {
            if (handler == null) {
                if (this.getGlobalActionHandler(actionID) != null) {
                    this.getParent().setGlobalActionHandler(actionID, null);
                    super.setGlobalActionHandler(actionID, null);
                }
            } else {
                if (this.getParent().getGlobalActionHandler(actionID) != null) {
                    TeamUIPlugin.log((CoreException)((Object)new TeamException(NLS.bind((String)"Conflicting attempt to set action id {0} detected", (Object)actionID))));
                    return;
                }
                super.setGlobalActionHandler(actionID, handler);
            }
        }

        public void clearGlobalActionHandlers() {
            Map handlers = this.getGlobalActionHandlers();
            if (handlers != null) {
                Set keys = handlers.keySet();
                for (String actionId : keys) {
                    this.getParent().setGlobalActionHandler(actionId, null);
                }
            }
            super.clearGlobalActionHandlers();
        }

        public void updateActionBars() {
            Map newActionHandlers = this.getGlobalActionHandlers();
            if (newActionHandlers != null) {
                Set keys = newActionHandlers.entrySet();
                for (Map.Entry entry : keys) {
                    this.getParent().setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
                }
            }
            super.updateActionBars();
        }
    }

    private class MyDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IFontProvider {
        private final DelegatingStyledCellLabelProvider.IStyledLabelProvider slp;

        public MyDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider slp, ILabelDecorator decorator) {
            super(slp, decorator, null);
            this.slp = slp;
        }

        public StyledString getStyledText(Object element) {
            return this.slp.getStyledText(element);
        }

        public Font getFont(Object element) {
            return super.getFont(element);
        }
    }

    public static final class NavigableCommonViewer
    extends CommonViewer
    implements AbstractTreeViewerAdvisor.ITreeViewerAccessor {
        private final IEmptyTreeListener listener;
        private boolean empty;

        private NavigableCommonViewer(String id, Composite parent, int style, IEmptyTreeListener listener) {
            super(id, parent, style);
            this.listener = listener;
        }

        @Override
        public void createChildren(TreeItem item) {
            super.createChildren((Widget)item);
        }

        @Override
        public void openSelection() {
            this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            TreePath[] expanded = this.getVisibleExpandedPaths();
            super.internalRefresh(element, updateLabels);
            this.setExpandedTreePaths(expanded);
            this.checkForEmptyViewer();
        }

        protected void internalRemove(Object parent, Object[] elements) {
            super.internalRemove(parent, elements);
            if (parent == this.getInput()) {
                this.checkForEmptyViewer();
            }
        }

        protected void internalRemove(Object[] elements) {
            super.internalRemove(elements);
            this.checkForEmptyViewer();
        }

        protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
            super.internalAdd(widget, parentElement, childElements);
            if (this.empty) {
                this.empty = false;
                this.listener.notEmpty((TreeViewer)this);
            }
        }

        protected void inputChanged(Object input, Object oldInput) {
            super.inputChanged(input, oldInput);
            this.checkForEmptyViewer();
        }

        private void checkForEmptyViewer() {
            Widget w;
            Item[] children;
            Object input = this.getInput();
            if (input != null && (children = this.getChildren(w = this.findItem(input))).length == 0) {
                if (!this.empty) {
                    this.empty = true;
                    this.listener.treeEmpty((TreeViewer)this);
                }
                return;
            }
            this.empty = false;
            if (this.listener != null) {
                this.listener.notEmpty((TreeViewer)this);
            }
        }

        public boolean isEmpty() {
            return this.empty;
        }

        protected void initDragAndDrop() {
            this.getNavigatorContentService().getDnDService().bindDragAssistant((CommonDragAdapterAssistant)new ResourceDragAdapterAssistant());
            super.initDragAndDrop();
        }

        public TreePath[] getVisibleExpandedPaths() {
            ArrayList<TreePath> v = new ArrayList<TreePath>();
            this.internalCollectVisibleExpanded(v, (Widget)this.getControl());
            return v.toArray(new TreePath[v.size()]);
        }

        private void internalCollectVisibleExpanded(ArrayList<TreePath> result, Widget widget) {
            Item[] items;
            Item[] itemArray = items = this.getChildren(widget);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                if (this.getExpanded(item)) {
                    TreePath path = this.getTreePathFromItem(item);
                    if (path != null) {
                        result.add(path);
                    }
                    this.internalCollectVisibleExpanded(result, (Widget)item);
                }
                ++n2;
            }
        }
    }
}

