/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.publisher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.p2.metadata.TouchpointInstruction;
import org.eclipse.equinox.internal.p2.publisher.eclipse.BrandingIron;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Repo2Runnable;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.IUDescription;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.Repo2RunnableTask;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.tasks.Config;
import org.eclipse.pde.internal.build.tasks.TaskMessages;

public class BrandP2Task
extends Repo2RunnableTask {
    private Config config = null;
    private String launcherName = null;
    private String tempFolder = null;
    private String iconsList = null;
    private String launcherProvider = null;
    private String productId = null;
    private String productVersion = Version.emptyVersion.toString();
    private URI metadataURI = null;
    private URI artifactURI = null;
    private boolean removeMetadataRepo = true;
    private boolean removeArtifactRepo = true;
    private List<IInstallableUnit> ius = null;
    private static final String CHMOD = "chmod";
    private static final String TARGET_FILE = "targetFile";
    private static final String INSTALL = "install";
    private static final String UNINSTALL = "uninstall";
    private static final String CONFIGURE = "configure";

    public BrandP2Task() {
        this.application = new Repo2Runnable(){

            protected PhaseSet getPhaseSet() {
                return new PhaseSet(new Phase[]{new Collect(100), new Install(100)});
            }

            protected PhaseSet getNativePhase() {
                return null;
            }
        };
    }

    public void execute() {
        IProvisioningAgent agent;
        if (this.launcherName == null || this.launcherName.startsWith("${") || this.config == null) {
            return;
        }
        if (this.launcherProvider == null || this.launcherProvider.startsWith("${")) {
            this.launcherProvider = "org.eclipse.equinox.executable";
        }
        if ((agent = (IProvisioningAgent)BundleHelper.getDefault().acquireService(IProvisioningAgent.class)) == null) {
            throw new BuildException(TaskMessages.error_agentService);
        }
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
        if (metadataManager == null) {
            throw new BuildException(TaskMessages.error_metadataRepoManagerService);
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
        if (artifactManager == null) {
            throw new BuildException(TaskMessages.error_artifactRepoManagerService);
        }
        IMetadataRepository metadataRepo = this.loadMetadataRepository(metadataManager);
        IArtifactRepository artifactRepo = this.loadArtifactRepository(artifactManager);
        try {
            try {
                super.setDestination(this.getRootFolder());
                super.execute();
                if (this.ius.size() == 1) {
                    this.callBrandingIron();
                    this.publishBrandedIU(metadataRepo, artifactRepo, this.ius.get(0));
                    FileUtils.deleteAll((File)new File(this.getRootFolder()));
                }
            }
            catch (BuildException e) {
                this.getProject().log(e.getMessage(), 1);
                this.cleanupRepositories(metadataManager, artifactManager);
                this.ius = null;
            }
        }
        finally {
            this.cleanupRepositories(metadataManager, artifactManager);
            this.ius = null;
        }
    }

    private void cleanupRepositories(IMetadataRepositoryManager metadataManager, IArtifactRepositoryManager artifactManager) {
        URI destination = IPath.fromOSString((String)this.getRootFolder()).toFile().toURI();
        if (metadataManager != null) {
            if (this.removeMetadataRepo) {
                metadataManager.removeRepository(this.metadataURI);
            }
            metadataManager.removeRepository(destination);
        }
        if (artifactManager != null) {
            if (this.removeArtifactRepo) {
                artifactManager.removeRepository(this.artifactURI);
            }
            artifactManager.removeRepository(destination);
        }
    }

    private IArtifactRepository loadArtifactRepository(IArtifactRepositoryManager manager) throws BuildException {
        if (this.artifactURI == null) {
            throw new BuildException(TaskMessages.error_noArtifactRepo);
        }
        this.removeArtifactRepo = !manager.contains(this.artifactURI);
        IArtifactRepository repo = null;
        try {
            repo = manager.loadRepository(this.artifactURI, null);
        }
        catch (ProvisionException e) {
            throw new BuildException(NLS.bind((String)TaskMessages.error_loadRepository, (Object)this.artifactURI.toString()));
        }
        if (!repo.isModifiable()) {
            throw new BuildException(NLS.bind((String)TaskMessages.error_unmodifiableRepository, (Object)this.artifactURI.toString()));
        }
        return repo;
    }

    private IMetadataRepository loadMetadataRepository(IMetadataRepositoryManager manager) throws BuildException {
        if (this.metadataURI == null) {
            throw new BuildException(TaskMessages.error_noMetadataRepo);
        }
        this.removeMetadataRepo = !manager.contains(this.metadataURI);
        IMetadataRepository repo = null;
        try {
            repo = manager.loadRepository(this.metadataURI, null);
        }
        catch (ProvisionException e) {
            throw new BuildException(NLS.bind((String)TaskMessages.error_loadRepository, (Object)this.metadataURI.toString()));
        }
        if (!repo.isModifiable()) {
            throw new BuildException(NLS.bind((String)TaskMessages.error_unmodifiableRepository, (Object)this.metadataURI.toString()));
        }
        return repo;
    }

    protected String getProviderIUName() {
        return this.launcherProvider + "_root." + this.getConfigString();
    }

    protected List<IInstallableUnit> prepareIUs() {
        String iuName = this.getProviderIUName();
        IUDescription task = (IUDescription)super.createIu();
        task.setId(iuName);
        this.ius = super.prepareIUs();
        return this.ius;
    }

    protected void callBrandingIron() {
        if (!new File(this.getRootFolder()).exists()) {
            return;
        }
        BrandingIron iron = new BrandingIron();
        iron.setName(this.launcherName);
        iron.setIcons(this.iconsList);
        iron.setOS(this.config.getOs());
        try {
            iron.brand(ExecutablesDescriptor.createDescriptor((String)this.config.getOs(), (String)this.launcherName, (File)new File(this.getRootFolder())));
        }
        catch (Exception e) {
            this.getProject().log(TaskMessages.error_branding, (Throwable)e, 1);
        }
    }

    protected String getRootFolder() {
        return this.tempFolder + "/p2.branding/" + this.getProviderIUName();
    }

    private String getConfigString() {
        return this.config.getWs() + "." + this.config.getOs() + "." + this.config.getArch();
    }

    protected void publishBrandedIU(IMetadataRepository metadataRepo, IArtifactRepository artifactRepo, IInstallableUnit originalIU) {
        String id = this.productId + "_root." + this.getConfigString();
        Version version = Version.parseVersion((String)this.productVersion);
        if (version.equals(Version.emptyVersion)) {
            version = originalIU.getVersion();
        }
        MetadataFactory.InstallableUnitDescription newIUDescription = new MetadataFactory.InstallableUnitDescription();
        newIUDescription.setSingleton(originalIU.isSingleton());
        newIUDescription.setId(id);
        newIUDescription.setVersion(version);
        newIUDescription.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version)});
        newIUDescription.setTouchpointType(originalIU.getTouchpointType());
        newIUDescription.setFilter(originalIU.getFilter());
        List<ITouchpointData> data = this.brandTouchpointData(originalIU.getTouchpointData());
        for (ITouchpointData element : data) {
            newIUDescription.addTouchpointData(element);
        }
        IArtifactKey key = artifactRepo.createArtifactKey("binary", newIUDescription.getId(), newIUDescription.getVersion());
        newIUDescription.setArtifacts(new IArtifactKey[]{key});
        IInstallableUnit newIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)newIUDescription);
        metadataRepo.addInstallableUnits(Arrays.asList(newIU));
        this.publishBrandedArtifact(artifactRepo, key);
    }

    protected String createLDAPString() {
        Object filter = "(& ";
        filter = (String)filter + "(osgi.ws=" + this.config.getWs() + ")";
        filter = (String)filter + "(osgi.os=" + this.config.getOs() + ")";
        filter = (String)filter + "(osgi.arch=" + this.config.getArch() + ")";
        filter = (String)filter + ")";
        return filter;
    }

    private void publishBrandedArtifact(IArtifactRepository artifactRepo, IArtifactKey key) {
        ArtifactDescriptor descriptor = new ArtifactDescriptor(key);
        ZipOutputStream output = null;
        try {
            try {
                output = new ZipOutputStream(artifactRepo.getOutputStream((IArtifactDescriptor)descriptor));
                File root = new File(this.getRootFolder());
                new File(root, "content.xml").delete();
                new File(root, "artifacts.xml").delete();
                new File(root, "content.jar").delete();
                new File(root, "artifacts.jar").delete();
                FileUtils.zip((ZipOutputStream)output, (File)root, Collections.emptySet(), (FileUtils.IPathComputer)FileUtils.createRootPathComputer((File)root));
            }
            catch (IOException | ProvisionException e) {
                throw new BuildException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Utils.close(output);
            throw throwable;
        }
        Utils.close((Object)output);
    }

    private List<ITouchpointData> brandTouchpointData(Collection<ITouchpointData> data) {
        HashMap<String, TouchpointInstruction> instructions;
        if (this.config.getOs().equals("macosx")) {
            return this.brandMacTouchpointData();
        }
        ArrayList<ITouchpointData> results = new ArrayList<ITouchpointData>(data.size() + 1);
        results.addAll(data);
        boolean haveChmod = false;
        Object brandedLauncher = null;
        brandedLauncher = this.config.getOs().equals("win32") ? this.launcherName + ".exe" : this.launcherName;
        int i = 0;
        while (i < results.size()) {
            String[] phases;
            ITouchpointData td = (ITouchpointData)results.get(i);
            instructions = new HashMap<String, TouchpointInstruction>(td.getInstructions());
            String[] stringArray = phases = new String[]{INSTALL, CONFIGURE};
            int n = phases.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                ITouchpointInstruction instruction = td.getInstruction(element);
                if (instruction != null) {
                    boolean phaseChanged = false;
                    String[] actions = Utils.getArrayFromString((String)instruction.getBody(), (String)";");
                    int j = 0;
                    while (j < actions.length) {
                        if (actions[j].startsWith(CHMOD)) {
                            Map<String, String> map = this.parseAction(actions[j]);
                            String targetFile = map.get(TARGET_FILE);
                            if ((targetFile = targetFile.replace('\\', '/')).equals(brandedLauncher)) {
                                haveChmod = true;
                            } else if (this.config.getOs().equals("win32") && (targetFile.equals("launcher.exe") || targetFile.equals("eclipse.exe")) || targetFile.equals("launcher") || targetFile.equals("eclipse")) {
                                map.put(TARGET_FILE, (String)brandedLauncher);
                                actions[j] = CHMOD + this.toString(map);
                                haveChmod = true;
                                phaseChanged = true;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (phaseChanged) {
                        TouchpointInstruction newInstruction = new TouchpointInstruction(this.toString(actions, ";"), instruction.getImportAttribute());
                        instructions.put(element, newInstruction);
                    }
                }
                ++n2;
            }
            results.set(i, (ITouchpointData)new TouchpointData(instructions));
            ++i;
        }
        if (!haveChmod && !this.config.getOs().equals("win32")) {
            String body = "chmod(targetDir:${installFolder}, targetFile:" + (String)brandedLauncher + ", permissions:755)";
            TouchpointInstruction newInstruction = new TouchpointInstruction(body, null);
            instructions = new HashMap();
            instructions.put(INSTALL, newInstruction);
            results.add((ITouchpointData)new TouchpointData(instructions));
        }
        return results;
    }

    private List<ITouchpointData> brandMacTouchpointData() {
        HashMap<String, ITouchpointInstruction> instructions = new HashMap<String, ITouchpointInstruction>(3);
        instructions.put(INSTALL, this.getMacInstallInstruction());
        instructions.put(UNINSTALL, this.getMacUninstallInstruction());
        ArrayList<ITouchpointData> result = new ArrayList<ITouchpointData>(2);
        result.add((ITouchpointData)new TouchpointData(instructions));
        return result;
    }

    private ITouchpointInstruction getMacUninstallInstruction() {
        return new TouchpointInstruction("cleanupzip(source:@artifact, target:${installFolder}/../);", null);
    }

    private ITouchpointInstruction getMacInstallInstruction() {
        Object body = "unzip(source:@artifact, target:${installFolder}/../);";
        body = (String)body + " chmod(targetDir:${installFolder}/../MacOS/, targetFile:" + this.launcherName + ", permissions:755);";
        return new TouchpointInstruction((String)body, null);
    }

    private String toString(String[] elements, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(elements[i]);
            if (i < elements.length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String toString(Map<String, String> map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            buffer.append(key);
            buffer.append(':');
            buffer.append(map.get(key));
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    private Map<String, String> parseAction(String action) {
        String[] parameters;
        HashMap<String, String> result = new HashMap<String, String>();
        int open = action.indexOf(40);
        int close = action.lastIndexOf(41);
        String parameterString = action.substring(open + 1, close);
        String[] stringArray = parameters = Utils.getArrayFromString((String)parameterString, (String)",");
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            int colon = parameter.indexOf(58);
            result.put(parameter.substring(0, colon).trim(), parameter.substring(colon + 1).trim());
            ++n2;
        }
        return result;
    }

    public void setConfig(String config) {
        if (config == null || config.startsWith("${")) {
            return;
        }
        String[] elements = Utils.getArrayFromStringWithBlank((String)config, (String)".");
        if (elements.length != 3) {
            throw new BuildException(NLS.bind((String)TaskMessages.error_invalidConfig, (Object)config));
        }
        this.config = new Config(elements);
    }

    public void setLauncherName(String launcherName) {
        this.launcherName = launcherName;
    }

    public void setLauncherProvider(String launcherProvider) {
        this.launcherProvider = launcherProvider;
    }

    public void setIconsList(String iconsList) {
        this.iconsList = iconsList;
    }

    public void setTempDirectory(String temp) {
        this.tempFolder = temp;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setProductVersion(String productVersion) {
        if (productVersion != null && !productVersion.startsWith("${")) {
            this.productVersion = productVersion;
        }
    }

    public void setRepository(String location) {
        this.setMetadataRepository(location);
        this.setArtifactRepository(location);
    }

    public void setMetadataRepository(String location) {
        try {
            this.metadataURI = URIUtil.fromString((String)location);
            super.addMetadataSourceRepository(this.metadataURI, false);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Metadata repository location (" + location + ") must be a URI.");
        }
    }

    public void setArtifactRepository(String location) {
        try {
            this.artifactURI = URIUtil.fromString((String)location);
            super.addArtifactSourceRepository(this.artifactURI, false);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Artifact repository location (" + location + ") must be a URI.");
        }
    }
}

