/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

@Deprecated
public abstract class Parser
implements CommandLineParser {
    protected CommandLine cmd;
    private Options options;
    private List requiredOptions;

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.getRequiredOptions().isEmpty()) {
            throw new MissingOptionException(this.getRequiredOptions());
        }
    }

    protected abstract String[] flatten(Options var1, String[] var2, boolean var3) throws ParseException;

    protected Options getOptions() {
        return this.options;
    }

    protected List getRequiredOptions() {
        return this.requiredOptions;
    }

    @Override
    public CommandLine parse(Options options, String[] arguments) throws ParseException {
        return this.parse(options, arguments, null, false);
    }

    @Override
    public CommandLine parse(Options options, String[] arguments, boolean stopAtNonOption) throws ParseException {
        return this.parse(options, arguments, null, stopAtNonOption);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties) throws ParseException {
        return this.parse(options, arguments, properties, false);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
        options.helpOptions().forEach(Option::clearValues);
        for (OptionGroup optionGroup : options.getOptionGroups()) {
            optionGroup.setSelected(null);
        }
        this.setOptions(options);
        this.cmd = CommandLine.builder().get();
        boolean eatTheRest = false;
        List<String> tokenList = Arrays.asList(this.flatten(this.getOptions(), arguments == null ? Util.EMPTY_STRING_ARRAY : arguments, stopAtNonOption));
        ListIterator<String> iterator = tokenList.listIterator();
        while (iterator.hasNext()) {
            String token = iterator.next();
            if (token == null) continue;
            if ("--".equals(token)) {
                eatTheRest = true;
            } else if ("-".equals(token)) {
                if (stopAtNonOption) {
                    eatTheRest = true;
                } else {
                    this.cmd.addArg(token);
                }
            } else if (token.startsWith("-")) {
                if (stopAtNonOption && !this.getOptions().hasOption(token)) {
                    eatTheRest = true;
                    this.cmd.addArg(token);
                } else {
                    this.processOption(token, iterator);
                }
            } else {
                this.cmd.addArg(token);
                if (stopAtNonOption) {
                    eatTheRest = true;
                }
            }
            if (!eatTheRest) continue;
            iterator.forEachRemaining(str -> {
                if (!"--".equals(str)) {
                    this.cmd.addArg((String)str);
                }
            });
        }
        this.processProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    public void processArgs(Option opt, ListIterator<String> iter) throws ParseException {
        while (iter.hasNext()) {
            String str = iter.next();
            if (this.getOptions().hasOption(str) && str.startsWith("-")) {
                iter.previous();
                break;
            }
            try {
                opt.processValue(Util.stripLeadingAndTrailingQuotes(str));
            }
            catch (RuntimeException exp) {
                iter.previous();
                break;
            }
        }
        if (opt.isValuesEmpty() && !opt.hasOptionalArg()) {
            throw new MissingArgumentException(opt);
        }
    }

    protected void processOption(String arg, ListIterator<String> iter) throws ParseException {
        boolean hasOption = this.getOptions().hasOption(arg);
        if (!hasOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + arg, arg);
        }
        Option opt = (Option)this.getOptions().getOption(arg).clone();
        this.updateRequiredOptions(opt);
        if (opt.hasArg()) {
            this.processArgs(opt, iter);
        }
        this.cmd.addOption(opt);
    }

    protected void processProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option = e.nextElement().toString();
            Option opt = this.options.getOption(option);
            if (opt == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option);
            }
            OptionGroup optionGroup = this.options.getOptionGroup(opt);
            boolean bl = selected = optionGroup != null && optionGroup.isSelected();
            if (this.cmd.hasOption(option) || selected) continue;
            String value = properties.getProperty(option);
            if (opt.hasArg()) {
                if (opt.isValuesEmpty()) {
                    try {
                        opt.processValue(value);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            } else if (!"yes".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) continue;
            this.cmd.addOption(opt);
            this.updateRequiredOptions(opt);
        }
    }

    protected void setOptions(Options options) {
        this.options = options;
        this.requiredOptions = new ArrayList(options.getRequiredOptions());
    }

    private void updateRequiredOptions(Option opt) throws ParseException {
        if (opt.isRequired()) {
            this.getRequiredOptions().remove(opt.getKey());
        }
        if (this.getOptions().getOptionGroup(opt) != null) {
            OptionGroup optionGroup = this.getOptions().getOptionGroup(opt);
            if (optionGroup.isRequired()) {
                this.getRequiredOptions().remove(optionGroup);
            }
            optionGroup.setSelected(opt);
        }
    }
}

