/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class AddAnnotationProposal
implements IJavaCompletionProposal {
    private final IInvocationContext fContext;
    private final MethodDeclaration fMethodDecl;
    private final String fAnnotationQualifiedName;
    private final String fAnnotationSimpleName;

    public AddAnnotationProposal(IInvocationContext context, MethodDeclaration methodDecl, String annotationQualifiedName, String annotationSimpleName) {
        this.fContext = context;
        this.fMethodDecl = methodDecl;
        this.fAnnotationQualifiedName = annotationQualifiedName;
        this.fAnnotationSimpleName = annotationSimpleName;
    }

    public void apply(IDocument document) {
        try {
            CompilationUnit astRoot = this.fContext.getASTRoot();
            ICompilationUnit cu = this.fContext.getCompilationUnit();
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName(ast.newName(this.fAnnotationSimpleName));
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.fMethodDecl, MethodDeclaration.MODIFIERS2_PROPERTY);
            listRewrite.insertFirst((ASTNode)annotation, null);
            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
            importRewrite.addImport(this.fAnnotationQualifiedName);
            MultiTextEdit multiEdit = new MultiTextEdit();
            TextEdit importEdit = importRewrite.rewriteImports(null);
            if (importEdit.hasChildren() || importEdit.getLength() != 0) {
                multiEdit.addChild(importEdit);
            }
            TextEdit rewriteEdit = rewrite.rewriteAST(document, cu.getOptions(true));
            multiEdit.addChild(rewriteEdit);
            multiEdit.apply(document);
        }
        catch (CoreException | BadLocationException e) {
            JUnitPlugin.log(e);
        }
    }

    public String getAdditionalProposalInfo() {
        return MessageFormat.format(JUnitMessages.JUnitQuickAssistProcessor_add_annotation_info, this.fAnnotationSimpleName);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return MessageFormat.format(JUnitMessages.JUnitQuickAssistProcessor_add_annotation_description, this.fAnnotationSimpleName);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public int getRelevance() {
        return 10;
    }
}

