/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSCharsetRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSDeclarationItemParser;
import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSFontFaceRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSImportRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSMediaRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelCreationContext;
import org.eclipse.wst.css.core.internal.document.CSSModelDeletionContext;
import org.eclipse.wst.css.core.internal.document.CSSModelImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelNodeFeeder;
import org.eclipse.wst.css.core.internal.document.CSSModelUpdateContext;
import org.eclipse.wst.css.core.internal.document.CSSModelUtil;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSNodeListImpl;
import org.eclipse.wst.css.core.internal.document.CSSPageRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSRuleDeclContainer;
import org.eclipse.wst.css.core.internal.document.CSSRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclItemImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclarationImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleRuleImpl;
import org.eclipse.wst.css.core.internal.document.MediaListImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSRuleContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.text.StructuredDocumentWalker;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.text.CoreNodeList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSModelParser {
    private ICSSDocument fDocument = null;
    private CSSModelCreationContext fCreationContext = null;
    private CSSModelDeletionContext fDeletionContext = null;
    private CSSModelUpdateContext fUpdateContext = null;
    private CSSModelNodeFeeder fFeeder = null;
    private StructuredDocumentWalker fStructuredDocumentWalker = null;
    private boolean fParseFloating = false;

    private CSSModelParser() {
    }

    protected boolean isParseFloating() {
        return this.fParseFloating;
    }

    protected CSSModelCreationContext getCreationContext() {
        return this.fCreationContext;
    }

    protected boolean isUpdateContextActive() {
        return this.fUpdateContext != null ? this.fUpdateContext.isActive() : false;
    }

    public CSSModelParser(ICSSDocument doc) {
        this();
        this.fDocument = doc;
        this.fCreationContext = new CSSModelCreationContext((CSSNodeImpl)((Object)doc));
        this.fDeletionContext = new CSSModelDeletionContext(doc);
        this.fUpdateContext = new CSSModelUpdateContext();
        this.fFeeder = new CSSModelNodeFeeder(doc, this.fUpdateContext);
    }

    void changeStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.replaceStructuredDocumentRegions((IStructuredDocumentRegionList)new CoreNodeList(flatNode, flatNode), (IStructuredDocumentRegionList)new CoreNodeList(flatNode, flatNode));
    }

    void changeRegion(IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (flatNode == null || region == null) {
            return;
        }
        if (this.fDocument == null) {
            return;
        }
        this.changeStructuredDocumentRegion(flatNode);
    }

    private void checkNextNode(IStructuredDocumentRegion flatNode, String type) {
        IStructuredDocumentRegion next = CSSUtil.findNextSignificantNode(flatNode);
        if (CSSUtil.getStructuredDocumentRegionType(next) == type) {
            this.fCreationContext.setReparseStart(flatNode.getEnd());
            this.fCreationContext.setReparseEnd(next.getEnd());
        }
    }

    private void cleanupDeletionContext() {
    }

    boolean cleanupFirstNode(IStructuredDocumentRegion firstNode, CSSStructuredDocumentRegionContainer target) {
        if (firstNode == null || target == null) {
            return false;
        }
        if (firstNode == target.getFirstStructuredDocumentRegion()) {
            IStructuredDocumentRegion nextNode = this.fStructuredDocumentWalker.getNextNodeInCurrent(firstNode);
            IStructuredDocumentRegion lastNode = target.getLastStructuredDocumentRegion();
            if (lastNode == null || this.fStructuredDocumentWalker.isOldNode(lastNode) || nextNode == null || lastNode.getStartOffset() < nextNode.getStartOffset()) {
                target.setRangeStructuredDocumentRegion(null, null);
            } else {
                target.setFirstStructuredDocumentRegion(nextNode);
            }
            ICSSNode parent = target.getParentNode();
            if (parent instanceof CSSStructuredDocumentRegionContainer) {
                this.cleanupFirstNode(firstNode, (CSSStructuredDocumentRegionContainer)parent);
                return true;
            }
        }
        return false;
    }

    boolean cleanupLastNode(IStructuredDocumentRegion lastNode, CSSStructuredDocumentRegionContainer target) {
        if (lastNode == null || target == null) {
            return false;
        }
        if (lastNode == target.getLastStructuredDocumentRegion()) {
            IStructuredDocumentRegion prevNode = this.fStructuredDocumentWalker.getPrevNodeInCurrent(lastNode);
            IStructuredDocumentRegion firstNode = target.getFirstStructuredDocumentRegion();
            if (firstNode == null || this.fStructuredDocumentWalker.isOldNode(firstNode) || prevNode == null || prevNode.getStartOffset() < firstNode.getStartOffset()) {
                target.setRangeStructuredDocumentRegion(null, null);
            } else {
                target.setLastStructuredDocumentRegion(prevNode);
            }
            ICSSNode parent = target.getParentNode();
            if (parent instanceof CSSStructuredDocumentRegionContainer) {
                this.cleanupLastNode(lastNode, (CSSStructuredDocumentRegionContainer)parent);
                return true;
            }
        }
        return false;
    }

    int cleanupUpdateContext() {
        int remains = this.fUpdateContext.getNodeCount();
        this.fUpdateContext.cleanupContext();
        return remains;
    }

    CSSRule createCSSRule(IStructuredDocumentRegionList flatNodes) {
        if (flatNodes == null) {
            return null;
        }
        this.fParseFloating = true;
        this.fCreationContext.clear();
        this.fCreationContext.setTargetNode(null);
        this.fCreationContext.setNextNode(null);
        CSSRuleImpl parentRule = null;
        Enumeration e = flatNodes.elements();
        while (e.hasMoreElements()) {
            IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
            if (flatNode == null) continue;
            CSSNodeImpl modified = this.insertStructuredDocumentRegion(flatNode);
            if (parentRule != null || !(modified instanceof CSSRuleImpl)) continue;
            parentRule = (CSSRuleImpl)modified;
        }
        this.fParseFloating = false;
        if (parentRule != null) {
            CSSModelUtil.cleanupContainer(parentRule);
        }
        return parentRule;
    }

    private IStructuredDocumentRegion findBraceClose(int depth, IStructuredDocumentRegion start, boolean bBreakSibling) {
        IStructuredDocumentRegion result = null;
        int braceLevel = 0;
        IStructuredDocumentRegion prevNode = null;
        IStructuredDocumentRegion region = start.getNext();
        while (region != null) {
            String type;
            int depthHit;
            int offset = region.getStart();
            if (offset < 0) {
                Assert.isTrue((boolean)false);
                break;
            }
            CSSNodeImpl node = this.getNodeAt(offset);
            int n = depthHit = node != null ? CSSModelUtil.getDepth(node) : -1;
            if (depth <= depthHit) {
                if (bBreakSibling) {
                    CSSNodeImpl parent = (CSSNodeImpl)node.getParentNode();
                    while (depth <= CSSModelUtil.getDepth(parent)) {
                        node = parent;
                        parent = (CSSNodeImpl)parent.getParentNode();
                    }
                    if (parent != null && node != null) {
                        parent.removeChild(node);
                    }
                } else {
                    result = prevNode;
                    break;
                }
            }
            if ((type = CSSUtil.getStructuredDocumentRegionType(region)) == "LBRACE") {
                ++braceLevel;
            }
            if (type == "RBRACE" && --braceLevel < 0) {
                result = region;
                break;
            }
            prevNode = region;
            region = region.getNext();
        }
        if (result == null && region == null) {
            result = prevNode;
        }
        return result;
    }

    private IStructuredDocumentRegionList getStructuredDocumentRegionList(int start, int end) {
        IStructuredDocument structuredDocument;
        ICSSModel model;
        CoreNodeList nodeList = null;
        if (start >= 0 && start <= end && (model = this.fDocument.getModel()) instanceof CSSModelImpl && (structuredDocument = ((CSSModelImpl)model).getStructuredDocument()) != null) {
            IStructuredDocumentRegion startNode = structuredDocument.getRegionAtCharacterOffset(start);
            IStructuredDocumentRegion endNode = structuredDocument.getRegionAtCharacterOffset(end - 1);
            if (startNode != null && endNode != null) {
                nodeList = new CoreNodeList(startNode, endNode);
            }
        }
        return nodeList;
    }

    private CSSNodeImpl getNodeAt(int offset) {
        CSSNodeImpl rootNode = this.fCreationContext.getRootNode();
        ICSSNode target = rootNode.getNodeAt(offset);
        if (target instanceof CSSNodeImpl) {
            return (CSSNodeImpl)target;
        }
        return null;
    }

    private CSSNodeImpl insertBraceClose(IStructuredDocumentRegion region) {
        ICSSNode target = CSSModelUtil.findBraceContainer(this.fCreationContext.getTargetNode());
        if (!(target instanceof CSSStructuredDocumentRegionContainer)) {
            return null;
        }
        CSSStructuredDocumentRegionContainer parent = (CSSStructuredDocumentRegionContainer)target;
        if (CSSModelUtil.isInterruption(parent, region)) {
            ICSSNode node = parent.getParentNode();
            if (node instanceof CSSNodeImpl) {
                this.fCreationContext.setReparseStart(parent.getStartOffset());
                this.fCreationContext.setReparseEnd(parent.getEndOffset());
                ((CSSNodeImpl)node).removeChild(parent);
            }
            return null;
        }
        if (parent instanceof ICSSPageRule || parent instanceof ICSSMediaRule || parent instanceof CSSFontFaceRule || parent instanceof ICSSStyleRule) {
            CSSModelUtil.expandStructuredDocumentRegionContainer(parent, region);
            if (!CSSModelUtil.isBraceClosed(target)) {
                this.fCreationContext.setTargetNode(parent.getParentNode());
                this.fCreationContext.setNextNode(parent.getNextSibling());
                return parent;
            }
        }
        return null;
    }

    private CSSNodeImpl insertBraceOpen(IStructuredDocumentRegion region) {
        IStructuredDocumentRegion braceClose;
        CSSNodeImpl node;
        IStructuredDocumentRegion keyRegion = CSSUtil.findPreviousSignificantNode(region);
        if (keyRegion == null) {
            return null;
        }
        if (!this.fParseFloating && (node = this.getNodeAt(keyRegion.getStartOffset())) != null && !(node instanceof ICSSRuleContainer)) {
            return null;
        }
        String type = CSSUtil.getStructuredDocumentRegionType(keyRegion);
        CSSNodeImpl inserted = null;
        if (type == "PAGE") {
            inserted = this.insertPageRule(keyRegion, region);
        } else if (type == "MEDIA") {
            inserted = this.insertMediaRule(keyRegion, region);
        } else if (type == "FONT_FACE") {
            inserted = this.insertFontFaceRule(keyRegion, region);
        } else if (CSSUtil.isSelectorText(keyRegion)) {
            inserted = this.insertStyleRule(keyRegion, region);
        }
        if (inserted instanceof CSSStructuredDocumentRegionContainer && (braceClose = this.findBraceClose(CSSModelUtil.getDepth(inserted), region, type == "MEDIA")) != null) {
            this.fCreationContext.setReparseStart(region.getEnd());
            this.fCreationContext.setReparseEnd(braceClose.getEnd());
        }
        return inserted;
    }

    private CSSNodeImpl insertCharsetRule(IStructuredDocumentRegion beginDocRegion, IStructuredDocumentRegion endDocRegion) {
        CSSNodeImpl parent = this.fCreationContext.getTargetNode();
        if (!this.fParseFloating && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        TextRegionListImpl regions = new TextRegionListImpl(beginDocRegion.getRegions());
        regions.remove(0);
        ITextRegion encodingRegion = null;
        while (!regions.isEmpty()) {
            String type;
            ITextRegion textRegion = regions.remove(0);
            if (textRegion == null || (type = textRegion.getType()) == "S" || type == "COMMENT") continue;
            if (type != "STRING") break;
            encodingRegion = textRegion;
            break;
        }
        if (encodingRegion == null) {
            return null;
        }
        CSSCharsetRuleImpl rule = this.fFeeder.getCSSCharsetRule();
        if (rule == null) {
            return null;
        }
        if (!this.fUpdateContext.isActive()) {
            rule.setAttribute("encoding", beginDocRegion.getText(encodingRegion));
        }
        rule.setRangeStructuredDocumentRegion(beginDocRegion, endDocRegion);
        CSSAttrImpl attr = rule.getAttributeNode("encoding");
        if (attr != null) {
            attr.setRangeRegion(beginDocRegion, encodingRegion, encodingRegion);
        }
        if (!this.fUpdateContext.isActive() && parent != null) {
            this.propagateRangePreInsert(parent, rule);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(rule, next);
            } else {
                parent.appendChild(rule);
            }
        }
        return rule;
    }

    protected CSSNodeImpl insertStructuredDocumentRegion(IStructuredDocumentRegion region) {
        if (this.fCreationContext == null || region == null) {
            return null;
        }
        String type = ((BasicStructuredDocumentRegion)region).getType();
        CSSNodeImpl modified = null;
        CSSNodeImpl target = this.fCreationContext.getTargetNode();
        if (this.fParseFloating && target == null || target instanceof ICSSRuleContainer) {
            if (type == "DELIMITER") {
                modified = this.insertSemiColonForRule(region);
            } else if (type == "LBRACE") {
                modified = this.insertBraceOpen(region);
            } else if (type == "RBRACE") {
                modified = this.insertBraceClose(region);
            } else if (type == "MEDIA" || type == "PAGE" || type == "FONT_FACE" || CSSUtil.isSelectorText(region)) {
                this.checkNextNode(region, "LBRACE");
            } else if (type == "IMPORT" || type == "CHARSET") {
                this.checkNextNode(region, "DELIMITER");
            }
        } else if ((target instanceof CSSRuleDeclContainer || target instanceof CSSStyleDeclaration) && type == "DECLARATION_PROPERTY") {
            modified = this.insertStyleDeclarationItem(region);
        } else if (target instanceof ICSSStyleDeclItem && type == "DECLARATION_DELIMITER") {
            modified = this.insertSemiColonForStyleDeclarationItem(region);
        } else if (type == "RBRACE") {
            modified = this.insertBraceClose(region);
        }
        if (modified != null && modified instanceof CSSStructuredDocumentRegionContainer) {
            ((CSSStructuredDocumentRegionContainer)modified).propagateRangeStructuredDocumentRegion();
        }
        return modified;
    }

    private void insertStructuredDocumentRegions(IStructuredDocumentRegionList regionList) {
        Enumeration e = regionList.elements();
        while (e.hasMoreElements()) {
            IStructuredDocumentRegion region = (IStructuredDocumentRegion)e.nextElement();
            if (region == null) continue;
            this.insertStructuredDocumentRegion(region);
            if (!this.fCreationContext.isToReparse()) continue;
            int origStart = region.getEnd();
            int origEnd = regionList.item(regionList.getLength() - 1).getEnd();
            int newStart = this.fCreationContext.getReparseStart();
            int newEnd = this.fCreationContext.getReparseEnd();
            if (newStart < origStart || origEnd < newEnd) {
                IStructuredDocumentRegionList newNodeList = this.getStructuredDocumentRegionList(newStart, newEnd);
                this.setupCreationContext(newNodeList.item(0));
                this.insertStructuredDocumentRegions(newNodeList);
                return;
            }
            this.fCreationContext.resetReparseRange();
        }
    }

    private CSSNodeImpl insertFontFaceRule(IStructuredDocumentRegion region, IStructuredDocumentRegion braceNode) {
        CSSNodeImpl parent = this.fCreationContext.getTargetNode();
        if (!this.fParseFloating && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        CSSFontFaceRuleImpl rule = this.fFeeder.getCSSFontFaceRule();
        if (rule == null) {
            return null;
        }
        rule.setRangeStructuredDocumentRegion(region, braceNode);
        if (!this.fUpdateContext.isActive() && parent != null) {
            this.propagateRangePreInsert(parent, rule);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(rule, next);
            } else {
                parent.appendChild(rule);
            }
        }
        this.fCreationContext.setTargetNode(rule);
        return rule;
    }

    private CSSNodeImpl insertImportRule(IStructuredDocumentRegion beginDocRegion, IStructuredDocumentRegion endDocRegion) {
        CSSNodeImpl parent = this.fCreationContext.getTargetNode();
        if (!this.fParseFloating && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        TextRegionListImpl regions = new TextRegionListImpl(beginDocRegion.getRegions());
        regions.remove(0);
        ITextRegion hrefRegion = null;
        while (!regions.isEmpty()) {
            String type;
            ITextRegion textRegion = regions.remove(0);
            if (textRegion == null || (type = textRegion.getType()) == "S" || type == "COMMENT") continue;
            if (type != "URI" && type != "STRING") break;
            hrefRegion = textRegion;
            break;
        }
        if (hrefRegion == null) {
            return null;
        }
        CSSImportRuleImpl rule = this.fFeeder.getCSSImportRule();
        if (rule == null) {
            return null;
        }
        CSSUtil.stripSurroundingSpace((ITextRegionList)regions);
        MediaListImpl mediaList = (MediaListImpl)rule.getMedia();
        this.setMediaList(mediaList, beginDocRegion, (ITextRegionList)regions);
        if (!this.fUpdateContext.isActive()) {
            rule.setAttribute("href", beginDocRegion.getText(hrefRegion));
        }
        rule.setRangeStructuredDocumentRegion(beginDocRegion, endDocRegion);
        CSSAttrImpl attr = rule.getAttributeNode("href");
        if (attr != null) {
            attr.setRangeRegion(beginDocRegion, hrefRegion, hrefRegion);
        }
        if (!this.fUpdateContext.isActive() && parent != null) {
            this.propagateRangePreInsert(parent, rule);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(rule, next);
            } else {
                parent.appendChild(rule);
            }
        }
        return rule;
    }

    private CSSNodeImpl insertMediaRule(IStructuredDocumentRegion flatNode, IStructuredDocumentRegion braceNode) {
        CSSNodeImpl parent = this.fCreationContext.getTargetNode();
        if (!this.fParseFloating && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        CSSMediaRuleImpl rule = this.fFeeder.getCSSMediaRule();
        if (rule == null) {
            return null;
        }
        TextRegionListImpl regions = new TextRegionListImpl(flatNode.getRegions());
        regions.remove(0);
        CSSUtil.stripSurroundingSpace((ITextRegionList)regions);
        MediaListImpl mediaList = (MediaListImpl)rule.getMedia();
        this.setMediaList(mediaList, flatNode, (ITextRegionList)regions);
        rule.setRangeStructuredDocumentRegion(flatNode, braceNode);
        if (!this.fUpdateContext.isActive() && parent != null) {
            this.propagateRangePreInsert(parent, rule);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(rule, next);
            } else {
                parent.appendChild(rule);
            }
        }
        this.fCreationContext.setTargetNode(rule);
        return rule;
    }

    private CSSNodeImpl insertPageRule(IStructuredDocumentRegion flatNode, IStructuredDocumentRegion braceNode) {
        String selectorStr;
        CSSNodeImpl parent = this.fCreationContext.getTargetNode();
        if (!this.fParseFloating && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        TextRegionListImpl selectorRegions = new TextRegionListImpl(flatNode.getRegions());
        selectorRegions.remove(0);
        CSSUtil.stripSurroundingSpace((ITextRegionList)selectorRegions);
        CSSPageRuleImpl rule = this.fFeeder.getCSSPageRule();
        if (rule == null) {
            return null;
        }
        if (!this.fUpdateContext.isActive() && (selectorStr = CSSUtil.getRegionText(flatNode, (ITextRegionList)selectorRegions)).length() > 0) {
            rule.setSelectorText(selectorStr);
        }
        rule.setRangeStructuredDocumentRegion(flatNode, braceNode);
        CSSAttrImpl attr = rule.getAttributeNode("selector");
        if (attr != null && selectorRegions != null && !selectorRegions.isEmpty()) {
            attr.setRangeRegion(flatNode, selectorRegions.get(0), selectorRegions.get(selectorRegions.size() - 1));
        }
        if (!this.fUpdateContext.isActive() && parent != null) {
            this.propagateRangePreInsert(parent, rule);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(rule, next);
            } else {
                parent.appendChild(rule);
            }
        }
        this.fCreationContext.setTargetNode(rule);
        return rule;
    }

    private CSSNodeImpl insertSemiColonForRule(IStructuredDocumentRegion region) {
        IStructuredDocumentRegion keyRegion = CSSUtil.findPreviousSignificantNode(region);
        String type = CSSUtil.getStructuredDocumentRegionType(keyRegion);
        CSSNodeImpl inserted = null;
        if (type == "IMPORT") {
            inserted = this.insertImportRule(keyRegion, region);
        } else if (type == "CHARSET") {
            inserted = this.insertCharsetRule(keyRegion, region);
        }
        return inserted;
    }

    private CSSNodeImpl insertSemiColonForStyleDeclarationItem(IStructuredDocumentRegion region) {
        CSSNodeImpl targetNode = this.fCreationContext.getTargetNode();
        if (targetNode instanceof ICSSStyleDeclItem) {
            int offset = targetNode.getStartOffset();
            CSSModelUtil.expandStructuredDocumentRegionContainer((CSSStyleDeclItemImpl)targetNode, region);
            ICSSNode parentNode = targetNode.getParentNode();
            this.fCreationContext.setTargetNode(parentNode);
            ICSSNode next = null;
            if (parentNode.hasChildNodes()) {
                ICSSNode child = targetNode.getFirstChild();
                while (child != null) {
                    if (child instanceof CSSStructuredDocumentRegionContainer && offset < ((CSSStructuredDocumentRegionContainer)child).getStartOffset()) {
                        next = child;
                        break;
                    }
                    child = child.getNextSibling();
                }
            }
            this.fCreationContext.setNextNode(next);
            return targetNode;
        }
        return null;
    }

    private CSSNodeImpl insertStyleDeclarationItem(IStructuredDocumentRegion docRegion) {
        CSSStyleDeclarationImpl parent = null;
        CSSNodeImpl node = this.fCreationContext.getTargetNode();
        if (node instanceof CSSRuleDeclContainer) {
            CSSRuleDeclContainer declContainer = (CSSRuleDeclContainer)node;
            parent = (CSSStyleDeclarationImpl)declContainer.getStyle();
        } else if (node instanceof CSSStyleDeclarationImpl) {
            parent = (CSSStyleDeclarationImpl)node;
        }
        CSSDeclarationItemParser itemParser = new CSSDeclarationItemParser(parent.getOwnerDocument());
        itemParser.setStructuredDocumentTemporary(false);
        itemParser.setUpdateContext(this.fUpdateContext);
        CSSStyleDeclItemImpl declItem = itemParser.setupDeclarationItem(docRegion);
        if (declItem == null) {
            return null;
        }
        declItem.setRangeStructuredDocumentRegion(docRegion, docRegion);
        if (!this.fUpdateContext.isActive()) {
            this.propagateRangePreInsert(parent, declItem);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(declItem, next);
            } else {
                parent.appendChild(declItem);
            }
        }
        this.fCreationContext.setTargetNode(declItem);
        return declItem;
    }

    private CSSNodeImpl insertStyleRule(IStructuredDocumentRegion flatNode, IStructuredDocumentRegion braceNode) {
        String selectorStr;
        CSSNodeImpl parent = this.fCreationContext.getTargetNode();
        if (!this.fParseFloating && !(parent instanceof ICSSRuleContainer)) {
            return null;
        }
        TextRegionListImpl selectorRegions = new TextRegionListImpl(flatNode.getRegions());
        CSSUtil.stripSurroundingSpace((ITextRegionList)selectorRegions);
        CSSStyleRuleImpl rule = this.fFeeder.getCSSStyleRule();
        if (rule == null) {
            return null;
        }
        if (!this.fUpdateContext.isActive() && (selectorStr = CSSUtil.getRegionText(flatNode, (ITextRegionList)selectorRegions)) != null && selectorStr.length() > 0) {
            rule.setSelectorText(selectorStr);
        }
        rule.setRangeStructuredDocumentRegion(flatNode, braceNode);
        CSSAttrImpl attr = rule.getAttributeNode("selector");
        if (attr != null && selectorRegions != null && !selectorRegions.isEmpty()) {
            attr.setRangeRegion(flatNode, selectorRegions.get(0), selectorRegions.get(selectorRegions.size() - 1));
        }
        if (!this.fUpdateContext.isActive() && parent != null) {
            this.propagateRangePreInsert(parent, rule);
            CSSNodeImpl next = this.fCreationContext.getNextNode();
            if (next != null) {
                parent.insertBefore(rule, next);
            } else {
                parent.appendChild(rule);
            }
        }
        this.fCreationContext.setTargetNode(rule);
        return rule;
    }

    private void pretendRemoveNode() {
        IStructuredDocumentRegion lastNode;
        CSSStructuredDocumentRegionContainer node = (CSSStructuredDocumentRegionContainer)this.fUpdateContext.getDeletionTarget();
        if (node == null) {
            return;
        }
        IStructuredDocumentRegion firstNode = node.getFirstStructuredDocumentRegion();
        if (firstNode != null) {
            this.fDeletionContext.expandRemovedRangeBegin(firstNode);
        }
        if ((lastNode = node.getLastStructuredDocumentRegion()) != null) {
            this.fDeletionContext.expandRemovedRangeEnd(lastNode);
        }
        this.shrinkContainer((CSSStructuredDocumentRegionContainer)this.fUpdateContext.getDeletionTargetParent(), node);
    }

    protected void propagateRangePreInsert(CSSNodeImpl parent, CSSNodeImpl child) {
        if (!(child instanceof CSSStructuredDocumentRegionContainer) || !(parent instanceof CSSStructuredDocumentRegionContainer)) {
            return;
        }
        CSSStructuredDocumentRegionContainer parentContainer = (CSSStructuredDocumentRegionContainer)parent;
        CSSStructuredDocumentRegionContainer childContainer = (CSSStructuredDocumentRegionContainer)child;
        IStructuredDocumentRegion firstNode = childContainer.getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion lastNode = childContainer.getLastStructuredDocumentRegion();
        if (firstNode == null || lastNode == null) {
            return;
        }
        boolean bModified = parentContainer.includeRangeStructuredDocumentRegion(firstNode, lastNode);
        if (bModified) {
            parentContainer.propagateRangeStructuredDocumentRegion();
        }
    }

    private void removeStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        String type = CSSUtil.getStructuredDocumentRegionType(flatNode);
        if (type == "DELIMITER" || type == "DECLARATION_DELIMITER") {
            do {
                String string = type = (flatNode = this.fStructuredDocumentWalker.getPrevNode(flatNode)) != null ? CSSUtil.getStructuredDocumentRegionType(flatNode) : null;
            } while (type != null && (type == "S" || type == "COMMENT"));
        }
        if (flatNode == null) {
            return;
        }
        CSSStructuredDocumentRegionContainer node = this.fDeletionContext.findDeletionTarget((CSSNodeImpl)((Object)this.fDocument), flatNode);
        if (node == null || node == this.fDocument) {
            return;
        }
        if (node instanceof CSSStyleDeclarationImpl) {
            ICSSNode rule = node.getParentNode();
            if (rule instanceof CSSStyleRuleImpl) {
                node = (CSSStructuredDocumentRegionContainer)rule;
            } else {
                return;
            }
        }
        if (this.fDeletionContext.addNodeToBeRemoved(node)) {
            IStructuredDocumentRegion lastNode;
            IStructuredDocumentRegion firstNode = node.getFirstStructuredDocumentRegion();
            if (firstNode != null) {
                this.fDeletionContext.expandRemovedRangeBegin(firstNode);
            }
            if ((lastNode = node.getLastStructuredDocumentRegion()) != null) {
                this.fDeletionContext.expandRemovedRangeEnd(lastNode);
            }
        }
    }

    private void removeStructuredDocumentRegions(IStructuredDocumentRegionList flatNodes) {
        Enumeration e = flatNodes.elements();
        while (e.hasMoreElements()) {
            IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
            if (flatNode == null) continue;
            this.removeStructuredDocumentRegion(flatNode);
        }
        Iterator i = this.fDeletionContext.getNodesToBeRemoved();
        while (i.hasNext()) {
            CSSNodeImpl parent;
            CSSNodeImpl node = (CSSNodeImpl)i.next();
            if (!(node instanceof CSSStructuredDocumentRegionContainer) || !((parent = (CSSNodeImpl)node.getParentNode()) instanceof CSSStructuredDocumentRegionContainer)) continue;
            this.shrinkContainer((CSSStructuredDocumentRegionContainer)parent, (CSSStructuredDocumentRegionContainer)node);
            parent.removeChild(node);
        }
    }

    void replaceDocument(IStructuredDocumentRegionList newStructuredDocumentRegions) {
        if (this.fDocument == null || this.fCreationContext == null) {
            return;
        }
        ((CSSDocumentImpl)this.fDocument).removeChildNodes();
        if (newStructuredDocumentRegions != null && newStructuredDocumentRegions.getLength() > 0) {
            this.setupCreationContext(newStructuredDocumentRegions.item(0));
            this.insertStructuredDocumentRegions(newStructuredDocumentRegions);
        }
        IStructuredDocument structuredDocument = this.fStructuredDocumentWalker.getStructuredDocument();
        ((CSSStructuredDocumentRegionContainer)((Object)this.fDocument)).setRangeStructuredDocumentRegion(structuredDocument.getFirstStructuredDocumentRegion(), structuredDocument.getLastStructuredDocumentRegion());
    }

    void replaceStructuredDocumentRegions(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        if (this.fDocument == null || this.fCreationContext == null) {
            return;
        }
        if (oldStructuredDocumentRegions != null && oldStructuredDocumentRegions.getLength() > 0) {
            this.setupDeletionContext(newStructuredDocumentRegions, oldStructuredDocumentRegions);
            short updateMode = this.fUpdateContext.getUpdateMode();
            if (updateMode == 0) {
                this.removeStructuredDocumentRegions(oldStructuredDocumentRegions);
            } else {
                this.pretendRemoveNode();
            }
            newStructuredDocumentRegions = this.getStructuredDocumentRegionList(this.fDeletionContext.getRemovedRangeBegin(), this.fDeletionContext.getRemovedRangeEnd());
            this.cleanupDeletionContext();
        }
        if (newStructuredDocumentRegions != null && newStructuredDocumentRegions.getLength() > 0) {
            if (oldStructuredDocumentRegions != null && oldStructuredDocumentRegions.getLength() < 0) {
                this.setupCreationContext(oldStructuredDocumentRegions.item(0));
            } else {
                this.setupCreationContext(newStructuredDocumentRegions.item(0));
            }
            this.insertStructuredDocumentRegions(newStructuredDocumentRegions);
        }
        IStructuredDocument structuredDocument = this.fStructuredDocumentWalker.getStructuredDocument();
        ((CSSStructuredDocumentRegionContainer)((Object)this.fDocument)).setRangeStructuredDocumentRegion(structuredDocument.getFirstStructuredDocumentRegion(), structuredDocument.getLastStructuredDocumentRegion());
    }

    void replaceRegions(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        if (flatNode == null) {
            return;
        }
        if (newRegions == null || oldRegions == null) {
            return;
        }
        if (this.fDocument == null) {
            return;
        }
        this.changeStructuredDocumentRegion(flatNode);
    }

    private void resetCreationTarget(IStructuredDocumentRegion newStructuredDocumentRegion) {
        String regionType;
        short nodeType;
        if (newStructuredDocumentRegion == null || newStructuredDocumentRegion.getStartOffset() <= 0) {
            this.fCreationContext.setTargetNode(this.fDocument);
            this.fCreationContext.setNextNode(this.fDocument.getFirstChild());
            return;
        }
        int cursorPos = newStructuredDocumentRegion.getStartOffset();
        CSSNodeImpl cursorNode = this.getNodeAt(cursorPos);
        if (cursorNode == null) {
            cursorNode = (CSSNodeImpl)((Object)this.fDocument);
        }
        CSSNodeImpl node = null;
        boolean bOverOpenBrace = false;
        IStructuredDocumentRegion flatNode = newStructuredDocumentRegion;
        while (flatNode != null) {
            String type;
            node = this.getNodeAt(flatNode.getStartOffset());
            if (node == null) {
                node = (CSSNodeImpl)((Object)this.fDocument);
            }
            if (node != cursorNode || node.getStartOffset() == flatNode.getStartOffset()) break;
            if (flatNode != newStructuredDocumentRegion && (type = CSSUtil.getStructuredDocumentRegionType(flatNode)) == "LBRACE") {
                bOverOpenBrace = true;
            }
            flatNode = flatNode.getPrevious();
        }
        CSSNodeImpl targetNode = null;
        targetNode = cursorNode == node ? (bOverOpenBrace && cursorNode instanceof CSSRuleDeclContainer ? (CSSNodeImpl)((Object)((CSSRuleDeclContainer)cursorNode).getStyle()) : cursorNode) : ((nodeType = node.getNodeType()) == 9 || nodeType == 2 || nodeType == 3 ? ((regionType = CSSUtil.getStructuredDocumentRegionType(flatNode)) == "DELIMITER" || regionType == "DECLARATION_DELIMITER" ? (CSSNodeImpl)node.getParentNode() : node) : (CSSUtil.getStructuredDocumentRegionType(flatNode) == "RBRACE" ? (CSSNodeImpl)node.getParentNode() : node));
        this.fCreationContext.setTargetNode(targetNode);
        ICSSNode next = null;
        if (targetNode.hasChildNodes()) {
            ICSSNode child = targetNode.getFirstChild();
            while (child != null) {
                if (child instanceof CSSStructuredDocumentRegionContainer && cursorPos < ((CSSStructuredDocumentRegionContainer)child).getStartOffset()) {
                    next = child;
                    break;
                }
                child = child.getNextSibling();
            }
        }
        this.fCreationContext.setNextNode(next);
    }

    private void resetReparseRange() {
        this.fCreationContext.clear();
    }

    void setStructuredDocumentEvent(StructuredDocumentEvent event) {
        if (this.fStructuredDocumentWalker == null) {
            this.fStructuredDocumentWalker = new StructuredDocumentWalker();
        }
        this.fStructuredDocumentWalker.initialize(event);
    }

    private void setMediaList(MediaListImpl mediaList, IStructuredDocumentRegion region, ITextRegionList textRegions) {
        if (mediaList == null || textRegions == null) {
            return;
        }
        HashSet<ICSSNode> mediaTable = new HashSet<ICSSNode>();
        CSSNodeListImpl attrs = mediaList.getMedia();
        int i = 0;
        while (i != attrs.getLength()) {
            mediaTable.add(attrs.item(i));
            ++i;
        }
        ITextRegion start = null;
        ITextRegion end = null;
        Iterator i2 = textRegions.iterator();
        ITextRegion textRegion = i2.hasNext() ? i2.next() : null;
        while (textRegion != null) {
            String mediumStr;
            if (textRegion.getType() == "MEDIUM" && (mediumStr = region.getText(textRegion)).length() > 0) {
                CSSRegionContainer attr = null;
                for (CSSAttrImpl cSSAttrImpl : mediaTable) {
                    if (!mediumStr.equalsIgnoreCase(cSSAttrImpl.getValue())) continue;
                    attr = cSSAttrImpl;
                    mediaTable.remove(cSSAttrImpl);
                    break;
                }
                if (attr == null) {
                    String string = "mediumP" + mediaList.mediumCounter++;
                    mediaList.setAttribute(string, mediumStr);
                    attr = mediaList.getAttributeNode(string);
                }
                attr.setRangeRegion(region, textRegion, textRegion);
                if (start == null) {
                    start = textRegion;
                }
                end = textRegion;
            }
            textRegion = i2.hasNext() ? i2.next() : null;
        }
        if (start != null && end != null) {
            mediaList.setRangeRegion(region, start, end);
        }
    }

    private void setupCreationContext(IStructuredDocumentRegion region) {
        this.resetReparseRange();
        this.resetCreationTarget(region);
    }

    private void setupDeletionContext(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        this.fDeletionContext.setupContext(newStructuredDocumentRegions, oldStructuredDocumentRegions);
    }

    void setupUpdateContext(short updateMode, ICSSNode parentNode, ICSSNode targetNode) {
        this.fUpdateContext.setupContext(updateMode, parentNode, targetNode);
    }

    void shrinkContainer(CSSStructuredDocumentRegionContainer parent, CSSStructuredDocumentRegionContainer child) {
        if (child == null) {
            return;
        }
        boolean bModified = false;
        bModified = bModified || this.cleanupLastNode(child.getLastStructuredDocumentRegion(), parent);
        boolean bl = bModified = bModified || this.cleanupFirstNode(child.getFirstStructuredDocumentRegion(), parent);
        if (bModified && parent != null) {
            ICSSNode node = parent.getFirstChild();
            while (node != null) {
                if (child != node && node instanceof CSSStructuredDocumentRegionContainer) {
                    ((CSSStructuredDocumentRegionContainer)node).propagateRangeStructuredDocumentRegion();
                }
                node = node.getNextSibling();
            }
        }
        child.setRangeStructuredDocumentRegion(null, null);
    }
}

