/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.IServerMonitorManager;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.viewers.MonitorContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.MonitorDialog;
import org.eclipse.wst.server.ui.internal.viewers.MonitorLabelProvider;

public class MonitorComposite
extends Composite {
    protected PortSelectionListener listener;
    protected IServer server;
    protected IServerMonitorManager smm;
    protected Table monitorTable;
    protected TableViewer monitorTableViewer;

    public MonitorComposite(Composite parent, int style, PortSelectionListener listener2, IServer server) {
        super(parent, style);
        this.listener = listener2;
        this.server = server;
        this.smm = ServerMonitorManager.getInstance();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        this.monitorTable = new Table((Composite)this, 68354);
        data = new GridData(1808);
        data.heightHint = 150;
        this.monitorTable.setLayoutData((Object)data);
        this.monitorTable.setLinesVisible(true);
        this.monitorTableViewer = new TableViewer(this.monitorTable);
        TableLayout tableLayout = new TableLayout();
        this.monitorTable.setLayout((Layout)tableLayout);
        this.monitorTable.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 80, true));
        TableColumn col = new TableColumn(this.monitorTable, 0);
        col.setText(Messages.dialogMonitorColumnStatus);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, 120, true));
        col = new TableColumn(this.monitorTable, 0);
        col.setText(Messages.dialogMonitorColumnType);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 80, true));
        col = new TableColumn(this.monitorTable, 0);
        col.setText(Messages.dialogMonitorColumnPort);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 80, true));
        col = new TableColumn(this.monitorTable, 0);
        col.setText(Messages.dialogMonitorColumnMonitorPort);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 80, true));
        col = new TableColumn(this.monitorTable, 0);
        col.setText(Messages.dialogMonitorColumnContentType);
        this.monitorTableViewer.setContentProvider((IContentProvider)new MonitorContentProvider(server));
        this.monitorTableViewer.setLabelProvider((IBaseLabelProvider)new MonitorLabelProvider(server));
        this.monitorTableViewer.setInput((Object)"root");
        this.monitorTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IMonitoredServerPort port1 = (IMonitoredServerPort)e1;
                IMonitoredServerPort port2 = (IMonitoredServerPort)e2;
                if (port1.getServerPort().getPort() == port2.getServerPort().getPort()) {
                    if (port1.getMonitorPort() == port2.getMonitorPort()) {
                        return 0;
                    }
                    if (port1.getMonitorPort() > port2.getMonitorPort()) {
                        return 1;
                    }
                    return -1;
                }
                if (port1.getServerPort().getPort() > port2.getServerPort().getPort()) {
                    return 1;
                }
                return -1;
            }
        });
        Composite buttonComp = new Composite((Composite)this, 0);
        buttonComp.setLayoutData((Object)new GridData(258));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComp.setLayout((Layout)layout);
        final IServer server2 = server;
        Button add = SWTUtil.createButton(buttonComp, Messages.add);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPort port;
                IMonitoredServerPort sp;
                MonitorDialog dialog = new MonitorDialog(MonitorComposite.this.getShell(), server2);
                if (dialog.open() != 1 && (sp = MonitorComposite.this.smm.createMonitor(server2, port = dialog.getServerPort(), dialog.getMonitorPort(), dialog.getContentTypes())) != null) {
                    MonitorComposite.this.monitorTableViewer.add((Object)sp);
                }
            }
        });
        if (server.getServerType() == null) {
            add.setEnabled(false);
        }
        final Button edit = SWTUtil.createButton(buttonComp, Messages.edit);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)MonitorComposite.this.monitorTableViewer.getSelection();
                IMonitoredServerPort port = (IMonitoredServerPort)sel.getFirstElement();
                MonitorDialog dialog = new MonitorDialog(MonitorComposite.this.getShell(), server2, port.getServerPort(), port.getMonitorPort(), port.getContentTypes());
                if (dialog.open() != 1) {
                    MonitorComposite.this.smm.removeMonitor(port);
                    MonitorComposite.this.monitorTableViewer.remove((Object)port);
                    port = MonitorComposite.this.smm.createMonitor(server2, dialog.getServerPort(), dialog.getMonitorPort(), dialog.getContentTypes());
                    if (port != null) {
                        MonitorComposite.this.monitorTableViewer.add((Object)port);
                        MonitorComposite.this.monitorTableViewer.setSelection((ISelection)new StructuredSelection((Object)port));
                    }
                }
            }
        });
        edit.setEnabled(false);
        final Button remove = SWTUtil.createButton(buttonComp, Messages.remove);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMonitoredServerPort msp = (IMonitoredServerPort)MonitorComposite.this.getSelection(MonitorComposite.this.monitorTableViewer.getSelection());
                if (msp.isStarted()) {
                    MonitorComposite.this.smm.stopMonitor(msp);
                }
                MonitorComposite.this.smm.removeMonitor(msp);
                MonitorComposite.this.monitorTableViewer.remove((Object)msp);
            }
        });
        remove.setEnabled(false);
        final Button start = SWTUtil.createButton(buttonComp, Messages.start);
        start.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)MonitorComposite.this.monitorTableViewer.getSelection();
                IMonitoredServerPort msp = (IMonitoredServerPort)sel.getFirstElement();
                try {
                    MonitorComposite.this.smm.startMonitor(msp);
                }
                catch (CoreException ce) {
                    EclipseUtil.openError(MonitorComposite.this.getShell(), ce.getLocalizedMessage());
                }
                MonitorComposite.this.monitorTableViewer.refresh((Object)msp);
                MonitorComposite.this.monitorTableViewer.setSelection((ISelection)new StructuredSelection((Object)msp));
            }
        });
        start.setEnabled(false);
        final Button stop = SWTUtil.createButton(buttonComp, Messages.stop);
        stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)MonitorComposite.this.monitorTableViewer.getSelection();
                IMonitoredServerPort msp = (IMonitoredServerPort)sel.getFirstElement();
                MonitorComposite.this.smm.stopMonitor(msp);
                MonitorComposite.this.monitorTableViewer.refresh((Object)msp);
                MonitorComposite.this.monitorTableViewer.setSelection((ISelection)new StructuredSelection((Object)msp));
            }
        });
        stop.setEnabled(false);
        this.monitorTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IMonitoredServerPort port = (IMonitoredServerPort)MonitorComposite.this.getSelection(MonitorComposite.this.monitorTableViewer.getSelection());
                if (port != null) {
                    edit.setEnabled(!port.isStarted());
                    remove.setEnabled(true);
                    start.setEnabled(!port.isStarted());
                    stop.setEnabled(port.isStarted());
                } else {
                    edit.setEnabled(false);
                    remove.setEnabled(false);
                    start.setEnabled(false);
                    stop.setEnabled(false);
                }
            }
        });
        IMonitoredServerPort[] msps = ServerMonitorManager.getInstance().getMonitoredPorts(server);
        if (msps != null && msps.length > 0) {
            this.monitorTableViewer.setSelection((ISelection)new StructuredSelection((Object)msps[0]));
        }
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    public static interface PortSelectionListener {
        public void portSelected(ServerPort var1);
    }
}

