/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.VersionableObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.util.PDEXMLHelper;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.w3c.dom.Node;

public class FeatureImport
extends VersionableObject
implements IFeatureImport {
    private static final long serialVersionUID = 1L;
    private int fMatch = 0;
    private int fType = 0;
    private boolean fPatch = false;
    private String fFilter = null;

    public IPlugin getPlugin() {
        if (this.id != null && this.fType == 0) {
            IPlugin iPlugin;
            IPluginModelBase model = PluginRegistry.findModel(this.id, this.version, VersionUtil.matchRuleFromLiteral(this.fMatch));
            if (model instanceof IPluginModel) {
                IPluginModel i = (IPluginModel)model;
                iPlugin = i.getPlugin();
            } else {
                iPlugin = null;
            }
            return iPlugin;
        }
        return null;
    }

    @Override
    public IFeature getFeature() {
        if (this.id != null && this.fType == 1) {
            return this.findFeature(this.id, this.getVersion(), this.fMatch);
        }
        return null;
    }

    public IFeature findFeature(String id, String version, int match) {
        List<IFeatureModel> models = PDECore.getDefault().getFeatureModelManager().findFeatureModels(id);
        for (IFeatureModel model : models) {
            IFeature feature = model.getFeature();
            if (!id.equals(feature.getId()) || !VersionUtil.compare(feature.getVersion(), version, match)) continue;
            return feature;
        }
        return null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.fPatch = false;
        this.fType = 0;
        this.fMatch = 0;
        this.fFilter = null;
    }

    @Override
    protected void parse(Node node) {
        super.parse(node);
        this.id = this.getNodeAttribute(node, "plugin");
        if (this.id != null) {
            this.fType = 0;
        } else {
            this.id = this.getNodeAttribute(node, "feature");
            if (this.id != null) {
                this.fType = 1;
            }
        }
        String mvalue = this.getNodeAttribute(node, "match");
        if (mvalue != null && mvalue.length() > 0) {
            String[] choices = RULE_NAME_TABLE;
            int i = 0;
            while (i < choices.length) {
                if (mvalue.equalsIgnoreCase(choices[i])) {
                    this.fMatch = i;
                    break;
                }
                ++i;
            }
        }
        this.fPatch = this.getBooleanAttribute(node, "patch");
        this.fFilter = this.getNodeAttribute(node, "filter");
    }

    public void loadFrom(IFeature feature) {
        this.reset();
        this.fType = 1;
        this.id = feature.getId();
        this.version = feature.getVersion();
    }

    @Override
    public int getMatch() {
        return this.fMatch;
    }

    @Override
    public void setMatch(int match) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = this.fMatch;
        this.fMatch = match;
        this.firePropertyChanged("match", oldValue, match);
    }

    @Override
    public int getType() {
        return this.fType;
    }

    @Override
    public void setType(int type) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = this.fType;
        this.fType = type;
        this.firePropertyChanged("type", oldValue, type);
    }

    @Override
    public boolean isPatch() {
        return this.fPatch;
    }

    @Override
    public void setPatch(boolean patch) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = this.fPatch;
        this.fPatch = patch;
        this.firePropertyChanged("patch", oldValue, patch);
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        switch (name) {
            case "match": {
                this.setMatch(newValue != null ? (Integer)newValue : 0);
                break;
            }
            case "type": {
                this.setType(newValue != null ? (Integer)newValue : 0);
                break;
            }
            case "patch": {
                this.setPatch(newValue != null ? (Boolean)newValue : false);
                break;
            }
            default: {
                super.restoreProperty(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        String writableString;
        String typeAtt = this.fType == 1 ? "feature" : "plugin";
        writer.print(indent + "<import " + typeAtt + "=\"" + this.getId() + "\"");
        String version = this.getVersion();
        if (version != null && version.length() > 0) {
            writer.print(" version=\"" + version + "\"");
        }
        if (!this.fPatch && this.fMatch != 0) {
            writer.print(" match=\"" + RULE_NAME_TABLE[this.fMatch] + "\"");
        }
        if (this.fPatch) {
            writer.print(" patch=\"true\"");
        }
        if (!(writableString = PDEXMLHelper.getWritableAttributeString(this.fFilter)).isBlank()) {
            writer.print(" filter=\"" + writableString + "\"");
        }
        writer.println("/>");
    }

    public String toString() {
        IPlugin plugin = this.getPlugin();
        if (plugin != null) {
            return plugin.getTranslatedName();
        }
        IFeature feature = this.getFeature();
        if (feature != null) {
            return feature.getLabel();
        }
        return this.getId();
    }

    @Override
    public String getFilter() {
        return this.fFilter;
    }

    @Override
    public void setFilter(String filter) throws CoreException {
        this.fFilter = filter;
    }

    @Override
    public boolean matchesEnvironment(ITargetDefinition target) {
        String filter = this.getFilter();
        if (filter == null || filter.isBlank()) {
            return true;
        }
        IMatchExpression expression = InstallableUnit.parseFilter((String)filter);
        HashMap<String, String> context = new HashMap<String, String>();
        FeatureImport.addProperty("osgi.os", target.getOS(), Platform.getOS(), context);
        FeatureImport.addProperty("osgi.ws", target.getWS(), Platform.getWS(), context);
        FeatureImport.addProperty("osgi.arch", target.getArch(), Platform.getOSArch(), context);
        FeatureImport.addProperty("osgi.nl", target.getNL(), Platform.getNL(), context);
        return expression.isMatch((Object)InstallableUnit.contextIU(context));
    }

    private static void addProperty(String key, String property, String defaultValue, Map<String, String> context) {
        if (property == null || property.isBlank()) {
            context.put(key, defaultValue);
            return;
        }
        context.put(key, property);
    }
}

