/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Gate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.LayoutConstants;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceElementQuery;
import org.eclipse.sirius.ext.base.Option;

public abstract class AbstractSequenceLayout<S, T> {
    protected final SequenceDiagram sequenceDiagram;
    protected final Map<ISequenceElement, T> oldLayoutData;

    public AbstractSequenceLayout(SequenceDiagram sequenceDiagram) {
        this.sequenceDiagram = sequenceDiagram;
        this.oldLayoutData = new HashMap<ISequenceElement, T>();
    }

    public final boolean layout(boolean pack) {
        this.init(pack);
        Map<S, T> finalRanges = this.computeLayout(pack);
        boolean applied = this.applyComputedLayout(finalRanges, pack);
        this.dispose();
        return applied;
    }

    protected abstract void init(boolean var1);

    protected abstract T getOldLayoutData(S var1);

    protected abstract Map<? extends S, T> computeLayout(boolean var1);

    protected abstract boolean applyComputedLayout(Map<? extends S, T> var1, boolean var2);

    protected void dispose() {
        this.oldLayoutData.clear();
    }

    protected Iterable<Lifeline> getLifeLinesWithoutCreation() {
        Predicate<Lifeline> isMainLifeline = new Predicate<Lifeline>(){

            public boolean apply(Lifeline input) {
                boolean main = true;
                InstanceRole instanceRole = input.getInstanceRole();
                if (instanceRole != null) {
                    main = !instanceRole.isExplicitlyCreated();
                }
                return main;
            }
        };
        return Iterables.filter(this.sequenceDiagram.getAllLifelines(), (Predicate)isMainLifeline);
    }

    protected Iterable<Lifeline> getLifeLinesWithoutDestruction() {
        Predicate<Lifeline> isLifelineWithoutDestruction = new Predicate<Lifeline>(){

            public boolean apply(Lifeline input) {
                boolean result = true;
                Option<EndOfLife> endOfLife = input.getEndOfLife();
                if (endOfLife.some()) {
                    result = !((EndOfLife)endOfLife.get()).isExplicitelyDestroyed();
                }
                return result;
            }
        };
        return Iterables.filter(this.sequenceDiagram.getAllLifelines(), (Predicate)isLifelineWithoutDestruction);
    }

    public static boolean createdFromTool(ISequenceNode node) {
        boolean toolCreated = false;
        ISequenceElementQuery query = new ISequenceElementQuery(node);
        if (query.hasAbsoluteBoundsFlag()) {
            Rectangle flag = query.getFlaggedAbsoluteBounds();
            if (flag.x == LayoutConstants.TOOL_CREATION_FLAG_FROM_SEMANTIC.x || node instanceof Gate && flag.width == LayoutConstants.TOOL_CREATION_FLAG_FROM_SEMANTIC.x) {
                toolCreated = true;
            }
        }
        return toolCreated;
    }

    public static boolean createdFromExternalChange(LostMessageEnd lostEnd) {
        boolean externalCreation = false;
        Option<Message> message = lostEnd.getMessage();
        ISequenceElementQuery query = new ISequenceElementQuery(lostEnd);
        if (query.hasAbsoluteBoundsFlag() && query.getFlaggedAbsoluteBounds().x == LayoutConstants.EXTERNAL_CHANGE_FLAG.x) {
            externalCreation = true;
        } else if (message.some()) {
            query = new ISequenceElementQuery((ISequenceElement)message.get());
            externalCreation = query.hasAbsoluteBoundsFlag() && query.getFlaggedAbsoluteBounds().x == LayoutConstants.EXTERNAL_CHANGE_FLAG.x;
        }
        return externalCreation;
    }
}

