/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Objects;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.internal.HttpConnection;
import org.eclipse.jetty.util.annotation.Name;

public class HttpConnectionFactory
extends AbstractConnectionFactory
implements HttpConfiguration.ConnectionFactory {
    private final HttpConfiguration _config;

    public HttpConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HttpConnectionFactory(@Name(value="config") HttpConfiguration config) {
        super(HttpVersion.HTTP_1_1.asString());
        this._config = Objects.requireNonNull(config);
        this.installBean(this._config);
        this.setInputBufferSize(this._config.getInputBufferSize());
    }

    @Override
    public void setInputBufferSize(int size) {
        super.setInputBufferSize(size);
        this._config.setInputBufferSize(size);
    }

    @Override
    public int getInputBufferSize() {
        return this._config.getInputBufferSize();
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this._config.isUseInputDirectByteBuffers();
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this._config.setUseInputDirectByteBuffers(useInputDirectByteBuffers);
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this._config.isUseOutputDirectByteBuffers();
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this._config.setUseOutputDirectByteBuffers(useOutputDirectByteBuffers);
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        HttpConnection connection = new HttpConnection(this._config, connector, endPoint);
        return this.configure(connection, connector, endPoint);
    }
}

