/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteTopic;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.swt.graphics.Image;

public interface CDOTopicProvider {
    public Topic[] getTopics();

    public void addTopicListener(Listener var1);

    public void removeTopicListener(Listener var1);

    default public void changeTopic(Topic topic, Image newImage, String newText, String newDescription) {
        topic.change(newImage, newText, newDescription);
    }

    public static interface Listener {
        public void topicAdded(CDOTopicProvider var1, Topic var2);

        public void topicRemoved(CDOTopicProvider var1, Topic var2);
    }

    public static final class Topic
    extends Notifier
    implements IAdaptable {
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final CDOSession session;
        private final String id;
        private Image image;
        private String text;
        private String description;
        private Function<Class<?>, Object> adapterProvider = type -> null;

        public Topic(CDOSession session, String id, Image image, String text, String description) {
            this.session = session;
            this.id = id;
            this.image = image;
            this.text = text;
            this.description = description;
        }

        public CDOSession getSession() {
            return this.session;
        }

        public String getId() {
            return this.id;
        }

        public Image getImage() {
            return this.image;
        }

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public <T> T getAdapter(Class<T> type) {
            Object adapter = AdapterUtil.adapt((Object)((Object)this), type, (boolean)false);
            if (adapter != null) {
                return (T)adapter;
            }
            adapter = this.provideAdapter(type);
            if (adapter != null) {
                return (T)adapter;
            }
            if (type == CDORemoteTopic.class) {
                CDORemoteSessionManager remoteSessionManager = this.session.getRemoteSessionManager();
                CDORemoteTopic subscribedTopic = remoteSessionManager.getSubscribedTopic(this.id);
                return (T)subscribedTopic;
            }
            return null;
        }

        public Topic addAdapterProvider(Function<Class<?>, Object> newAdapterProvider) {
            Function<Class<?>, Object> oldAdapterProvider = this.adapterProvider;
            this.adapterProvider = type -> {
                Object adapter = newAdapterProvider.apply((Class<?>)type);
                if (adapter != null) {
                    return adapter;
                }
                return oldAdapterProvider.apply((Class<?>)type);
            };
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.session, this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Topic other = (Topic)((Object)obj);
            return Objects.equals(this.session, other.session) && Objects.equals(this.id, other.id);
        }

        public String toString() {
            String string = this.session.getRepositoryInfo().getName() + "/" + this.id;
            String userID = this.session.getUserID();
            if (!StringUtil.isEmpty((String)userID)) {
                string = userID + "@" + string;
            }
            return string;
        }

        private <T> T provideAdapter(Class<T> type) {
            if (this.adapterProvider != null) {
                try {
                    Object adapter = this.adapterProvider.apply(type);
                    return (T)adapter;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void change(Image newImage, String newText, String newDescription) {
            String oldDescription;
            String oldText;
            Image oldImage;
            boolean changed = false;
            Topic topic = this;
            synchronized (topic) {
                oldImage = this.image;
                if (!Objects.equals(oldImage, newImage)) {
                    this.image = newImage;
                    changed = true;
                }
                if (!Objects.equals(oldText = this.text, newText)) {
                    this.text = newText;
                    changed = true;
                }
                if (!Objects.equals(oldDescription = this.description, newDescription)) {
                    this.description = newDescription;
                    changed = true;
                }
            }
            if (changed) {
                this.fireEvent((IEvent)new TopicChangedEvent(this, oldImage, newImage, oldText, newText, oldDescription, newDescription));
            }
        }

        public static final class TopicChangedEvent
        extends Event {
            private static final long serialVersionUID = 1L;
            private final Image oldImage;
            private final Image newImage;
            private final String oldText;
            private final String newText;
            private final String oldDescription;
            private final String newDescription;

            private TopicChangedEvent(Topic topic, Image oldImage, Image newImage, String oldText, String newText, String oldDescription, String newDescription) {
                super((INotifier)topic);
                this.oldImage = oldImage;
                this.newImage = newImage;
                this.oldText = oldText;
                this.newText = newText;
                this.oldDescription = oldDescription;
                this.newDescription = newDescription;
            }

            public Topic getSource() {
                return (Topic)super.getSource();
            }

            public Image getOldImage() {
                return this.oldImage;
            }

            public Image getNewImage() {
                return this.newImage;
            }

            public String getOldText() {
                return this.oldText;
            }

            public String getNewText() {
                return this.newText;
            }

            public String getOldDescription() {
                return this.oldDescription;
            }

            public String getNewDescription() {
                return this.newDescription;
            }
        }
    }
}

