/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.sun.jdi.ClassType;
import com.sun.jdi.ReferenceType;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIClassType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.eval.ast.engine.AbstractRuntimeContext;

public class JavaPrimitiveRuntimeContext
extends AbstractRuntimeContext {
    private final IJavaPrimitiveValue fThisPrimitive;
    private final IJavaThread fThread;

    public JavaPrimitiveRuntimeContext(IJavaPrimitiveValue thisObject, IJavaProject javaProject, IJavaThread thread) {
        super(javaProject);
        this.fThisPrimitive = thisObject;
        this.fThread = thread;
    }

    @Override
    public IJavaDebugTarget getVM() {
        return (IJavaDebugTarget)this.fThisPrimitive.getDebugTarget();
    }

    @Override
    public IJavaPrimitiveValue getThisPrimitive() {
        return this.fThisPrimitive;
    }

    @Override
    public IJavaReferenceType getReceivingType() throws CoreException {
        JDIDebugTarget target = (JDIDebugTarget)this.getThisPrimitive().getJavaType().getDebugTarget();
        List<ReferenceType> ref = target.getVM().classesByName("java.lang.Object");
        ClassType classType = (ClassType)ref.get(0);
        JDIClassType jdiClassType = new JDIClassType(target, classType);
        return jdiClassType;
    }

    @Override
    public IJavaVariable[] getLocals() {
        return new IJavaVariable[0];
    }

    @Override
    public IJavaThread getThread() {
        return this.fThread;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public IJavaObject getThis() throws CoreException {
        return null;
    }
}

