/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizard;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CheckoutLabelPage
extends CheckoutWizardPage {
    private final CheckoutPropertiesHolder holder = new CheckoutPropertiesHolder();
    private String label;

    public CheckoutLabelPage() {
        super("Checkout Label", "Enter the label of the new checkout.");
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        if (!ObjectUtil.equals((Object)this.label, (Object)label)) {
            CheckoutLabelPage.log("Setting label to " + label);
            this.label = label;
            if (this.holder.labelText != null && !this.holder.labelText.getText().equals(label)) {
                this.holder.labelText.setText(StringUtil.safe((String)label));
            }
        }
    }

    @Override
    protected Layout createCompositeLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    @Override
    protected void createUI(Composite parent) {
        this.holder.createUI(parent);
        this.holder.labelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutLabelPage.this.setLabel(CheckoutLabelPage.this.holder.labelText.getText());
                CheckoutLabelPage.this.validate();
            }
        });
    }

    @Override
    protected void repositoryChanged(CDORepository repository) {
        this.clearLabel();
        super.repositoryChanged(repository);
    }

    @Override
    protected void typeChanged(String type) {
        this.clearLabel();
        super.typeChanged(type);
    }

    @Override
    protected void branchPointChanged(int branchID, long timeStamp) {
        this.clearLabel();
        super.branchPointChanged(branchID, timeStamp);
    }

    @Override
    protected void rootObjectChanged(CDOID rootID) {
        this.clearLabel();
        super.rootObjectChanged(rootID);
    }

    @Override
    protected void pageActivated() {
        CheckoutWizard wizard = this.getWizard();
        String type = wizard.getTypePage().getType();
        CDOBranchPoint branchPoint = wizard.getBranchPointPage().getBranchPoint();
        String rootLabel = wizard.getRootObjectPage().getRootObjectText();
        if (StringUtil.isEmpty((String)this.label)) {
            String label = StringUtil.capAll((String)type.replace('-', ' ')) + " Checkout";
            this.setLabel(CDOExplorerUtil.getCheckoutManager().getUniqueLabel(label));
        }
        this.holder.typeLabel.setText(type);
        this.holder.branchLabel.setText(branchPoint.getBranch().getPathName());
        this.holder.timeLabel.setText(CDOCommonUtil.formatTimeStamp((long)branchPoint.getTimeStamp()));
        this.holder.rootLabel.setText(rootLabel);
        this.holder.repositoryLabel.setText(wizard.getRepositoryPage().getRepository().getLabel());
        this.holder.labelText.setFocus();
        this.holder.labelText.selectAll();
        super.pageActivated();
    }

    @Override
    protected boolean doValidate() throws CheckoutWizardPage.ValidationProblem {
        if (StringUtil.isEmpty((String)this.label)) {
            return false;
        }
        int i = 0;
        while (i < this.label.length()) {
            char c = this.label.charAt(i);
            int j = 0;
            while (j < "/\\:;,".length()) {
                if (c == "/\\:;,".charAt(j)) {
                    throw new CheckoutWizardPage.ValidationProblem("Invalid character: " + "/\\:;,".substring(j, 1));
                }
                ++j;
            }
            ++i;
        }
        if (CDOExplorerUtil.getCheckoutManager().getCheckoutByLabel(this.label) != null) {
            throw new CheckoutWizardPage.ValidationProblem("Label is not unique.");
        }
        return true;
    }

    @Override
    protected void fillProperties(Properties properties) {
        properties.setProperty("label", this.label);
    }

    private void clearLabel() {
        this.label = null;
        if (this.holder.labelText != null) {
            this.holder.labelText.setText("");
        }
    }

    public static class CheckoutPropertiesHolder {
        public Text labelText;
        public Label typeLabel;
        public Label branchLabel;
        public Label timeLabel;
        public Label rootLabel;
        public Label repositoryLabel;

        public void createUI(Composite parent) {
            new Label(parent, 0).setText("Label:");
            this.labelText = this.createLabelText(parent);
            this.labelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label(parent, 0).setText("Type:");
            this.typeLabel = this.createTypeLabel(parent);
            this.typeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label(parent, 0).setText("Branch:");
            this.branchLabel = this.createBranchLabel(parent);
            this.branchLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label(parent, 0).setText("Time:");
            this.timeLabel = this.createTimeLabel(parent);
            this.timeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label(parent, 0).setText("Root:");
            this.rootLabel = this.createRootLabel(parent);
            this.rootLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            new Label(parent, 0).setText("Repository:");
            this.repositoryLabel = this.createRepositoryLabel(parent);
            this.repositoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        protected Text createLabelText(Composite parent) {
            return new Text(parent, 2048);
        }

        protected Label createTypeLabel(Composite parent) {
            return new Label(parent, 0);
        }

        protected Label createBranchLabel(Composite parent) {
            return new Label(parent, 0);
        }

        protected Label createTimeLabel(Composite parent) {
            return new Label(parent, 0);
        }

        protected Label createRootLabel(Composite parent) {
            return new Label(parent, 0);
        }

        protected Label createRepositoryLabel(Composite parent) {
            return new Label(parent, 0);
        }
    }
}

