/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.enablement.ibm.util.ConnectionProfileUtility;
import org.eclipse.datatools.enablement.ibm.util.ReuseStringBuffer;

public class DBVersion {
    public static final String PRODUCT_DB2 = "DB2";
    public static final String DB2FAMILY = "DB2 Family";
    public static final String DB2390 = "DB2";
    public static final String DB2400 = "AS";
    public static final String DB2400SQL = "DB2/400 SQL";
    public static final String DB2400UDB = "DB2 UDB for AS/400";
    public static final String DB2ISERIES = "DB2 UDB iSeries";
    public static final String IBMCLOUDSCAPE = "IBM Cloudscape";
    public static final String APACHE_DERBY = "Apache Derby";
    public static final String DERBY = "Derby";
    public static final String DB2UDB = "DB2 UDB";
    public static final String DB2ZSERIES = "DB2 UDB zSeries";
    public static final String IDS = "Informix";
    public static final String IDS_ALIAS = "IDS";
    public static final String ORACLE = "Oracle";
    public static final String SYBASE = "Sybase";
    public static final String DB2ALIAS = "DB2 ALIAS";
    public static final String POSTGRES = "Postgres";
    public static final String DB2NT = "DB2/NT";
    public static final String DB2NT64 = "DB2/NT64";
    public static final String DB2Windows95 = "DB2/Windows 95";
    public static final String DB26000 = "DB2/6000";
    public static final String DB2AIX64 = "DB2/AIX64";
    public static final String DB26000PE = "DB2/6000 PE";
    public static final String DB2HPUX = "DB2/HPUX";
    public static final String DB2HPUX64 = "DB2/HP64";
    public static final String DB2SUN = "DB2/SUN";
    public static final String SUN64 = "DB2/SUN64";
    public static final String LINUX = "DB2/LINUX";
    public static final String DYNIX = "DB2/PTX";
    public static final String DB22 = "DB2/2";
    public static final String WORKSTATION = "WORKSTATION";
    public static final String AS400 = "AS400";
    public static final String DB2LINUX390 = "DB2/LINUX390";
    public static final String IMS = "IMS";
    public static final int DB_VERSION_4 = 4;
    public static final int DB_VERSION_5 = 5;
    public static final int DB_VERSION_6 = 6;
    public static final int DB_VERSION_7 = 7;
    public static final int DB_VERSION_8 = 8;
    public static final int DB_VERSION_9 = 9;
    public static final int DB_VERSION_10 = 10;
    public static final double DB_SDK_VERSION_6 = 6.1;
    public static final double DB_SDK_VERSION_7 = 7.0;
    public static final double DB_SDK_VERSION_8 = 8.0;
    public static final double DB_VERSION_5_REL_1 = 5.1;
    public static final double DB_VERSION_5_REL_2 = 5.2;
    public static final double DB_VERSION_5_REL_3 = 5.3;
    private static final int[] SUPPORTS_SKIP_LEVEL_COMPAT_MODE = new int[]{10};
    public static final String DB_VER_4 = "V4";
    public static final String DB_VER_5 = "V5";
    public static final String DB_VER_6 = "V6";
    public static final String DB_VER_7 = "V7";
    public static final String DB_VER_8 = "V8";
    public static final String DB_VER_9 = "V9";
    public static final String DB_VER_5_REL_1 = "V5.1";
    public static final String DB_VER_5_REL_2 = "V5.2";
    public static final String DB_VER_5_REL_3 = "V5.3";
    public static final String DB_ZSERIES_VERSION_6 = "V6";
    public static final String DB_ZSERIES_VERSION_7 = "V7";
    public static final String DB_ZSERIES_VERSION_8_COMPAT = "V8 (Compatibility Mode)";
    public static final String DB_ZSERIES_VERSION_8_NEWFUN = "V8 (New-Function Mode)";
    public static final String DB_ZSERIES_VERSION_9_COMPAT = "V9 (Compatibility Mode)";
    public static final String DB_ZSERIES_VERSION_9_NEWFUN = "V9 (New-Function Mode)";
    public static final String DB_ZSERIES_VERSION_10_COMPAT = "V10 (Conversion Mode)";
    public static final String DB_ZSERIES_VERSION_10_NEWFUN = "V10 (New-Function Mode)";
    public static final String DB_ZSERIES_VERSION_11_COMPAT = "V11 (Conversion Mode)";
    public static final String DB_ZSERIES_VERSION_11_NEWFUN = "V11 (New-Function Mode)";
    public static final String DB_VERSION_8_REL_1 = "V8.1";
    public static final String DB_VERSION_8_REL_2 = "V8.2";
    public static final String DB_UDB_VERSION_9 = "V9.1";
    public static final String DB_UDB_VERSION_9_5 = "V9.5";
    public static final String DB_UDB_VERSION_9_7 = "V9.7";
    public static final String DB_UDB_VERSION_10_1 = "V10.1";
    public static final String DB_UDB_VERSION_10_5 = "V10.5";
    public static final String DB_ISERIES_VERSION_5_REL_1 = "V5R1";
    public static final String DB_ISERIES_VERSION_5_REL_2 = "V5R2";
    public static final String DB_ISERIES_VERSION_5 = "5";
    public static final String DB_ISERIES_VERSION_5_REL_3 = "5R3";
    public static final String DB_ISERIES_VERSION_5_REL_3_NEW = "V05R03";
    public static final String DB_ISERIES_VERSION_5_REL_4 = "5R4";
    public static final String DB_ISERIES_VERSION_5_REL_4_NEW = "V05R04";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_0 = "10.0";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_1 = "10.1";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_2 = "10.2";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_3 = "10.3";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_4 = "10.4";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_5 = "10.5";
    public static final String DB_CLOUDSCAPE_VERSION_10_REL_6 = "10.6";
    public static final String DB_IDS_VERSION_10_REL_0 = "10.00";
    public static final String DB_IDS_VERSION_9_REL_5 = "9.50";
    public static final String DB_IDS_VERSION_9_REL_4 = "9.40";
    public static final String DB_IDS_VERSION_9_REL_3 = "9.30";
    public static final String DB_IDS_VERSION_9_REL_2 = "9.20";
    public static final String ORACLE_VERSION_10 = "10";
    public static final String ORACLE_VERSION_11 = "11";
    public static final String SYBASE_VERSION_12 = "12.0";
    public static final String SYBASE_VERSION_12_REL_5 = "12.5";
    public static final String SYBASE_VERSION_12_REL_X = "12.x";
    public static final String SYBASE_VERSION_15 = "15.0";
    protected String product = null;
    protected int version = 0;
    protected int release = 0;
    protected int mod = 0;
    protected char delim = (char)34;
    protected static DBVersion sharedDefault;
    protected static ArrayList<DBVersion> sharedInstances;
    public static final int PLATFORM_LUWO = 1;
    public static final int PLATFORM_390 = 2;
    public static final int PLATFORM_400 = 4;
    public static final int PLATFORM_ALL = 7;
    public static final int PLATFORM_OTHER = 16;
    private static final String ZOS_NEW_FUNCTION = "New-Function Mode";
    protected static String SQLCookies;

    static {
        sharedInstances = new ArrayList();
        SQLCookies = "SQL QSQ DSN";
    }

    protected static DBVersion findSharedInstance(String product, int version, int release, int mod) {
        for (DBVersion dbversion : sharedInstances) {
            if (!product.equals(dbversion.getProduct()) || version != dbversion.getVersion() || release != dbversion.getRelease() || mod != dbversion.getMod()) continue;
            return dbversion;
        }
        return null;
    }

    public static DBVersion getSharedInstance(String product, int version, int release, int mod) {
        DBVersion dbversion;
        if (product == null) {
            product = WORKSTATION;
        }
        if ((dbversion = DBVersion.findSharedInstance(product, version, release, mod)) == null) {
            dbversion = new DBVersion(product, version, release, mod);
            sharedInstances.add(dbversion);
        }
        return dbversion;
    }

    public static DBVersion getSharedInstance(String product, String productVersion) {
        int[] v = DBVersion.getVersionArray(productVersion);
        return DBVersion.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public static DBVersion getSharedInstance(ConnectionInfo myConnection) {
        boolean isOracleDatabase;
        Connection con;
        if (myConnection == null) {
            return DBVersion.getDefault();
        }
        DatabaseDefinition dbDef = myConnection.getDatabaseDefinition();
        String productVersion = myConnection.getDatabaseProductVersion();
        if (productVersion == null && (con = myConnection.getSharedConnection()) != null) {
            try {
                DatabaseMetaData dbmd = con.getMetaData();
                productVersion = dbmd.getDatabaseProductVersion();
            }
            catch (SQLException sQLException) {
                productVersion = null;
            }
        }
        if (DBVersion.isSybase(dbDef)) {
            productVersion = dbDef.getVersion();
        } else if (DBVersion.isIMS(dbDef)) {
            productVersion = dbDef.getVersion();
        }
        boolean bl = isOracleDatabase = dbDef.getProduct().equalsIgnoreCase(ORACLE);
        if (productVersion == null || isOracleDatabase) {
            productVersion = dbDef.getVersion();
        }
        String product = dbDef.getProduct();
        if (productVersion != null && productVersion.length() > 0) {
            int[] v = DBVersion.getVersionArray(productVersion);
            if (v == null) {
                v = new int[3];
            } else if (DBVersion.isIDS(dbDef) && v[1] >= 10) {
                v[1] = v[1] / 10;
            }
            return DBVersion.getSharedInstance(product, v[0], v[1], v[2]);
        }
        int[] v = DBVersion.getVersionArray(myConnection.getDatabaseDefinition().getVersion());
        if (v == null) {
            v = new int[3];
        }
        return DBVersion.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public static DBVersion getSharedInstance(IConnectionProfile profile) {
        if (profile == null) {
            return DBVersion.getDefault();
        }
        ConnectionInfo conInfo = ConnectionProfileUtility.getConnectionInfo(profile, false);
        if (conInfo != null) {
            return DBVersion.getSharedInstance(conInfo);
        }
        DatabaseDefinition dbDef = ConnectionProfileUtility.getDatabaseDefinition(profile);
        return DBVersion.getSharedInstance(dbDef);
    }

    public static DBVersion getSharedInstance(DatabaseDefinition dbDef) {
        if (dbDef == null) {
            return DBVersion.getDefault();
        }
        String version = dbDef.getVersion();
        String product = dbDef.getProduct();
        int[] v = DBVersion.getVersionArray(version);
        if (v == null) {
            v = new int[3];
        }
        return DBVersion.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public static DBVersion getSharedInstance(Connection connection) {
        String product;
        String versionString = null;
        try {
            product = connection.getMetaData().getDatabaseProductName();
            versionString = connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            product = WORKSTATION;
            versionString = "8.2.0";
        }
        int[] v = DBVersion.getVersionArray(versionString);
        if (v == null) {
            v = new int[3];
        }
        return DBVersion.getSharedInstance(product, v[0], v[1], v[2]);
    }

    public DBVersion(Connection connection) {
        String versionString = null;
        try {
            this.product = connection.getMetaData().getDatabaseProductName();
            versionString = connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            this.product = WORKSTATION;
            versionString = "8.2.0";
        }
        this.setVersion(versionString);
    }

    public DBVersion(String product, String versionString) {
        this.product = product;
        this.setVersion(versionString);
    }

    public DBVersion(String versionString) {
        this.product = WORKSTATION;
        this.setVersion(versionString);
    }

    public DBVersion(int version, int release, int mod) {
        this.product = WORKSTATION;
        this.setVersion(version, release, mod);
    }

    public DBVersion(String prod, int version, int release, int mod) {
        this.product = prod;
        this.setVersion(version, release, mod);
    }

    public DBVersion(DBVersion copyme) {
        if (copyme != null) {
            this.product = copyme.getProduct();
            this.version = copyme.getVersion();
            this.release = copyme.getRelease();
            this.mod = copyme.getMod();
        }
    }

    public DBVersion(IConnectionProfile profile) {
        String[] vv = ConnectionProfileUtility.getVendorVersion(profile);
        this.setVersion(vv[1]);
    }

    public DBVersion(ConnectionInfo conInfo) {
        if (conInfo != null) {
            IConnectionProfile profile = conInfo.getConnectionProfile();
            DatabaseDefinition dbDef = conInfo.getDatabaseDefinition();
            String productVersion = dbDef.getVersion();
            this.product = dbDef.getProduct();
            if (ConnectionProfileUtility.isConnected(profile)) {
                try {
                    Connection jdbcConn = conInfo.getSharedConnection();
                    productVersion = jdbcConn.getMetaData().getDatabaseProductVersion();
                    this.product = jdbcConn.getMetaData().getDatabaseProductName();
                }
                catch (Exception exception) {}
            }
            this.setVersion(productVersion);
        }
    }

    public DBVersion(DatabaseDefinition dbDef) {
        this.product = dbDef.getProduct();
        this.setVersion(dbDef.getVersion());
    }

    public static DBVersion getDefault() {
        if (sharedDefault == null) {
            sharedDefault = new DBVersion(WORKSTATION, 8, 2, 0);
        }
        return sharedDefault;
    }

    public char getDelimiter() {
        return this.delim;
    }

    public void setDelimiter(char d) {
        this.delim = d;
    }

    public void setProduct(String prod) {
        this.product = prod;
    }

    public String getProduct() {
        return this.product;
    }

    public boolean isDB2Alias() {
        return this.product != null && DB2ALIAS.equals(this.product);
    }

    public boolean isDB2() {
        return this.isUNO() || this.isDB400() || this.isDB390();
    }

    public boolean isDB390() {
        return this.product != null && ("DB2".equals(this.product) || DB2ZSERIES.equals(this.product));
    }

    public boolean isDB400() {
        return this.product != null && (AS400.equals(this.product) || DB2400.equals(this.product) || DB2400SQL.equals(this.product) || DB2400UDB.equals(this.product) || DB2ISERIES.equals(this.product));
    }

    public boolean isIBMCloudscape() {
        return this.product != null && (IBMCLOUDSCAPE.equals(this.product) || APACHE_DERBY.equals(this.product) || DERBY.equals(this.product));
    }

    public boolean isDerby() {
        return this.product != null && (DERBY.equals(this.product) || APACHE_DERBY.equals(this.product) || IBMCLOUDSCAPE.equals(this.product));
    }

    public boolean isUNO() {
        return this.product == null || WORKSTATION.equals(this.product) || DB2NT.equals(this.product) || this.product.startsWith("DB2") && !this.isDB390() && !this.isDB400() && !this.isIBMCloudscape();
    }

    public boolean isIDS() {
        return this.product != null && (this.product.startsWith(IDS) || this.product.startsWith(IDS_ALIAS));
    }

    public boolean isOracle() {
        return this.product != null && (this.product.equalsIgnoreCase(ORACLE) || this.product.startsWith(ORACLE));
    }

    public boolean isPostgres() {
        return this.product != null && (this.product.equalsIgnoreCase(POSTGRES) || this.product.startsWith(POSTGRES));
    }

    public boolean isSybase() {
        return this.product != null && this.product.equalsIgnoreCase(SYBASE);
    }

    public int getSQLIdentifierPlatform() {
        if (this.isDB390()) {
            return 2;
        }
        if (this.isDB400()) {
            return 4;
        }
        if (WORKSTATION.equals(this.product) || this.product != null && this.product.startsWith("DB2")) {
            return 1;
        }
        return 16;
    }

    public static boolean isDB2(DatabaseDefinition definition) {
        return DBVersion.isDB2UDB(definition) || DBVersion.isDB2AS400(definition) || DBVersion.isDB2OS390(definition) || DBVersion.isDB2Alias(definition);
    }

    public static boolean isDB2UDB(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, DB2UDB);
    }

    public static boolean isDB2OS390(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, DB2ZSERIES);
    }

    public static boolean isDB2AS400(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, DB2ISERIES);
    }

    public static boolean isDBCloudscape(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, IBMCLOUDSCAPE) || DBVersion.isProductSupported(definition, DERBY);
    }

    public static boolean isIDS(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, IDS);
    }

    public static boolean isSybase(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, SYBASE);
    }

    public static boolean isIMS(DatabaseDefinition definition) {
        boolean retVal = false;
        String prodStr = definition.getProductDisplayString();
        if (prodStr != null && IMS.equals(prodStr)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isOracle(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, ORACLE);
    }

    public static boolean isDB2Alias(DatabaseDefinition definition) {
        return DBVersion.isProductSupported(definition, DB2ALIAS);
    }

    private static boolean isProductSupported(DatabaseDefinition definition, String product) {
        if (definition == null) {
            return false;
        }
        return definition.getProduct().equalsIgnoreCase(product);
    }

    public static int[] getVersionArray(String versionString) {
        int[] v = new int[3];
        if (versionString == null || versionString.length() == 0) {
            v[0] = 8;
            v[1] = -1;
            v[2] = -1;
        } else {
            String cookie;
            int clen = 3;
            int cookieIdx = -1;
            if (versionString.length() >= clen && (cookieIdx = SQLCookies.indexOf(cookie = versionString.substring(0, clen))) == -1 && cookie.equals("IFX")) {
                cookieIdx = 0;
            }
            v = cookieIdx > -1 ? DBVersion.parseSQLVersion(versionString.substring(clen)) : DBVersion.parseNumericVersion(versionString);
        }
        return v;
    }

    public void setVersion(String versionString) {
        int[] v = DBVersion.getVersionArray(versionString);
        if (v != null) {
            this.setVersion(v[0], v[1], v[2]);
        }
    }

    public void setVersion(int version, int release, int mod) {
        this.version = version;
        this.release = release;
        this.mod = mod;
    }

    protected static int[] parseSQLVersion(String s) {
        int tmpversion = 0;
        int tmprelease = 0;
        int tmpmod = 0;
        try {
            tmpversion = Integer.parseInt(s.substring(0, 2));
            tmprelease = Integer.parseInt(s.substring(2, 4));
            String mod = s.substring(4);
            tmpmod = Character.isLetter(mod.charAt(0)) ? Math.max(0, mod.charAt(0) - 65 + 10) : Integer.parseInt(s.substring(4));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new int[]{tmpversion, tmprelease, tmpmod};
    }

    protected static int[] parseNumericVersion(String s) {
        int tmpmod;
        int tmprelease;
        int tmpversion;
        block9: {
            tmpversion = 0;
            tmprelease = 0;
            tmpmod = 0;
            StringTokenizer st = new StringTokenizer(s, "VRM .\t\n\r\f", false);
            try {
                if (st.hasMoreTokens()) {
                    tmpversion = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    tmprelease = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    tmpmod = Integer.parseInt(st.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (tmpversion == 0) {
                    return null;
                }
                if (tmpversion >= 8 && s.indexOf(ZOS_NEW_FUNCTION) > -1) {
                    tmprelease = 1;
                    tmpmod = 5;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (tmpversion == 0) {
                    return null;
                }
                if (tmpversion < 8 || s.indexOf(ZOS_NEW_FUNCTION) <= -1) break block9;
                tmprelease = 1;
                tmpmod = 5;
            }
        }
        return new int[]{tmpversion, tmprelease, tmpmod};
    }

    public static int[] parseSQLVendorType(String domain) {
        int tmpversion = 0;
        int tmprelease = 1;
        int vpos = domain.indexOf("_V") + 2;
        try {
            tmpversion = Integer.parseInt(domain.substring(vpos, vpos + 1));
            if (vpos + 1 <= domain.length() - 1) {
                tmprelease = Integer.parseInt(domain.substring(vpos + 1, vpos + 2));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        int[] nArray = new int[3];
        nArray[0] = tmpversion;
        nArray[1] = tmprelease;
        return nArray;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRelease() {
        return this.release;
    }

    public int getMod() {
        return this.mod;
    }

    public boolean isZSeriesV10CM8() {
        return this.isDB390() && (this.isExactly(10, 1, 0) || this.isExactly(10, 0, 0));
    }

    public boolean isAtLeast(int version) {
        int currentVersion = version;
        if (this.isZSeriesV10CM8()) {
            currentVersion = 8;
        }
        return currentVersion >= version;
    }

    public boolean isAtLeast(int version, int release) {
        if (this.version > version) {
            return true;
        }
        if (this.version == version) {
            return this.release >= release;
        }
        return false;
    }

    public boolean isAtLeast(int version, int release, int mod) {
        int currentVersion = this.version;
        if (this.isDB390() && this.isZSeriesSkipLevelCompatMode()) {
            --currentVersion;
        }
        if (currentVersion > version) {
            return true;
        }
        if (currentVersion == version) {
            if (release < 0) {
                return this.mod >= mod;
            }
            if (this.release > release) {
                return true;
            }
            if (this.release == release) {
                return this.mod >= mod;
            }
        }
        return false;
    }

    private boolean isZSeriesSkipLevelCompatMode() {
        if (this.version < 10) {
            return false;
        }
        boolean supportsSkipLevelCompatMode = false;
        int[] nArray = SUPPORTS_SKIP_LEVEL_COMPAT_MODE;
        int n = SUPPORTS_SKIP_LEVEL_COMPAT_MODE.length;
        int n2 = 0;
        while (n2 < n) {
            int candidateVersion = nArray[n2];
            if (candidateVersion == this.version) {
                supportsSkipLevelCompatMode = true;
                break;
            }
            ++n2;
        }
        return supportsSkipLevelCompatMode && this.mod < 2;
    }

    public boolean isExactly(int version) {
        return this.version == version;
    }

    public boolean isExactly(int version, int release) {
        return this.version == version && this.release == release;
    }

    public boolean isExactly(int version, int release, int mod) {
        return this.version == version && this.release == release && this.mod == mod;
    }

    public boolean isAtMost(int version) {
        return this.version <= version;
    }

    public boolean isAtMost(int version, int release) {
        if (this.version < version) {
            return true;
        }
        if (this.version == version) {
            return this.release <= release;
        }
        return false;
    }

    public boolean isAtMost(int version, int release, int mod) {
        if (this.version < version) {
            return true;
        }
        if (this.version == version) {
            if (release < 0) {
                return this.mod <= mod;
            }
            if (this.release < release) {
                return true;
            }
            if (this.release == release) {
                return this.mod <= mod;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.product == null) {
            str.append("DB2Version ");
        } else {
            str.append(this.product).append(' ');
        }
        str.append(this.version).append('.').append(this.release).append('.').append(this.mod);
        return str.toString();
    }

    public boolean isSameServerType(DBVersion aVer) {
        boolean isSameType = false;
        if (aVer != null) {
            if (aVer.isDB390() && this.isDB390()) {
                isSameType = true;
            }
            if (aVer.isUNO() && this.isUNO() || aVer.isDB400() && this.isDB400() || aVer.isDerby() && this.isDerby()) {
                isSameType = true;
            }
            if (aVer.isOracle() && this.isOracle()) {
                isSameType = true;
            }
            if (aVer.isIDS() && this.isIDS()) {
                isSameType = true;
            }
            if (aVer.isSybase() && this.isSybase()) {
                isSameType = true;
            }
        }
        return isSameType;
    }

    public String[] normalizeDatabaseDefinitionKeys() {
        String[] dbDefKeys = new String[]{"", ""};
        if (this.isUNO()) {
            dbDefKeys[0] = DB2UDB;
            block0 : switch (this.getVersion()) {
                case 10: {
                    switch (this.getRelease()) {
                        case 1: {
                            dbDefKeys[1] = DB_UDB_VERSION_10_5;
                            break block0;
                        }
                    }
                    dbDefKeys[1] = DB_UDB_VERSION_10_1;
                    break;
                }
                case 9: {
                    switch (this.getRelease()) {
                        case 1: {
                            dbDefKeys[1] = DB_UDB_VERSION_9_5;
                            break block0;
                        }
                    }
                    dbDefKeys[1] = DB_UDB_VERSION_9;
                    break;
                }
                default: {
                    switch (this.getRelease()) {
                        case 1: {
                            dbDefKeys[1] = DB_VERSION_8_REL_1;
                            break block0;
                        }
                    }
                    dbDefKeys[1] = DB_VERSION_8_REL_2;
                    break;
                }
            }
        } else if (this.isDB390()) {
            dbDefKeys[0] = DB2ZSERIES;
            switch (this.getVersion()) {
                case 7: {
                    dbDefKeys[1] = "V7";
                    break;
                }
                case 8: {
                    if (this.getMod() < 5) {
                        dbDefKeys[1] = DB_ZSERIES_VERSION_8_COMPAT;
                        break;
                    }
                    dbDefKeys[1] = DB_ZSERIES_VERSION_8_NEWFUN;
                    break;
                }
                case 9: {
                    if (this.getMod() < 5) {
                        dbDefKeys[1] = DB_ZSERIES_VERSION_9_COMPAT;
                        break;
                    }
                    dbDefKeys[1] = DB_ZSERIES_VERSION_9_NEWFUN;
                    break;
                }
                case 10: {
                    if (this.getMod() < 5) {
                        dbDefKeys[1] = DB_ZSERIES_VERSION_10_COMPAT;
                        break;
                    }
                    dbDefKeys[1] = DB_ZSERIES_VERSION_10_NEWFUN;
                    break;
                }
                case 11: {
                    if (this.getMod() < 5) {
                        dbDefKeys[1] = DB_ZSERIES_VERSION_11_COMPAT;
                        break;
                    }
                    dbDefKeys[1] = DB_ZSERIES_VERSION_11_NEWFUN;
                    break;
                }
                default: {
                    dbDefKeys[1] = DB_ZSERIES_VERSION_8_NEWFUN;
                    break;
                }
            }
        } else if (this.isDB400()) {
            dbDefKeys[0] = DB2ISERIES;
            if (this.isAtLeast(5)) {
                switch (this.getRelease()) {
                    case 3: {
                        dbDefKeys[1] = DB_ISERIES_VERSION_5_REL_3;
                        break;
                    }
                    case 4: {
                        dbDefKeys[1] = DB_ISERIES_VERSION_5_REL_4;
                        break;
                    }
                    default: {
                        dbDefKeys[1] = DB_ISERIES_VERSION_5_REL_4;
                        break;
                    }
                }
            }
        } else if (this.isIBMCloudscape() || this.isDerby()) {
            dbDefKeys[0] = IBMCLOUDSCAPE;
            if (this.isExactly(10)) {
                dbDefKeys[1] = DB_CLOUDSCAPE_VERSION_10_REL_0;
            }
        }
        return dbDefKeys;
    }

    public String normalizeDatabaseDefinitionName() {
        ReuseStringBuffer dbDefName = ReuseStringBuffer.getBuffer();
        if (this.isUNO()) {
            dbDefName.append(DB2UDB).append('_');
            block0 : switch (this.getVersion()) {
                case 9: {
                    switch (this.getRelease()) {
                        case 1: {
                            dbDefName.append("9.5");
                            break block0;
                        }
                    }
                    dbDefName.append("9.1");
                    break;
                }
                default: {
                    switch (this.getRelease()) {
                        case 1: {
                            dbDefName.append("8.1");
                            break block0;
                        }
                    }
                    dbDefName.append("8.2");
                    break;
                }
            }
        } else if (this.isDB390()) {
            dbDefName.append(DB2ZSERIES).append('_');
            switch (this.getVersion()) {
                case 7: {
                    dbDefName.append("7");
                    break;
                }
                case 8: {
                    if (this.getMod() < 5) {
                        dbDefName.append("8 (Compatibility Mode)");
                        break;
                    }
                    dbDefName.append("8 (New-Function Mode)");
                    break;
                }
                case 9: {
                    if (this.getMod() < 5) {
                        dbDefName.append(DB_ZSERIES_VERSION_9_COMPAT);
                        break;
                    }
                    dbDefName.append(DB_ZSERIES_VERSION_9_NEWFUN);
                    break;
                }
                case 10: {
                    if (this.getMod() < 5) {
                        dbDefName.append(DB_ZSERIES_VERSION_10_COMPAT);
                        break;
                    }
                    dbDefName.append(DB_ZSERIES_VERSION_10_NEWFUN);
                    break;
                }
                case 11: {
                    if (this.getMod() < 5) {
                        dbDefName.append(DB_ZSERIES_VERSION_11_COMPAT);
                        break;
                    }
                    dbDefName.append(DB_ZSERIES_VERSION_11_NEWFUN);
                }
            }
        } else if (this.isDB400()) {
            dbDefName.append(DB2ISERIES).append('_');
            if (this.isAtLeast(5)) {
                switch (this.getRelease()) {
                    case 3: {
                        dbDefName.append(DB_ISERIES_VERSION_5_REL_3);
                        break;
                    }
                    default: {
                        dbDefName.append(DB_ISERIES_VERSION_5_REL_3);
                        break;
                    }
                }
            }
        } else if (this.isIBMCloudscape() || this.isDerby()) {
            dbDefName.append(IBMCLOUDSCAPE).append('_');
            if (this.isExactly(10)) {
                dbDefName.append(DB_CLOUDSCAPE_VERSION_10_REL_0);
            }
        }
        dbDefName.append(".xmi");
        return ReuseStringBuffer.toString(dbDefName);
    }
}

