/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;

public abstract class AbstractStructuredSelectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null) {
            SelectionHistory history;
            IndexedRegion cursorIndexedRegion;
            Region newSelectionRegion;
            ITextSelection textSelection;
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            if (selection instanceof ITextSelection && document != null && (textSelection = (ITextSelection)selection).getLength() < document.getLength() && (newSelectionRegion = this.getNewSelectionRegion(cursorIndexedRegion = this.getCursorIndexedRegion(document, textSelection), textSelection)) != null && (history = (SelectionHistory)editor.getAdapter(SelectionHistory.class)) != null) {
                history.remember((IRegion)new Region(textSelection.getOffset(), textSelection.getLength()));
                try {
                    history.ignoreSelectionChanges();
                    textEditor.selectAndReveal(newSelectionRegion.getOffset(), newSelectionRegion.getLength());
                }
                finally {
                    history.listenToSelectionChanges();
                }
            }
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IndexedRegion getIndexedRegion(IDocument document, int offset) {
        IndexedRegion indexedRegion = null;
        int lastOffset = offset;
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        if (model == null) return indexedRegion;
        try {
            block6: {
                block5: {
                    indexedRegion = model.getIndexedRegion(lastOffset);
                    if (!true) break block5;
                    if (indexedRegion != null) return indexedRegion;
                    if (lastOffset < 0) break block6;
                }
                do {
                    indexedRegion = model.getIndexedRegion(--lastOffset);
                    if (indexedRegion != null) return indexedRegion;
                } while (lastOffset >= 0);
            }
            return indexedRegion;
        }
        finally {
            model.releaseFromRead();
        }
    }

    protected abstract IndexedRegion getCursorIndexedRegion(IDocument var1, ITextSelection var2);

    protected abstract Region getNewSelectionRegion(IndexedRegion var1, ITextSelection var2);
}

