/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLSwitch;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ADTReadOnlyFileEditorInput;
import org.eclipse.wst.xsd.ui.internal.editor.XSDHyperlinkTargetLocator;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenOnSelectionHelper
extends WSDLSwitch {
    Definition definition;
    Attr attr = null;
    Element element = null;

    public OpenOnSelectionHelper(Definition definition) {
        this.definition = definition;
    }

    public void openEditor(EObject eObject) {
        String[] array = this.computeSpecification(eObject);
        if (array != null) {
            this.openEditor(array[0], array[1]);
        }
    }

    public void openEditor(Node node) {
        String[] array = this.computeSpecification(node);
        if (array != null) {
            this.openEditor(array[0], array[1]);
        }
    }

    protected void openEditor(String resource, String spec) {
        block19: {
            String pattern = "platform:/resource";
            IWorkbenchPage workbenchPage = WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = workbenchPage.getActiveEditor();
            String currentEditorId = editorPart.getEditorSite().getId();
            if (resource != null && resource.startsWith(pattern)) {
                try {
                    Path path = new Path(resource.substring(pattern.length()));
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    if (editorPart.getEditorInput() instanceof IFileEditorInput && ((IFileEditorInput)editorPart.getEditorInput()).getFile().equals((Object)file)) {
                        workbenchPage.getNavigationHistory().markLocation(editorPart);
                    } else {
                        try {
                            editorPart = resource.endsWith("xsd") ? workbenchPage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor") : workbenchPage.openEditor((IEditorInput)new FileEditorInput(file), editorPart.getEditorSite().getId());
                        }
                        catch (PartInitException partInitException) {}
                    }
                    Class<?> theClass = editorPart.getClass();
                    Class[] methodArgs = new Class[]{String.class};
                    Method method = theClass.getMethod("openOnSelection", methodArgs);
                    Object[] args = new Object[]{spec};
                    method.invoke((Object)editorPart, args);
                    workbenchPage.getNavigationHistory().markLocation(editorPart);
                }
                catch (Exception exception) {}
            } else if (resource != null && resource.startsWith("http")) {
                IEditorPart newEditorPart = null;
                boolean doOpenWsdlEditor = true;
                if (resource.endsWith("xsd")) {
                    doOpenWsdlEditor = false;
                }
                try {
                    IEditorReference[] refs = workbenchPage.getEditorReferences();
                    int length = refs.length;
                    int i = 0;
                    while (i < length) {
                        ADTReadOnlyFileEditorInput readOnlyEditorInput;
                        IEditorInput input = refs[i].getEditorInput();
                        if (input instanceof ADTReadOnlyFileEditorInput && (readOnlyEditorInput = (ADTReadOnlyFileEditorInput)input).getUrlString().equals(resource) && (!doOpenWsdlEditor && readOnlyEditorInput.getEditorID().equals("org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor") || doOpenWsdlEditor && readOnlyEditorInput.getEditorID().equals("org.eclipse.wst.wsdl.ui.internal.WSDLEditor"))) {
                            newEditorPart = refs[i].getEditor(true);
                            workbenchPage.activate(refs[i].getPart(true));
                            break;
                        }
                        ++i;
                    }
                    if (newEditorPart != null) break block19;
                    ADTReadOnlyFileEditorInput readOnlyStorageEditorInput = new ADTReadOnlyFileEditorInput(resource);
                    Object contentType = null;
                    InputStream iStream = null;
                    try {
                        iStream = readOnlyStorageEditorInput.getStorage().getContents();
                        contentType = Platform.getContentTypeManager().findContentTypeFor(iStream, resource);
                    }
                    catch (CoreException coreException) {}
                    if (contentType != null && contentType.equals("org.eclipse.wst.xsd.core.xsdsource") || resource.endsWith("xsd")) {
                        readOnlyStorageEditorInput.setEditorID("org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
                        workbenchPage.openEditor((IEditorInput)readOnlyStorageEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                    } else {
                        readOnlyStorageEditorInput.setEditorID(currentEditorId);
                        workbenchPage.openEditor((IEditorInput)readOnlyStorageEditorInput, currentEditorId, true, 0);
                    }
                }
                catch (PartInitException partInitException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] computeSpecification(EObject eObject) {
        Resource resource;
        EObject referencedEObject;
        String[] result = null;
        Object referencedObject = this.doSwitch(eObject);
        if (referencedObject instanceof EObject && ((referencedEObject = (EObject)referencedObject) != eObject || referencedEObject.eResource() != this.definition.eResource()) && (resource = referencedEObject.eResource()) != null) {
            result = new String[]{resource.getURI().toString(), resource.getURIFragment(referencedEObject)};
        }
        return result;
    }

    public String[] computeSpecification(Node node) {
        Object object;
        String[] result = null;
        switch (node.getNodeType()) {
            case 1: {
                this.element = (Element)node;
                break;
            }
            case 2: {
                this.attr = (Attr)node;
                this.element = this.attr.getOwnerElement();
                break;
            }
            case 3: {
                Node parent = node.getParentNode();
                Element element = this.element = parent instanceof Element ? (Element)parent : null;
            }
        }
        if (this.element != null && (object = WSDLEditorUtil.getInstance().findModelObjectForElement(this.definition, this.element)) instanceof EObject) {
            result = this.computeSpecification((EObject)object);
        }
        return result;
    }

    public Object caseBinding(Binding binding) {
        Binding result = binding;
        if (this.isMatchingAttribute("type")) {
            result = binding.getEPortType();
        }
        return result;
    }

    public Object caseDefinition(Definition definition) {
        return definition;
    }

    public Object casePart(Part part) {
        Part result = part;
        if (this.attr != null) {
            if (this.isMatchingAttribute("type")) {
                result = part.getTypeDefinition();
            } else if (this.isMatchingAttribute("element")) {
                result = part.getElementDeclaration();
            }
        } else if (part.getEnclosingDefinition() == this.definition) {
            result = part.getTypeDefinition() != null ? part.getTypeDefinition() : part.getElementDeclaration();
        }
        return result;
    }

    public Object casePort(Port port) {
        Port result = port;
        if (this.isMatchingAttribute("binding")) {
            result = port.getEBinding();
        }
        return result;
    }

    public Object caseFault(Fault fault) {
        Fault result = fault;
        if (this.isMatchingAttribute("message")) {
            result = fault.getMessage();
        }
        return result;
    }

    public Object caseInput(Input input) {
        Input result = input;
        if (this.isMatchingAttribute("message")) {
            result = input.getMessage();
        }
        return result;
    }

    public Object caseOutput(Output output) {
        Output result = output;
        if (this.isMatchingAttribute("message")) {
            result = output.getMessage();
        }
        return result;
    }

    public Object caseImport(Import theImport) {
        XSDSchema result = null;
        Path importPath = new Path(theImport.getLocationURI());
        String extension = importPath.getFileExtension();
        if (extension.equalsIgnoreCase("xsd")) {
            if (theImport.getESchema() == null) {
                ((ImportImpl)theImport).importDefinitionOrSchema();
            }
            result = theImport.getESchema();
        } else if (extension.equalsIgnoreCase("wsdl") || extension.endsWith("wsdl")) {
            if (theImport.getEDefinition() == null) {
                ((ImportImpl)theImport).importDefinitionOrSchema();
            }
            result = theImport.getEDefinition();
        }
        return result;
    }

    public Object caseWSDLElement(WSDLElement wsdlElement) {
        return wsdlElement;
    }

    private boolean isMatchingAttribute(String value) {
        return this.attr != null && value.equals(this.attr.getName());
    }

    public Object defaultCase(EObject object) {
        EClass theEClass = object.eClass();
        if (theEClass.eContainer() == XSDPackage.eINSTANCE) {
            XSDHyperlinkTargetLocator xsdHyperlinkTargetLocator = new XSDHyperlinkTargetLocator();
            String attributeName = this.attr != null ? this.attr.getName() : null;
            return xsdHyperlinkTargetLocator.locate((XSDConcreteComponent)object, attributeName);
        }
        return super.defaultCase(object);
    }
}

