/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.DefaultEditorMode;
import org.eclipse.wst.wsdl.ui.internal.ISelectionMapper;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorResourceChangeHandler;
import org.eclipse.wst.wsdl.ui.internal.WSDLSelectionMapper;
import org.eclipse.wst.wsdl.ui.internal.actions.OpenInNewEditor;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11AddPartAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11OpenImportAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingElementAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingTypeAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewElementAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewTypeAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Type;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddMessageAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDirectEditAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.BaseSelectionAction;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicalViewer;
import org.eclipse.wst.wsdl.ui.internal.asd.design.KeyboardDragImpl;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.DefinitionsEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ASDContentOutlinePage;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;
import org.eclipse.wst.wsdl.ui.internal.edit.W11BindingReferenceEditManager;
import org.eclipse.wst.wsdl.ui.internal.edit.W11InterfaceReferenceEditManager;
import org.eclipse.wst.wsdl.ui.internal.edit.W11MessageReferenceEditManager;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLXSDElementReferenceEditManager;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLXSDTypeReferenceEditManager;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.W11OpenExternalEditorHelper;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLAdapterFactoryHelper;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLImportManager;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLResourceUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.adt.design.IKeyboardDrag;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorMode;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorModeManager;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InternalWSDLMultiPageEditor
extends ASDMultiPageEditor {
    protected WSDLEditorResourceChangeHandler resourceChangeHandler;
    protected WSDLModelAdapter modelAdapter;
    protected SourceEditorSelectionListener fSourceEditorSelectionListener;
    protected WSDLSelectionManagerSelectionListener fWSDLSelectionListener;
    private static final String WSDL_EDITOR_MODE_EXTENSION_ID = "org.eclipse.wst.wsdl.ui.editorModes";
    private static final String DEFAULT_EDITOR_MODE_ID = "org.eclipse.wst.wsdl.ui.defaultEditorModeId";

    @Override
    public IDescription buildModel(IEditorInput editorInput) {
        try {
            IDocument doc = this.structuredTextEditor.getDocumentProvider().getDocument((Object)editorInput);
            this.createAndSetModel(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.model;
    }

    private void createAndSetModel(IDocument textDocument) {
        if (textDocument != null) {
            IDOMDocument document = null;
            IStructuredModel structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(textDocument);
            try {
                if (structuredModel instanceof IDOMModel) {
                    document = ((IDOMModel)structuredModel).getDocument();
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
            if (document instanceof INodeNotifier) {
                WSDLModelAdapter modelAdapter = WSDLModelAdapter.lookupOrCreateModelAdapter((Document)document);
                Definition definition = modelAdapter.createDefinition((Document)document);
                WSDLAdapterFactoryHelper helper = WSDLAdapterFactoryHelper.getInstance();
                this.model = (IDescription)helper.adapt((Notifier)definition);
            }
        }
    }

    private XSDSchema[] getInlineSchemas() {
        List types = this.getModel().getTypes();
        XSDSchema[] schemas = new XSDSchema[types.size()];
        int index = 0;
        while (index < types.size()) {
            W11Type type = (W11Type)types.get(index);
            schemas[index] = (XSDSchema)type.getTarget();
            ++index;
        }
        return schemas;
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == Definition.class) {
            return ((W11Description)this.getModel()).getTarget();
        }
        if (type == ISelectionMapper.class) {
            return new WSDLSelectionMapper();
        }
        if (type == Definition.class && this.model instanceof Adapter) {
            return ((Adapter)this.model).getTarget();
        }
        if (type == IOpenExternalEditorHelper.class) {
            return new W11OpenExternalEditorHelper(this.getEditorInput());
        }
        if (type == XSDTypeReferenceEditManager.class) {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                WSDLXSDTypeReferenceEditManager refManager = new WSDLXSDTypeReferenceEditManager(fileEditorInput.getFile(), null);
                refManager.setSchemas(this.getInlineSchemas());
                return refManager;
            }
        } else if (type == XSDElementReferenceEditManager.class) {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                WSDLXSDElementReferenceEditManager refManager = new WSDLXSDElementReferenceEditManager(fileEditorInput.getFile(), null);
                refManager.setSchemas(this.getInlineSchemas());
                return refManager;
            }
        } else if (type == W11BindingReferenceEditManager.class) {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                return new W11BindingReferenceEditManager((W11Description)this.getModel(), fileEditorInput.getFile());
            }
        } else if (type == W11InterfaceReferenceEditManager.class) {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                return new W11InterfaceReferenceEditManager((W11Description)this.getModel(), fileEditorInput.getFile());
            }
        } else if (type == W11MessageReferenceEditManager.class) {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                return new W11MessageReferenceEditManager((W11Description)this.getModel(), fileEditorInput.getFile());
            }
        } else {
            if (type == ProductCustomizationProvider.class) {
                return WSDLEditorPlugin.getInstance().getProductCustomizationProvider();
            }
            if (type == IKeyboardDrag.class) {
                return new KeyboardDragImpl();
            }
            if (type == IOpenExternalEditorHelper.class) {
                return new W11OpenExternalEditorHelper(this.getEditorInput());
            }
        }
        return super.getAdapter(type);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.graphicalViewer.getKeyHandler().put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        this.setEditPartFactory(this.getEditorModeManager().getCurrentMode().getEditPartFactory());
    }

    @Override
    protected void createPages() {
        super.createPages();
        if (this.resourceChangeHandler == null) {
            this.resourceChangeHandler = new WSDLEditorResourceChangeHandler(this);
            this.resourceChangeHandler.attach();
        }
        this.fSourceEditorSelectionListener = new SourceEditorSelectionListener();
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        if (provider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        } else {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        }
        this.fWSDLSelectionListener = new WSDLSelectionManagerSelectionListener();
        this.getSelectionManager().addSelectionChangedListener((ISelectionChangedListener)this.fWSDLSelectionListener);
    }

    @Override
    public void dispose() {
        if (this.resourceChangeHandler != null) {
            this.resourceChangeHandler.dispose();
        }
        this.getSelectionManager().removeSelectionChangedListener((ISelectionChangedListener)this.fWSDLSelectionListener);
        super.dispose();
    }

    public void reloadDependencies() {
        Definition definition = (Definition)((W11Description)this.getModel()).getTarget();
        if (definition != null) {
            WSDLResourceUtil.reloadDirectives(definition);
            ComponentReferenceUtil.updateBindingReferences(definition);
            ComponentReferenceUtil.updatePortTypeReferences(definition);
            ComponentReferenceUtil.updateMessageReferences(definition);
            ComponentReferenceUtil.updateSchemaReferences(definition);
            definition.setDocumentationElement(definition.getDocumentationElement());
        }
    }

    @Override
    protected void createActions() {
        BaseSelectionAction action;
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        if (!this.isFileReadOnly()) {
            action = new ASDAddMessageAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11AddPartAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11SetNewMessageAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11SetExistingMessageAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11SetNewTypeAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11SetExistingTypeAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11SetNewElementAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            action = new W11SetExistingElementAction((IWorkbenchPart)this);
            action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)action);
            PrintAction printAction = new PrintAction((IWorkbenchPart)this);
            registry.registerAction((IAction)printAction);
            ASDDirectEditAction directEditAction = new ASDDirectEditAction((IEditorPart)this);
            directEditAction.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
            registry.registerAction((IAction)directEditAction);
        }
        action = new W11OpenImportAction((IWorkbenchPart)this);
        action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
        registry.registerAction((IAction)action);
        action = new OpenInNewEditor((IWorkbenchPart)this);
        action.setSelectionProvider((ISelectionProvider)this.getSelectionManager());
        registry.registerAction((IAction)action);
    }

    protected EditorModeManager createEditorModeManager() {
        final ProductCustomizationProvider productCustomizationProvider = (ProductCustomizationProvider)this.getAdapter(ProductCustomizationProvider.class);
        EditorModeManager manager = new EditorModeManager(WSDL_EDITOR_MODE_EXTENSION_ID){

            public void init() {
                if (productCustomizationProvider == null || productCustomizationProvider.isEditorModeApplicable(DefaultEditorMode.ID)) {
                    this.addMode(new DefaultEditorMode());
                }
                super.init();
            }

            protected EditorMode getDefaultMode() {
                EditorMode editorMode;
                String defaultModeId = WSDLEditorPlugin.getInstance().getPreferenceStore().getString(InternalWSDLMultiPageEditor.DEFAULT_EDITOR_MODE_ID);
                if (defaultModeId != null && (editorMode = this.getEditorMode(defaultModeId)) != null) {
                    return editorMode;
                }
                return super.getDefaultMode();
            }
        };
        manager.setProductCustomizationProvider(productCustomizationProvider);
        return manager;
    }

    public void editorModeChanged(EditorMode newEditorMode) {
        TreeViewer treeViewer;
        ASDContentOutlinePage outline;
        IContentProvider provider;
        EditPartFactory editPartFactory = newEditorMode.getEditPartFactory();
        if (editPartFactory != null) {
            this.graphicalViewer.setEditPartFactory(editPartFactory);
            if (this.graphicalViewer instanceof DesignViewGraphicalViewer) {
                DesignViewGraphicalViewer viewer = (DesignViewGraphicalViewer)this.graphicalViewer;
                DefinitionsEditPart editPart = (DefinitionsEditPart)viewer.getRootEditPart().getContents();
                editPart.setModelChildren(Collections.EMPTY_LIST);
                editPart.refresh();
                editPart.setModelChildren(null);
                editPart.refresh();
            }
        }
        if ((provider = newEditorMode.getOutlineProvider()) != null && (outline = (ASDContentOutlinePage)this.getContentOutlinePage()) != null && (treeViewer = outline.getTreeViewer()) != null) {
            outline.getTreeViewer().setContentProvider(provider);
            outline.getTreeViewer().refresh();
        }
    }

    protected void storeCurrentModePreference(String id) {
        WSDLEditorPlugin.getInstance().getPreferenceStore().setValue(DEFAULT_EDITOR_MODE_ID, id);
    }

    protected void setInputToGraphicalViewer(IDocument newDocument) {
        ASDContentOutlinePage outline;
        TreeViewer treeViewer;
        this.createAndSetModel(newDocument);
        if (this.graphicalViewer != null) {
            this.graphicalViewer.setContents((Object)this.model);
            this.graphicalViewer.getContents().refresh();
        }
        if (this.getContentOutlinePage() instanceof ASDContentOutlinePage && (treeViewer = (outline = (ASDContentOutlinePage)this.getContentOutlinePage()).getTreeViewer()) != null) {
            outline.setModel(this.model);
            treeViewer.setInput((Object)this.model);
            treeViewer.refresh();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        WSDLImportManager.removeUnusedImports((Definition)this.getAdapter(Definition.class));
        super.doSave(monitor);
    }

    public void doSaveAs() {
        IDocument oldDocument = this.getDocument();
        WSDLModelAdapter oldAdapter = null;
        IDOMDocument doc = null;
        if (oldDocument != null) {
            IStructuredModel structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(oldDocument);
            try {
                if (structuredModel instanceof IDOMModel && (doc = ((IDOMModel)structuredModel).getDocument()) != null) {
                    oldAdapter = (WSDLModelAdapter)doc.getExistingAdapter(WSDLModelAdapter.class);
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        IEditorInput oldEditorInput = this.structuredTextEditor.getEditorInput();
        this.structuredTextEditor.doSaveAs();
        IEditorInput newEditorInput = this.structuredTextEditor.getEditorInput();
        if (oldEditorInput != newEditorInput) {
            this.setInput(newEditorInput);
            this.setPartName(newEditorInput.getName());
            this.getCommandStack().markSaveLocation();
            if (oldAdapter != null) {
                oldAdapter.clear();
                oldAdapter = null;
            }
        }
    }

    public void propertyChanged(Object source, int propId) {
        switch (propId) {
            case 258: {
                Definition definition = (Definition)this.getAdapter(Definition.class);
                if (source != this.structuredTextEditor || definition == null) break;
                IStructuredModel structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
                try {
                    IDOMDocument domModelDocument;
                    Document definitionDocument;
                    if (structuredModel instanceof IDOMModel && (definitionDocument = definition.getDocument()) != (domModelDocument = ((IDOMModel)structuredModel).getDocument())) {
                        WSDLModelAdapter oldModelAdapter = null;
                        if (definitionDocument instanceof IDOMDocument) {
                            oldModelAdapter = (WSDLModelAdapter)((IDOMDocument)definitionDocument).getExistingAdapter(WSDLModelAdapter.class);
                        }
                        IEditorInput editorInput = this.structuredTextEditor.getEditorInput();
                        this.setInput(editorInput);
                        this.setPartName(editorInput.getName());
                        this.getCommandStack().markSaveLocation();
                        if (oldModelAdapter != null) {
                            oldModelAdapter.clear();
                            oldModelAdapter = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    throw throwable;
                }
                if (structuredModel == null) break;
                structuredModel.releaseFromRead();
            }
        }
        super.propertyChanged(source, propId);
    }

    private class SourceEditorSelectionListener
    implements ISelectionChangedListener {
        private SourceEditorSelectionListener() {
        }

        private Object getWSDLFacadeObject(Object object) {
            Node node;
            Element element = null;
            if (object instanceof Node && (node = (Node)object) != null) {
                if (node.getNodeType() == 1) {
                    element = (Element)node;
                } else if (node.getNodeType() == 2) {
                    element = ((Attr)node).getOwnerElement();
                }
            }
            Element o = element;
            if (element != null) {
                Definition def = (Definition)((W11Description)InternalWSDLMultiPageEditor.this.model).getTarget();
                Object modelObject = WSDLEditorUtil.getInstance().findModelObjectForElement(def, element);
                if (modelObject instanceof XSDSchemaExtensibilityElement) {
                    modelObject = ((XSDSchemaExtensibilityElement)modelObject).getSchema();
                }
                if (modelObject != null) {
                    o = WSDLAdapterFactoryHelper.getInstance().adapt((Notifier)modelObject);
                }
            }
            return o;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (InternalWSDLMultiPageEditor.this.getSelectionManager().getEnableNotify() && InternalWSDLMultiPageEditor.this.getActivePage() == 1 && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> selections = new ArrayList<Object>();
                for (Object domNode : (IStructuredSelection)selection) {
                    Object facade = this.getWSDLFacadeObject(domNode);
                    if (facade == null) continue;
                    selections.add(facade);
                }
                if (!selections.isEmpty()) {
                    StructuredSelection wsdlSelection = new StructuredSelection(selections);
                    InternalWSDLMultiPageEditor.this.getSelectionManager().setSelection((ISelection)wsdlSelection, InternalWSDLMultiPageEditor.this.getTextEditor().getSelectionProvider());
                }
            }
        }
    }

    private class WSDLSelectionManagerSelectionListener
    implements ISelectionChangedListener {
        private WSDLSelectionManagerSelectionListener() {
        }

        private Object getObjectForOtherModel(Object object) {
            Node node = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof String) {
                String uriFragment = (String)object;
                Definition definition = (Definition)((W11Description)InternalWSDLMultiPageEditor.this.getModel()).getTarget();
                EObject modelObject = definition.eResource().getEObject(uriFragment);
                if (modelObject != null) {
                    node = WSDLEditorUtil.getInstance().getNodeForObject(modelObject);
                }
            } else {
                node = WSDLEditorUtil.getInstance().getNodeForObject(object);
            }
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            IWorkbenchPage page;
            boolean makeSelection = true;
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && !(event.getSource() instanceof IPostSelectionProvider) && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActivePart() instanceof InternalWSDLMultiPageEditor && InternalWSDLMultiPageEditor.this.getActiveEditor() instanceof StructuredTextEditor) {
                makeSelection = false;
            }
            if (event.getSource() != InternalWSDLMultiPageEditor.this.getTextEditor().getSelectionProvider() && makeSelection && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> otherModelObjectList = new ArrayList<Object>();
                for (Object wsdlObject : (IStructuredSelection)selection) {
                    Object otherModelObject;
                    if (wsdlObject instanceof WSDLBaseAdapter) {
                        wsdlObject = ((WSDLBaseAdapter)wsdlObject).getTarget();
                    }
                    if ((otherModelObject = this.getObjectForOtherModel(wsdlObject)) == null) continue;
                    otherModelObjectList.add(otherModelObject);
                }
                if (!otherModelObjectList.isEmpty()) {
                    StructuredSelection nodeSelection = new StructuredSelection(otherModelObjectList);
                    InternalWSDLMultiPageEditor.this.getTextEditor().getSelectionProvider().setSelection((ISelection)nodeSelection);
                }
            }
        }
    }
}

