/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

class InferConsts
implements CompilerPass {
    private final AbstractCompiler compiler;

    InferConsts(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node js) {
        ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
        NodeTraversal.traverseEs6(this.compiler, js, collector);
        for (Var v : collector.getAllSymbols()) {
            this.considerVar(v, collector.getReferences(v));
        }
        Scope globalExternsScope = SyntacticScopeCreator.makeUntyped(this.compiler).createScope(externs, null);
        for (Var var : globalExternsScope.getAllSymbols()) {
            this.considerVar(var, null);
        }
    }

    private void considerVar(Var v, ReferenceCollectingCallback.ReferenceCollection refCollection) {
        Node nameNode = v.getNameNode();
        JSDocInfo docInfo = v.getJSDocInfo();
        if (docInfo != null && docInfo.isConstant()) {
            nameNode.putBooleanProp(64, true);
        } else if (nameNode != null && nameNode.getParent().isConst()) {
            nameNode.putBooleanProp(64, true);
        } else if (nameNode != null && this.compiler.getCodingConvention().isConstant(nameNode.getString())) {
            nameNode.putBooleanProp(64, true);
        } else if (nameNode != null && refCollection != null && refCollection.isWellDefined() && refCollection.isAssignedOnceInLifetime() && refCollection.firstReferenceIsAssigningDeclaration()) {
            nameNode.putBooleanProp(64, true);
        }
    }
}

