/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class FacetProjectCreationDataModelProvider
extends AbstractDataModelProvider
implements IFacetProjectCreationDataModelProperties {
    public static final String REQUIRED_FACETS_COLLECTION = "FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION";
    public static final String FORCE_VERSION_COMPLIANCE = "FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE";
    private List<IFacetedProjectListener> facetedProjectListeners = new ArrayList<IFacetedProjectListener>();
    private IDataModelListener dataModelListener;
    private final IFacetedProjectWorkingCopy fpjwc = FacetedProjectFramework.createNewProject();

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        names.add("IFacetDataModelProperties.FACET_PROJECT_NAME");
        names.add("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        names.add("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        names.add("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        names.add(REQUIRED_FACETS_COLLECTION);
        names.add(FORCE_VERSION_COMPLIANCE);
        return names;
    }

    public void init() {
        super.init();
        this.model.setProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY", (Object)this.fpjwc);
        IFacetedProjectListener projectFacetChangedListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                for (IFacetedProject.Action action : FacetProjectCreationDataModelProvider.this.fpjwc.getProjectFacetActions()) {
                    IDataModel dm;
                    Object config = action.getConfig();
                    if (config == null || !(config instanceof IDataModel) || !(dm = (IDataModel)config).getAllProperties().contains("FacetInstallDataModelProvider.MASTER_PROJECT_DM")) continue;
                    dm.setProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM", (Object)FacetProjectCreationDataModelProvider.this.model);
                }
            }
        };
        this.facetedProjectListeners.add(projectFacetChangedListener);
        this.fpjwc.addListener(projectFacetChangedListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        IFacetedProjectListener availableRuntimeChangedListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetProjectCreationDataModelProvider.this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
            }
        };
        this.facetedProjectListeners.add(availableRuntimeChangedListener);
        this.fpjwc.addListener(availableRuntimeChangedListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.AVAILABLE_RUNTIMES_CHANGED});
        IDataModel projectDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ProjectCreationDataModelProviderNew());
        this.dataModelListener = new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                String prop = event.getPropertyName();
                if (event.getFlag() == 1 && prop.equals("IProjectCreationPropertiesNew.PROJECT_NAME")) {
                    String projectName = (String)event.getProperty();
                    FacetProjectCreationDataModelProvider.this.getDataModel().setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
                    IStatus status = FacetProjectCreationDataModelProvider.this.getDataModel().validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    if (status.isOK()) {
                        FacetProjectCreationDataModelProvider.this.fpjwc.setProjectName(projectName);
                    }
                } else if (prop.equals("IProjectCreationPropertiesNew.PROJECT_LOCATION")) {
                    String location = (String)event.getProperty();
                    FacetProjectCreationDataModelProvider.this.fpjwc.setProjectLocation((IPath)(location == null ? null : new Path(location)));
                }
            }
        };
        projectDataModel.addListener(this.dataModelListener);
        this.model.addNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM", projectDataModel);
    }

    public void dispose() {
        IDataModel nestedProjectDM;
        if (this.fpjwc != null) {
            for (IFacetedProjectListener listener : this.facetedProjectListeners) {
                this.fpjwc.removeListener(listener);
            }
            this.fpjwc.dispose();
        }
        if (this.model != null && (nestedProjectDM = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM")) != null) {
            nestedProjectDM.removeListener(this.dataModelListener);
        }
        this.setDataModel(null);
        super.dispose();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        block10: {
            block11: {
                block9: {
                    if (!"IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) break block9;
                    Iterator iterator = ((Map)this.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).values().iterator();
                    while (iterator.hasNext()) {
                        ((IDataModel)iterator.next()).setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
                    }
                    IDataModel projModel = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
                    projModel.setProperty("IProjectCreationPropertiesNew.PROJECT_NAME", propertyValue);
                    break block10;
                }
                if (!"IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) break block11;
                IRuntime runtime = (IRuntime)propertyValue;
                for (IDataModel dm : ((Map)this.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).values()) {
                    if (!dm.isProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) continue;
                    dm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
                }
                if (runtime == null || !this.getBooleanProperty(FORCE_VERSION_COMPLIANCE)) break block10;
                Map facetDMs = (Map)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                for (IDataModel facetDataModel : facetDMs.values()) {
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)((String)facetDataModel.getProperty("IFacetDataModelProperties.FACET_ID")));
                    try {
                        IDataModel facetModel = ((IFacetProjectCreationDataModelProperties.FacetDataModelMap)facetDMs).getFacetDataModel(facet.getId());
                        IProjectFacetVersion oldVersion = (IProjectFacetVersion)facetModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                        IProjectFacetVersion newVersion = facet.getLatestSupportedVersion(runtime);
                        if (newVersion == null || oldVersion != null && oldVersion.compareTo((Object)newVersion) <= 0 && runtime.supports(oldVersion)) continue;
                        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)newVersion);
                    }
                    catch (CoreException e) {
                        ModulecorePlugin.logError(e);
                    }
                }
                break block10;
            }
            if (REQUIRED_FACETS_COLLECTION.equals(propertyName)) {
                IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
                Collection fixedFacets = (Collection)propertyValue;
                fpjwc.setFixedProjectFacets(new HashSet(fixedFacets));
                IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDmMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                for (IProjectFacet facet : fixedFacets) {
                    IFacetedProject.Action action = fpjwc.getProjectFacetAction(facet);
                    Object config = action.getConfig();
                    if (!(config instanceof IDataModel)) {
                        config = Platform.getAdapterManager().loadAdapter(config, IDataModel.class.getName());
                    }
                    IDataModel dm = (IDataModel)config;
                    facetDmMap.put(facet.getId(), dm);
                    for (String alias : facet.getAliases()) {
                        facetDmMap.put(alias, dm);
                    }
                }
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_DM_MAP".equals(propertyName)) {
            FacetDataModelMapImpl obj = new FacetDataModelMapImpl();
            this.setProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", obj);
            return obj;
        }
        if ("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP".equals(propertyName)) {
            FacetActionMapImpl obj = new FacetActionMapImpl();
            this.setProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", obj);
            return obj;
        }
        if (REQUIRED_FACETS_COLLECTION.equals(propertyName)) {
            ArrayList c = new ArrayList();
            this.setProperty(REQUIRED_FACETS_COLLECTION, c);
            return c;
        }
        if (FORCE_VERSION_COMPLIANCE.equals(propertyName)) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IRuntime runtime = (IRuntime)this.getProperty(propertyName);
            if (runtime != null) {
                return new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
            }
            return new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            Set fixedFacets = fpjwc.getFixedProjectFacets();
            ArrayList<IRuntime> list = new ArrayList<IRuntime>();
            for (IRuntime rt : RuntimeManager.getRuntimes()) {
                boolean supports = true;
                for (IProjectFacet facet : fixedFacets) {
                    if (rt.supports(facet)) continue;
                    supports = false;
                    break;
                }
                if (!supports) continue;
                list.add(rt);
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size() + 1];
            Iterator iterator = list.iterator();
            int i = 0;
            while (i < descriptors.length - 1) {
                IRuntime runtime = (IRuntime)iterator.next();
                descriptors[i] = new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
                ++i;
            }
            if (descriptors.length > 2) {
                Arrays.sort(descriptors, 0, descriptors.length - 1, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                        DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                        return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                    }
                });
            }
            descriptors[descriptors.length - 1] = new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            IDataModel projModel = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
            return projModel.validateProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        if (propertyName.equals("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY")) {
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            return fpjwc.validate();
        }
        return super.validate(propertyName);
    }

    public IDataModelOperation getDefaultOperation() {
        return new FacetProjectCreationOperation(this.model);
    }

    protected class FacetActionMapImpl
    extends HashMap
    implements IFacetProjectCreationDataModelProperties.FacetActionMap {
        private static final long serialVersionUID = 1L;
        private boolean supressNotification = false;

        protected FacetActionMapImpl() {
        }

        @Override
        public void add(IFacetedProject.Action action) {
            this.put(action.getProjectFacetVersion().getProjectFacet().getId(), action);
        }

        @Override
        public IFacetedProject.Action getAction(String facetID) {
            return (IFacetedProject.Action)this.get(facetID);
        }

        @Override
        public void clear() {
            try {
                this.supressNotification = true;
                super.clear();
            }
            finally {
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
            }
        }

        @Override
        public Object remove(Object key) {
            try {
                Object v = super.remove(key);
                return v;
            }
            finally {
                if (!this.supressNotification) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
                }
            }
        }

        @Override
        public Object put(Object key, Object value) {
            try {
                Object object = super.put(key, value);
                return object;
            }
            finally {
                if (!this.supressNotification) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
                }
            }
        }

        @Override
        public void putAll(Map m) {
            try {
                this.supressNotification = true;
                super.putAll(m);
            }
            finally {
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
            }
        }
    }

    protected class FacetDataModelMapImpl
    extends HashMap
    implements IFacetProjectCreationDataModelProperties.FacetDataModelMap,
    IDataModelListener {
        private static final long serialVersionUID = 1L;
        private boolean supressNotification = false;

        protected FacetDataModelMapImpl() {
        }

        @Override
        public void add(IDataModel facetDataModel) {
            this.put(facetDataModel.getProperty("IFacetDataModelProperties.FACET_ID"), facetDataModel);
        }

        @Override
        public IDataModel getFacetDataModel(String facetID) {
            return (IDataModel)this.get(facetID);
        }

        @Override
        public void clear() {
            try {
                this.supressNotification = true;
                Iterator iterator = this.values().iterator();
                while (iterator.hasNext()) {
                    ((IDataModel)iterator.next()).removeListener((IDataModelListener)this);
                }
                super.clear();
            }
            finally {
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
            }
        }

        @Override
        public Object put(Object key, Object value) {
            try {
                IDataModel dm = (IDataModel)value;
                Object lastValue = super.put(key, value);
                if (lastValue != null) {
                    ((IDataModel)lastValue).removeListener((IDataModelListener)this);
                    ((IDataModel)lastValue).setProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM", null);
                }
                dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", FacetProjectCreationDataModelProvider.this.getDataModel().getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"));
                dm.setProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM", (Object)FacetProjectCreationDataModelProvider.this.model);
                dm.addListener((IDataModelListener)this);
                Object object = lastValue;
                return object;
            }
            finally {
                if (!this.supressNotification) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
                }
            }
        }

        @Override
        public void putAll(Map m) {
            try {
                this.supressNotification = true;
                super.putAll(m);
            }
            finally {
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
            }
        }

        @Override
        public Object remove(Object key) {
            try {
                IDataModel dm = (IDataModel)super.remove(key);
                dm.removeListener((IDataModelListener)this);
                IDataModel iDataModel = dm;
                return iDataModel;
            }
            finally {
                if (!this.supressNotification) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
                }
            }
        }

        public void propertyChanged(DataModelEvent event) {
            if (event.getPropertyName().equals("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
                if (this.containsValue(event.getDataModel())) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", event.getProperty());
                } else {
                    event.getDataModel().removeListener((IDataModelListener)this);
                }
            } else if (event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
                if (this.containsValue(event.getDataModel())) {
                    if (event.getFlag() == 4) {
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
                    } else if (event.getFlag() == 3) {
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 3);
                    } else {
                        FacetProjectCreationDataModelProvider.this.getDataModel().setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", event.getProperty());
                    }
                } else {
                    event.getDataModel().removeListener((IDataModelListener)this);
                }
            }
        }
    }
}

