/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.postgresql.catalog.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaFactory;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;

public class PostgresSequenceLoader
extends JDBCBaseLoader {
    private static final String SEQUENCE_QUERY = "SELECT c.relname FROM pg_class c WHERE c.relkind = 'S' ORDER BY c.relname";
    private static final String SEQUENCE_NAME = "relname";

    public PostgresSequenceLoader() {
        this(null);
    }

    public PostgresSequenceLoader(ICatalogObject catalogObject) {
        this(catalogObject, (IConnectionFilterProvider)new SchemaObjectFilterProvider("DatatoolsSequenceFilterPredicate"));
    }

    public PostgresSequenceLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void clearSequences(List sequences) {
        sequences.clear();
    }

    public void loadSequences(List containmentList, Collection existingSequences) throws SQLException {
        block35: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                this.initActiveFilter();
                stmt = this.getCatalogObject().getConnection().prepareStatement(SEQUENCE_QUERY);
                rs = this.createResultSet(stmt);
                while (rs.next()) {
                    String sequenceName = rs.getString(SEQUENCE_NAME);
                    if (sequenceName == null || this.isFiltered(sequenceName)) continue;
                    Sequence sequence = (Sequence)this.getAndRemoveSQLObject(existingSequences, sequenceName);
                    if (sequence == null) {
                        sequence = this.processRow(rs);
                        if (sequence == null) continue;
                        containmentList.add(sequence);
                        continue;
                    }
                    containmentList.add(sequence);
                    if (!(sequence instanceof ICatalogObject)) continue;
                    ((ICatalogObject)sequence).refresh();
                }
            }
            catch (Throwable throwable) {
                block33: {
                    try {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                break block33;
                            }
                            catch (SQLException sQLException2) {}
                            break block33;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                        throw throwable2;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            try {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block35;
                    }
                    catch (SQLException sQLException3) {}
                    break block35;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected Sequence processRow(ResultSet rs) throws SQLException {
        Sequence sequence = SQLSchemaFactory.eINSTANCE.createSequence();
        sequence.setName(rs.getString(SEQUENCE_NAME).trim());
        return sequence;
    }

    protected ResultSet createResultSet(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving catalog information (sequences)");
            error.initCause(e);
            throw error;
        }
    }
}

