/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;

public interface MappingFileRefactoringParticipant {
    public Iterable<DeleteEdit> createDeleteMappingFileEdits(IFile var1);

    public Iterable<ReplaceEdit> createRenameFolderEdits(IFolder var1, String var2);

    public Iterable<ReplaceEdit> createRenameMappingFileEdits(IFile var1, String var2);

    public Iterable<ReplaceEdit> createMoveMappingFileEdits(IFile var1, IPath var2);

    public Iterable<ReplaceEdit> createMoveFolderEdits(IFolder var1, IPath var2);

    public static class DeleteMappingFileEditsTransformer
    extends TransformerAdapter<MappingFileRefactoringParticipant, Iterable<DeleteEdit>> {
        protected final IFile file;

        public DeleteMappingFileEditsTransformer(IFile file) {
            this.file = file;
        }

        public Iterable<DeleteEdit> transform(MappingFileRefactoringParticipant participant) {
            return participant.createDeleteMappingFileEdits(this.file);
        }
    }

    public static class MoveFolderEditsTransformer
    extends TransformerAdapter<MappingFileRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IFolder originalFolder;
        protected final IPath destination;

        public MoveFolderEditsTransformer(IFolder originalFolder, IPath destination) {
            this.originalFolder = originalFolder;
            this.destination = destination;
        }

        public Iterable<ReplaceEdit> transform(MappingFileRefactoringParticipant participant) {
            return participant.createMoveFolderEdits(this.originalFolder, this.destination);
        }
    }

    public static class MoveMappingFileEditsTransformer
    extends TransformerAdapter<MappingFileRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IFile originalFile;
        protected final IPath destination;

        public MoveMappingFileEditsTransformer(IFile originalFile, IPath destination) {
            this.originalFile = originalFile;
            this.destination = destination;
        }

        public Iterable<ReplaceEdit> transform(MappingFileRefactoringParticipant participant) {
            return participant.createMoveMappingFileEdits(this.originalFile, this.destination);
        }
    }

    public static class RenameFolderEditsTransformer
    extends TransformerAdapter<MappingFileRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IFolder originalFolder;
        protected final String newName;

        public RenameFolderEditsTransformer(IFolder originalFolder, String newName) {
            this.originalFolder = originalFolder;
            this.newName = newName;
        }

        public Iterable<ReplaceEdit> transform(MappingFileRefactoringParticipant participant) {
            return participant.createRenameFolderEdits(this.originalFolder, this.newName);
        }
    }

    public static class RenameMappingFileEditsTransformer
    extends TransformerAdapter<MappingFileRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IFile originalFile;
        protected final String newName;

        public RenameMappingFileEditsTransformer(IFile originalFile, String newName) {
            this.originalFile = originalFile;
            this.newName = newName;
        }

        public Iterable<ReplaceEdit> transform(MappingFileRefactoringParticipant participant) {
            return participant.createRenameMappingFileEdits(this.originalFile, this.newName);
        }
    }
}

