/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.common;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.part.DrillDownComposite;

abstract class TreeViewerSelectionDialog
extends SelectionDialog {
    private static final String DEFAULT_TITLE = PageDesignerResources.getInstance().getString("TreeViewerSelectionDialog.Title");
    static final int STYLE_NONE = 0;
    static final int STYLE_INFORMATION = 1;
    static final int STYLE_ERROR = 2;
    static final int STYLE_WARNING = 3;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private String _title = DEFAULT_TITLE;
    private static Object _selection;
    private ITreeContentProvider _contentProvider;
    private ILabelProvider _labelProvider;
    private ViewerFilter _filter;
    private Label _statusImage;
    private Label _statusLabel;
    private String _statusMessage;
    private TreeViewer _treeViewer;

    public TreeViewerSelectionDialog(Shell parentShell, String statusMessage) {
        super(parentShell);
        this._statusMessage = statusMessage;
        this.setShellStyle(this.getShellStyle());
    }

    protected void createTreeViewer(Composite parent) {
        DrillDownComposite drillDown = new DrillDownComposite(parent, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 320;
        spec.heightHint = 300;
        drillDown.setLayoutData((Object)spec);
        this._treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this._treeViewer);
    }

    private void setTreeViewerProviders() {
        this._treeViewer.setContentProvider((IContentProvider)this._contentProvider);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this._treeViewer.setSorter(new ViewerSorter());
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                _selection = TreeViewerSelectionDialog.this.getSelectedElement((IStructuredSelection)event.getSelection());
                TreeViewerSelectionDialog.this.updateStatus();
            }
        });
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (TreeViewerSelectionDialog.this._treeViewer.getExpandedState(item)) {
                        TreeViewerSelectionDialog.this._treeViewer.collapseToLevel(item, 1);
                    } else {
                        TreeViewerSelectionDialog.this._treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this._treeViewer.setInput(this.findInputElement());
        if (this._filter != null) {
            this._treeViewer.addFilter(this._filter);
        }
    }

    public void createTreeViewerComposite(Composite parent) {
        Composite treeViewerComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        treeViewerComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        treeViewerComposite.setLayoutData((Object)gridData);
        Label label = new Label(treeViewerComposite, 64);
        label.setText(this._title);
        label.setFont(treeViewerComposite.getFont());
        this.createTreeViewer(treeViewerComposite);
        Dialog.applyDialogFont((Control)treeViewerComposite);
    }

    /*
     * Unable to fully structure code
     */
    public void setSelectedElement(Object selection) {
        if (TreeViewerSelectionDialog._selection != null) {
            this._treeViewer.expandToLevel(TreeViewerSelectionDialog._selection, 1);
        }
        itemsToExpand = new ArrayList<Object>();
        parent = this._contentProvider.getParent(selection);
        if (parent != null) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            itemsToExpand.add(0, parent);
            parent = this._contentProvider.getParent(parent);
lbl9:
            // 2 sources

            ** while (parent != null)
        }
lbl10:
        // 1 sources

        this._treeViewer.setExpandedElements(itemsToExpand.toArray());
        this._treeViewer.setSelection((ISelection)new StructuredSelection(selection), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        area.setLayout((Layout)gridLayout);
        this.createTreeViewerComposite(area);
        this._statusImage = SWTUtils.createLabelImage((Composite)area, (Image)this.getMessageImage(2), (int)1, null);
        this._statusLabel = SWTUtils.createLabel((Composite)area, (String)"", (int)1);
        this.setTreeViewerProviders();
        return this.dialogArea;
    }

    private Object getSelectedElement(IStructuredSelection selection) {
        return selection.getFirstElement();
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this._contentProvider = provider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this._labelProvider = provider;
    }

    public void setFilter(ViewerFilter filter) {
        this._filter = filter;
    }

    private void updateStatus() {
        if (this.isValidSelection(_selection)) {
            this._statusImage.setImage(this.getMessageImage(0));
            this._statusLabel.setText("");
            this.getOkButton().setEnabled(true);
        } else {
            this._statusImage.setImage(this.getMessageImage(2));
            this._statusLabel.setText(this._statusMessage);
            this.getOkButton().setEnabled(false);
        }
    }

    protected Image getMessageImage(int imageType) {
        switch (imageType) {
            case 2: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            case 3: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
        }
        return null;
    }

    protected void okPressed() {
        ArrayList<Object> chosenContainerPathList = new ArrayList<Object>();
        if (_selection != null) {
            chosenContainerPathList.add(_selection);
        }
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (_selection != null) {
            this.setSelectedElement(_selection);
        }
        return control;
    }

    protected abstract boolean isValidSelection(Object var1);

    protected abstract Object findInputElement();
}

