/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import java.util.Arrays;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;

public class HorizontalAlignMeta
extends CSSPropertyMeta {
    static final String[] KEYWORDS = new String[]{"left", "bottom", "top", "right", "center", "justify"};
    private static final String[] HOR_SLIGN_HTMLTAGS = new String[]{"TABLE", "HR", "LEGEND", "APPLET", "IFRAME", "IMG", "INPUT", "OBJECT", "CAPTION"};

    public HorizontalAlignMeta() {
        super(true, NOT_SPECIFIED);
    }

    public HorizontalAlignMeta(boolean inherit, Object initvalue) {
        super(inherit, initvalue);
    }

    @Override
    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        if (Arrays.asList(HOR_SLIGN_HTMLTAGS).contains(htmltag.toUpperCase())) {
            String align = DOMUtil.getAttributeIgnoreCase(element, "align");
            return this.checkKeywordValues(align);
        }
        return null;
    }

    @Override
    public Object getHTMLElementInitialValue(Element element, String htmltag, String propertyName) {
        if ("HR".equalsIgnoreCase(htmltag.toUpperCase())) {
            return "center";
        }
        if (Arrays.asList(HOR_SLIGN_HTMLTAGS).contains(htmltag.toUpperCase())) {
            return "left";
        }
        return super.getHTMLElementInitialValue(element, htmltag, propertyName);
    }
}

