/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.io.File;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PersistableCElementFactory
implements IElementFactory,
IPersistableElement {
    private static final String TAG_PATH = "path";
    private static final String TAG_TYPE = "type";
    private static final String FACTORY_ID = "org.eclipse.cdt.ui.PersistableCElementFactory";
    private ICElement fCElement;

    public PersistableCElementFactory() {
    }

    public PersistableCElementFactory(ICElement input) {
        this.fCElement = input;
    }

    public IAdaptable createElement(IMemento memento) {
        IResource resource;
        String fileName = memento.getString(TAG_PATH);
        if (fileName == null) {
            return null;
        }
        Path elementPath = new Path(fileName);
        this.fCElement = CoreModel.getDefault().create((IPath)elementPath);
        if (this.fCElement != null && this.fCElement.getResource() != null && !(resource = this.fCElement.getResource()).isAccessible()) {
            return resource;
        }
        if (this.fCElement != null) {
            return this.fCElement;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Integer elementType = memento.getInteger(TAG_TYPE);
        if (elementType == null) {
            if (elementPath.segmentCount() == 1) {
                return root.getProject(fileName);
            }
            IFolder folder = root.getFolder((IPath)elementPath);
            File osFile = folder.getLocation().toFile();
            if (osFile.isDirectory()) {
                return folder;
            }
            return root.getFile((IPath)elementPath);
        }
        switch (elementType) {
            case 8: {
                return root;
            }
            case 4: {
                return root.getProject(fileName);
            }
            case 2: {
                return root.getFolder((IPath)elementPath);
            }
            case 1: {
                return root.getFile((IPath)elementPath);
            }
        }
        return null;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        if (this.fCElement.getResource() != null) {
            memento.putString(TAG_PATH, this.fCElement.getResource().getFullPath().toString());
            memento.putInteger(TAG_TYPE, this.fCElement.getResource().getType());
        }
    }
}

