/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.osgi.framework.Bundle;

public class ResourceBundleHelper {
    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle resourceBundle = null;
        String equinoxLocale = ResourceBundleHelper.getEquinoxRootLocale();
        if (equinoxLocale.length() > 0 && locale.toString().startsWith(equinoxLocale)) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, loader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, Bundle bundle) {
        return ResourceBundleHelper.getEquinoxResourceBundle(baseName, locale, new BundleResourceBundleControl(bundle, true), new BundleResourceBundleControl(bundle, false));
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, ResourceBundle.Control withFallback, ResourceBundle.Control withoutFallback) {
        ResourceBundle resourceBundle = null;
        String equinoxLocale = ResourceBundleHelper.getEquinoxRootLocale();
        if (equinoxLocale.length() > 0 && locale.toString().startsWith(equinoxLocale)) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, withoutFallback);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), withoutFallback);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, withFallback);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    private static String getEquinoxRootLocale() {
        String root = System.getProperties().getProperty("equinox.root.locale");
        if (root == null) {
            root = "en";
        }
        return root;
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        String language = "";
        String country = "";
        String variant = "";
        String[] localeParts = str.split("_");
        if (localeParts.length == 0 || localeParts.length > 3 || localeParts.length == 1 && localeParts[0].length() == 0) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (localeParts[0].length() == 1 || localeParts[0].length() > 2) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (localeParts[0].length() == 2) {
            char ch0 = localeParts[0].charAt(0);
            char ch1 = localeParts[0].charAt(1);
            if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
        }
        language = localeParts[0];
        if (localeParts.length > 1) {
            if (localeParts[1].length() == 1 || localeParts[1].length() > 2) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (localeParts[1].length() == 2) {
                char ch3 = localeParts[1].charAt(0);
                char ch4 = localeParts[1].charAt(1);
                if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
                    throw new IllegalArgumentException("Invalid locale format: " + str);
                }
            }
            country = localeParts[1];
        }
        if (localeParts.length == 3) {
            if (localeParts[0].length() == 0 && localeParts[1].length() == 0) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            variant = localeParts[2];
        }
        return Locale.of(language, country, variant);
    }

    static class BundleResourceBundleControl
    extends ResourceBundle.Control {
        private final boolean useFallback;
        private final Bundle osgiBundle;

        public BundleResourceBundleControl(Bundle osgiBundle, boolean useFallback) {
            this.osgiBundle = osgiBundle;
            this.useFallback = useFallback;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            URLConnection connection;
            String bundleName = this.toBundleName(baseName, locale);
            PropertyResourceBundle bundle = null;
            if (!format.equals("java.properties")) throw new IllegalArgumentException("unknown format: " + format);
            String resourceName = this.toResourceName(bundleName, "properties");
            URL url = this.osgiBundle.getEntry(resourceName);
            if (url == null || (connection = url.openConnection()) == null) return bundle;
            connection.setUseCaches(false);
            Throwable throwable = null;
            Object var12_13 = null;
            try (InputStream stream = connection.getInputStream();){
                if (stream == null) return bundle;
                bundle = new PropertyResourceBundle(stream);
                return bundle;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return this.useFallback ? super.getFallbackLocale(baseName, locale) : null;
        }
    }
}

