/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.contexts;

import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDebugContextProvider
implements IDebugContextProvider {
    private final ListenerList<IDebugContextListener> fListeners = new ListenerList();
    private final IWorkbenchPart fPart;

    public AbstractDebugContextProvider(IWorkbenchPart part) {
        this.fPart = part;
    }

    @Override
    public void addDebugContextListener(IDebugContextListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    @Override
    public void removeDebugContextListener(IDebugContextListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void fire(final DebugContextEvent event) {
        Iterator iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            IDebugContextListener iDebugContextListener;
            final IDebugContextListener listener = iDebugContextListener = (IDebugContextListener)iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.debugContextChanged(event);
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
        }
    }
}

