/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EditFileHyperlink
implements IHyperlink {
    private final IFile file;
    private final IRegion region;

    protected EditFileHyperlink(IFile file, IRegion region) {
        this.file = file;
        this.region = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)Messages.MarkupHyperlinkDetector_openFileInEditor, (Object)this.file.getName());
    }

    public void open() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)this.file);
        }
        catch (PartInitException e) {
            WikiTextUiPlugin.getDefault().log(e);
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.MarkupHyperlinkDetector_unexpectedError, (String)NLS.bind((String)Messages.MarkupHyperlinkDetector_openException, (Object)this.file.getName(), (Object)e.getMessage()));
        }
    }
}

