/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.DefaultTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskCommentMapper {
    private IRepositoryPerson author;
    private String commentId;
    private Date creationDate;
    private Integer number;
    private String text;
    private String url;
    private Boolean isPrivate;

    public IRepositoryPerson getAuthor() {
        return this.author;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getText() {
        return this.text;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public void setAuthor(IRepositoryPerson author) {
        this.author = author;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public static TaskCommentMapper createFrom(TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setCommentId(mapper.getValue(taskAttribute));
        TaskAttribute child = taskAttribute.getMappedAttribute("task.common.comment.author");
        if (child != null) {
            IRepositoryPerson person = mapper.getRepositoryPerson(child);
            if (person.getName() == null && (child = taskAttribute.getMappedAttribute("task.common.comment.author.name")) != null) {
                person.setName(child.getValue());
            }
            comment.setAuthor(person);
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.comment.date")) != null) {
            comment.setCreationDate(mapper.getDateValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.comment.number")) != null) {
            comment.setNumber(mapper.getIntegerValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.comment.url")) != null) {
            comment.setUrl(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.comment.text")) != null) {
            comment.setText(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.comment.isprivate")) != null) {
            comment.setIsPrivate(mapper.getBooleanValue(child));
        }
        return comment;
    }

    public void applyTo(TaskAttribute taskAttribute) {
        TaskAttribute child;
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        taskAttribute.getMetaData().defaults().setType("comment");
        if (this.getCommentId() != null) {
            mapper.setValue(taskAttribute, this.getCommentId());
        }
        if (this.getAuthor() != null) {
            child = DefaultTaskSchema.getField("task.common.comment.author").createAttribute(taskAttribute);
            mapper.setRepositoryPerson(child, this.getAuthor());
        }
        if (this.getCreationDate() != null) {
            child = DefaultTaskSchema.getField("task.common.comment.date").createAttribute(taskAttribute);
            mapper.setDateValue(child, this.getCreationDate());
        }
        if (this.getNumber() != null) {
            child = DefaultTaskSchema.getField("task.common.comment.number").createAttribute(taskAttribute);
            mapper.setIntegerValue(child, this.getNumber());
        }
        if (this.getUrl() != null) {
            child = DefaultTaskSchema.getField("task.common.comment.url").createAttribute(taskAttribute);
            mapper.setValue(child, this.getUrl());
        }
        if (this.getText() != null) {
            child = DefaultTaskSchema.getField("task.common.comment.text").createAttribute(taskAttribute);
            mapper.setValue(child, this.getText());
            taskAttribute.putMetaDatum("task.meta.associated.attribute", child.getId());
        }
        if (this.getIsPrivate() != null) {
            child = DefaultTaskSchema.getField("task.common.comment.isprivate").createAttribute(taskAttribute);
            mapper.setBooleanValue(child, this.getIsPrivate());
        }
    }

    public void applyTo(ITaskComment taskComment) {
        Assert.isNotNull((Object)taskComment);
        if (this.getAuthor() != null) {
            taskComment.setAuthor(this.getAuthor());
        }
        if (this.getCreationDate() != null) {
            taskComment.setCreationDate(this.getCreationDate());
        }
        if (this.getNumber() != null) {
            taskComment.setNumber(this.getNumber());
        }
        if (this.getUrl() != null) {
            taskComment.setUrl(this.getUrl());
        }
        if (this.getText() != null) {
            taskComment.setText(this.getText());
        }
        if (this.getIsPrivate() != null) {
            taskComment.setIsPrivate(this.getIsPrivate());
        }
    }
}

