/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.rhino.Node;

class InlineCostEstimator {
    private static final String ESTIMATED_IDENTIFIER = "ab";
    static final int ESTIMATED_IDENTIFIER_COST = "ab".length();

    private InlineCostEstimator() {
    }

    static int getCost(Node root) {
        return InlineCostEstimator.getCost(root, Integer.MAX_VALUE);
    }

    static int getCost(Node root, int costThreshold) {
        CompiledSizeEstimator estimator = new CompiledSizeEstimator(costThreshold);
        estimator.add(root);
        return estimator.getCost();
    }

    private static class CompiledSizeEstimator
    extends CodeConsumer {
        private int maxCost;
        private int cost = 0;
        private char last = '\u0000';
        private boolean continueProcessing = true;

        CompiledSizeEstimator(int costThreshold) {
            this.maxCost = costThreshold;
        }

        void add(Node root) {
            CodeGenerator cg = CodeGenerator.forCostEstimation(this);
            cg.add(root);
        }

        int getCost() {
            return this.cost;
        }

        @Override
        boolean continueProcessing() {
            return this.continueProcessing;
        }

        @Override
        char getLastChar() {
            return this.last;
        }

        @Override
        void append(String str) {
            this.last = str.charAt(str.length() - 1);
            this.cost += str.length();
            if (this.maxCost <= this.cost) {
                this.continueProcessing = false;
            }
        }

        @Override
        void addIdentifier(String identifier) {
            this.add(InlineCostEstimator.ESTIMATED_IDENTIFIER);
        }

        @Override
        void addConstant(String newcode) {
            this.add("0");
        }
    }
}

