/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeVisitor;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ObjectLiteralSpi;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public interface IDataType
extends INodeElement {
    @Override
    public DataTypeSpi spi();

    public boolean isPrimitive();

    default public IDataType createArrayType(int dimension) {
        return this.containingModule().nodeElementFactory().createArrayDataType(this, dimension);
    }

    default public DataTypeFlavor flavor() {
        return this.spi().flavor();
    }

    default public Stream<IDataType> typeArguments() {
        return Stream.empty();
    }

    public boolean isAssignableFrom(IDataType var1);

    default public Stream<IDataType> childTypes() {
        return this.spi().childTypes().stream().map(DataTypeSpi::api);
    }

    public TreeVisitResult visit(IDataTypeVisitor var1);

    default public int arrayDimension() {
        return this.spi().arrayDimension();
    }

    default public Optional<IObjectLiteral> objectLiteral() {
        return this.spi().objectLiteral().map(ObjectLiteralSpi::api);
    }

    default public Optional<IConstantValue> constantValue() {
        return this.spi().constantValue();
    }

    public static enum DataTypeFlavor {
        Single,
        Array,
        Union,
        Intersection;

    }
}

