/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.scout.sdk.core.log.FormattingTuple;
import org.eclipse.scout.sdk.core.log.MessageFormatter;
import org.eclipse.scout.sdk.core.util.Strings;

public final class Ensure {
    private Ensure() {
    }

    public static void isTrue(boolean expression) {
        Ensure.isTrue(expression, "The validated expression is false", new Object[0]);
    }

    public static void isTrue(boolean expression, CharSequence msg, Object ... msgArgs) {
        if (!expression) {
            Ensure.fail(msg, msgArgs);
        }
    }

    public static void isFalse(boolean expression) {
        Ensure.isFalse(expression, "The validated expression is true", new Object[0]);
    }

    public static void isFalse(boolean expression, CharSequence msg, Object ... msgArgs) {
        Ensure.isTrue(!expression, msg, msgArgs);
    }

    public static Path isFile(Path candidate) {
        return Ensure.isFile(candidate, "'{}' is not a file.", candidate);
    }

    public static Path isFile(Path candidate, CharSequence msg, Object ... msgArgs) {
        if (candidate == null || !Files.isReadable(candidate) || !Files.isRegularFile(candidate, new LinkOption[0])) {
            Ensure.fail(msg, msgArgs);
        }
        return candidate;
    }

    public static Path isDirectory(Path candidate) {
        return Ensure.isDirectory(candidate, "'{}' is not a directory.", candidate);
    }

    public static Path isDirectory(Path candidate, CharSequence msg, Object ... msgArgs) {
        if (candidate == null || !Files.isReadable(candidate) || !Files.isDirectory(candidate, new LinkOption[0])) {
            Ensure.fail(msg, msgArgs);
        }
        return candidate;
    }

    public static <T> T notNull(T o) {
        return Ensure.notNull(o, "Object is null", new Object[0]);
    }

    public static <T> T notNull(T o, CharSequence msg, Object ... msgArgs) {
        if (o == null) {
            Ensure.fail(msg, msgArgs);
        }
        return o;
    }

    public static <T extends CharSequence> T notBlank(T in) {
        return Ensure.notBlank(in, "CharSequence is blank but expected to contain characters.", null);
    }

    public static <T extends CharSequence> T notBlank(T in, CharSequence msg, Object ... msgArgs) {
        if (Strings.isBlank(in)) {
            Ensure.fail(msg, msgArgs);
        }
        return in;
    }

    public static void same(Object a, Object b) {
        Ensure.same(a, b, "Values are not the same: [{}, {}].", a, b);
    }

    public static void same(Object a, Object b, CharSequence msg, Object ... msgArgs) {
        if (a != b) {
            Ensure.fail(msg, msgArgs);
        }
    }

    public static <T> T instanceOf(Object a, Class<T> type) {
        return Ensure.instanceOf(a, type, "Object of type {} is not instanceof {}.", Ensure.notNull(a).getClass(), type);
    }

    public static <T> T instanceOf(Object a, Class<T> type, CharSequence msg, Object ... msgArgs) {
        if (!Ensure.notNull(type).isAssignableFrom(Ensure.notNull(a).getClass())) {
            Ensure.fail(msg, msgArgs);
        }
        return type.cast(a);
    }

    public static void fail(CharSequence msg, Object ... msgArgs) {
        throw Ensure.newFail(msg, msgArgs);
    }

    public static IllegalArgumentException newFail(CharSequence msg, Object ... msgArgs) {
        FormattingTuple tuple = MessageFormatter.arrayFormat(msg, msgArgs);
        return new IllegalArgumentException(tuple.message(), tuple.firstThrowable().orElse(null));
    }

    public static <T> T failOnDuplicates(T a, T b) {
        throw Ensure.newFail("Unexpected duplicates found: '{}' and '{}'.", a, b);
    }
}

