/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.ejb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SessionType implements Enumerator
{
    SINGLETON_LITERAL(0, "Singleton", "Singleton"),
    STATEFUL_LITERAL(1, "Stateful", "Stateful"),
    STATELESS_LITERAL(2, "Stateless", "Stateless");

    public static final int SINGLETON = 0;
    public static final int STATEFUL = 1;
    public static final int STATELESS = 2;
    private static final SessionType[] VALUES_ARRAY;
    public static final List<SessionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SessionType[]{SINGLETON_LITERAL, STATEFUL_LITERAL, STATELESS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SessionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SessionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SessionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SessionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SessionType get(int value) {
        switch (value) {
            case 0: {
                return SINGLETON_LITERAL;
            }
            case 1: {
                return STATEFUL_LITERAL;
            }
            case 2: {
                return STATELESS_LITERAL;
            }
        }
        return null;
    }

    private SessionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

