/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.builder.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.java.generator.SimpleGenerators;
import org.eclipse.scout.sdk.core.java.model.api.AbstractMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.IArrayMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;

public class ArrayMetaValue
extends AbstractMetaValue
implements IArrayMetaValue {
    private final IMetaValue[] m_metaArray;

    public ArrayMetaValue(IMetaValue[] metaArray) {
        this.m_metaArray = ArrayMetaValue.withoutNullElements(metaArray);
    }

    @Override
    public MetaValueType type() {
        return MetaValueType.Array;
    }

    @Override
    public ISourceGenerator<IExpressionBuilder<?>> toWorkingCopy(IWorkingCopyTransformer transformer) {
        return SimpleGenerators.createArrayMetaValueGenerator(this, transformer);
    }

    @Override
    public Stream<IJavaElement> children() {
        return Arrays.stream(this.m_metaArray).flatMap(IMetaValue::children);
    }

    protected static IMetaValue[] withoutNullElements(IMetaValue[] original) {
        if (original == null) {
            return new IMetaValue[0];
        }
        int numNotNullElements = ArrayMetaValue.numNotNullElements(original);
        if (numNotNullElements == original.length) {
            return original;
        }
        IMetaValue[] filtered = new IMetaValue[numNotNullElements];
        int targetPos = 0;
        for (IMetaValue mv : original) {
            if (mv == null) continue;
            filtered[targetPos] = mv;
            ++targetPos;
        }
        return filtered;
    }

    private static int numNotNullElements(IMetaValue[] arr) {
        return (int)Arrays.stream(arr).filter(Objects::nonNull).count();
    }

    @Override
    public IMetaValue[] metaValueArray() {
        return this.m_metaArray;
    }

    @Override
    protected Object getInternalObject(Class<?> expectedType) {
        return this.m_metaArray;
    }

    @Override
    public <T> T as(Class<T> expectedType) {
        Object result;
        Class arrayElementType;
        int arraySize = this.m_metaArray.length;
        if (expectedType == Object.class) {
            arrayElementType = Object.class;
            result = new Object[arraySize];
        } else if (expectedType.isArray()) {
            arrayElementType = expectedType.getComponentType();
            result = Array.newInstance(arrayElementType, arraySize);
        } else {
            if (arraySize == 1) {
                return this.m_metaArray[0].as(expectedType);
            }
            throw new IllegalArgumentException("expected type must be an array type but was: " + String.valueOf(expectedType));
        }
        for (int i = 0; i < arraySize; ++i) {
            Array.set(result, i, this.m_metaArray[i].as(arrayElementType));
        }
        return (T)result;
    }

    public String toString() {
        int n = this.m_metaArray.length;
        char blockSeparator = n > 0 && (this.m_metaArray[0].type() == MetaValueType.Array || this.m_metaArray[0].type() == MetaValueType.Annotation) ? (char)'\n' : ' ';
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        buf.append(blockSeparator);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                IMetaValue element = this.m_metaArray[i];
                if (i > 0) {
                    buf.append(',');
                    buf.append(blockSeparator);
                }
                buf.append(element);
            }
        }
        buf.append(blockSeparator);
        buf.append('}');
        return buf.toString();
    }
}

