/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.builder;

import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.SourceBuilderWrapper;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContext;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class JavaSourceBuilder
extends SourceBuilderWrapper<JavaSourceBuilder>
implements IJavaSourceBuilder<JavaSourceBuilder> {
    private final IJavaBuilderContext m_context;

    protected JavaSourceBuilder(ISourceBuilder<?> inner, IJavaEnvironment env) {
        super(inner);
        IBuilderContext context = inner.context();
        this.m_context = context instanceof IJavaBuilderContext ? (IJavaBuilderContext)context : new JavaBuilderContext(context, env);
    }

    public static IJavaSourceBuilder<?> create(ISourceBuilder<?> inner, IJavaEnvironment env) {
        return new JavaSourceBuilder(inner, env);
    }

    public static IJavaSourceBuilder<?> create(ISourceBuilder<?> inner) {
        return JavaSourceBuilder.create(inner, null);
    }

    @Override
    public IJavaBuilderContext context() {
        return this.m_context;
    }

    @Override
    public JavaSourceBuilder ref(IType t) {
        return this.ref(t.reference());
    }

    @Override
    public JavaSourceBuilder ref(CharSequence ref) {
        return (JavaSourceBuilder)this.append(this.context().validator().useReference(ref));
    }

    @Override
    public JavaSourceBuilder blockStart() {
        return (JavaSourceBuilder)this.append('{');
    }

    @Override
    public JavaSourceBuilder blockEnd() {
        return (JavaSourceBuilder)this.append('}');
    }

    @Override
    public JavaSourceBuilder at() {
        return (JavaSourceBuilder)this.append('@');
    }

    @Override
    public JavaSourceBuilder references(Stream<? extends CharSequence> references, CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        if (references == null) {
            return (JavaSourceBuilder)this.thisInstance();
        }
        Stream<ISourceGenerator> referenceBuilders = references.map(s -> builder -> builder.ref((CharSequence)s)).map(builder -> builder.generalize(JavaSourceBuilder::create));
        return (JavaSourceBuilder)this.append(referenceBuilders, prefix, delimiter, suffix);
    }

    @Override
    public <API extends IApiSpecification> JavaSourceBuilder refClassFrom(Class<API> apiClass, Function<API, ITypeNameSupplier> sourceProvider) {
        return this.refClassFunc(new ApiFunction<API, ITypeNameSupplier>(apiClass, sourceProvider));
    }

    @Override
    public JavaSourceBuilder refClassFunc(Function<IJavaBuilderContext, ITypeNameSupplier> func) {
        ITypeNameSupplier cns = (ITypeNameSupplier)Ensure.notNull((Object)func.apply(this.context()), (CharSequence)"{} function '{}' did not return a valid value.", (Object[])new Object[]{IJavaBuilderContext.class.getSimpleName(), func});
        String fqn = (String)Ensure.notBlank((CharSequence)cns.fqn(), (CharSequence)"{} function '{}' did not return a valid value.", (Object[])new Object[]{IJavaBuilderContext.class.getSimpleName(), func});
        return this.ref(fqn);
    }

    @Override
    public <API extends IApiSpecification> JavaSourceBuilder refFrom(Class<API> apiClass, Function<API, ? extends CharSequence> refProvider) {
        return this.refFunc(new ApiFunction<API, CharSequence>(apiClass, refProvider));
    }

    @Override
    public JavaSourceBuilder refFunc(Function<IJavaBuilderContext, ? extends CharSequence> func) {
        CharSequence ref = Ensure.notBlank((CharSequence)func.apply(this.context()), (CharSequence)"{} function '{}' did not return a valid value.", (Object[])new Object[]{IJavaBuilderContext.class.getSimpleName(), func});
        return this.ref(ref);
    }

    @Override
    public <API extends IApiSpecification> JavaSourceBuilder appendFrom(Class<API> apiClass, Function<API, ? extends CharSequence> sourceProvider) {
        return this.appendFunc(new ApiFunction<API, CharSequence>(apiClass, sourceProvider));
    }

    @Override
    public JavaSourceBuilder appendFunc(Function<IJavaBuilderContext, ? extends CharSequence> sourceProvider) {
        CharSequence src = (CharSequence)Ensure.notNull((Object)sourceProvider.apply(this.context()), (CharSequence)"{} function '{}' did not return a valid value.", (Object[])new Object[]{IJavaBuilderContext.class.getSimpleName(), sourceProvider});
        return (JavaSourceBuilder)this.append(src);
    }

    @Override
    public JavaSourceBuilder referencesFrom(Stream<Function<IJavaBuilderContext, ? extends CharSequence>> references, CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        if (references == null) {
            return (JavaSourceBuilder)this.thisInstance();
        }
        return this.references(references.map(af -> (CharSequence)af.apply(this.context())).filter(Strings::hasText), prefix, delimiter, suffix);
    }
}

