/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.java.generator.method;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.MethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.s.dataobject.DataObjectNode;
import org.eclipse.scout.sdk.core.s.java.apidef.IScout22DoApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.builder.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.IScoutMethodGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.ScoutMethodGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public final class ScoutDoMethodGenerator
extends ScoutMethodGenerator<ScoutDoMethodGenerator, IScoutMethodBodyBuilder<?>> {
    public static final String CONVENIENCE_METHOD_MARKER_START = "/* ******************";

    private ScoutDoMethodGenerator() {
    }

    public static IScoutMethodGenerator<?, ?> createDoNode(String name, DataObjectNode.DataObjectNodeKind kind, String dataType) {
        return ScoutDoMethodGenerator.createDoNodeFunc(name, kind, (Function<IJavaBuilderContext, String>)JavaBuilderContextFunction.orNull((Object)dataType));
    }

    public static <API extends IApiSpecification> IScoutMethodGenerator<?, ?> createDoNodeFrom(String name, DataObjectNode.DataObjectNodeKind kind, Class<API> api, Function<API, String> dataType) {
        return ScoutDoMethodGenerator.createDoNodeFunc(name, kind, (Function<IJavaBuilderContext, String>)new ApiFunction(api, dataType));
    }

    public static IScoutMethodGenerator<?, ?> createDoNodeFunc(String name, DataObjectNode.DataObjectNodeKind kind, Function<IJavaBuilderContext, String> dataType) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutDoMethodGenerator.create().asPublic()).withReturnTypeFunc(ctx -> ScoutDoMethodGenerator.buildDoNodeType(kind, dataType, ctx))).withElementName(name)).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).append(ScoutDoMethodGenerator.buildDoNodeMethod(kind, b.context()))).parenthesisOpen()).stringLiteral(name)).parenthesisClose()).semicolon()).nl());
    }

    static String buildDoNodeMethod(DataObjectNode.DataObjectNodeKind kind, IJavaBuilderContext ctx) {
        IScoutApi scoutApi = (IScoutApi)ctx.requireApi(IScoutApi.class);
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case DataObjectNode.DataObjectNodeKind.VALUE -> scoutApi.DoEntity().doValueMethodName();
            case DataObjectNode.DataObjectNodeKind.LIST -> scoutApi.DoEntity().doListMethodName();
            case DataObjectNode.DataObjectNodeKind.COLLECTION -> ((IScout22DoApi)scoutApi.requireApi(IScout22DoApi.class)).DoEntity().doCollectionMethodName();
            case DataObjectNode.DataObjectNodeKind.SET -> ((IScout22DoApi)scoutApi.requireApi(IScout22DoApi.class)).DoEntity().doSetMethodName();
        };
    }

    static String buildDoNodeType(DataObjectNode.DataObjectNodeKind kind, Function<IJavaBuilderContext, String> dataType, IJavaBuilderContext ctx) {
        IScoutApi scoutApi = (IScoutApi)ctx.requireApi(IScoutApi.class);
        Object type = switch (kind) {
            default -> throw new MatchException(null, null);
            case DataObjectNode.DataObjectNodeKind.VALUE -> scoutApi.DoValue();
            case DataObjectNode.DataObjectNodeKind.LIST -> scoutApi.DoList();
            case DataObjectNode.DataObjectNodeKind.COLLECTION -> ((IScout22DoApi)scoutApi.requireApi(IScout22DoApi.class)).DoCollection();
            case DataObjectNode.DataObjectNodeKind.SET -> ((IScout22DoApi)scoutApi.requireApi(IScout22DoApi.class)).DoSet();
        };
        return type.fqn() + "<" + dataType.apply(ctx) + ">";
    }

    public static IScoutMethodGenerator<?, ?> createDoValueSetter(String name, String dataTypeReference, IType owner) {
        return (IScoutMethodGenerator)ScoutDoMethodGenerator.createDoValueSetter(name, dataTypeReference, ScoutDoMethodGenerator.buildReturnTypeReferenceFor(owner)).withOverrideIfNecessary(true, owner);
    }

    public static IScoutMethodGenerator<?, ?> createDoValueSetter(String name, String dataTypeReference, String returnTypeReference) {
        return ScoutDoMethodGenerator.createDoValueSetterFrom(name, null, a -> dataTypeReference, returnTypeReference);
    }

    public static <API extends IApiSpecification> IScoutMethodGenerator<?, ?> createDoValueSetterFrom(String name, Class<API> api, Function<API, String> dataTypeFunc, String returnTypeReference) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutDoMethodGenerator.create().asPublic()).withReturnType(returnTypeReference)).withElementName("with" + String.valueOf(Strings.capitalize((CharSequence)name)))).withParameter(((IMethodParameterGenerator)MethodParameterGenerator.create().withElementName(name)).withDataTypeFrom(api, dataTypeFunc))).withAnnotation(ScoutAnnotationGenerator.createDoConvenienceMethodsGenerated())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.appendDoNodeSet(name, name).nl()).returnClause()).appendThis()).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createDoCollectionSetterCollection(String name, CharSequence dataTypeReference, IType owner) {
        String methodName = "with" + String.valueOf(Strings.capitalize((CharSequence)name));
        String paramDataType = ScoutDoMethodGenerator.computeDoNodeCollectionSetterParameterDataType(owner, methodName, dataTypeReference);
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutDoMethodGenerator.create().asPublic()).withReturnType(ScoutDoMethodGenerator.buildReturnTypeReferenceFor(owner))).withElementName(methodName)).withParameter(((IMethodParameterGenerator)MethodParameterGenerator.create().withElementName(name)).withDataType(paramDataType))).withAnnotation(ScoutAnnotationGenerator.createDoConvenienceMethodsGenerated())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.appendDoCollectionUpdateAll(name, name).nl()).returnClause()).appendThis()).semicolon())).withOverrideIfNecessary(true, owner);
    }

    static String computeDoNodeCollectionSetterParameterDataType(IType owner, CharSequence methodName, CharSequence dataTypeReference) {
        String methodId = JavaTypes.createMethodIdentifier((CharSequence)methodName, Collections.singleton(Collection.class.getName()));
        Optional parentMethod = owner.superTypes().withSelf(false).stream().flatMap(st -> st.methods().withMethodIdentifier(methodId).stream()).findAny();
        Boolean needsExtends = parentMethod.map(IMethod::parameters).flatMap(AbstractQuery::first).map(IMethodParameter::dataType).map(IType::reference).map(ref -> ref.contains("extends")).orElse(true);
        StringBuilder collectionDataTypeRef = new StringBuilder(Collection.class.getName()).append('<');
        if (needsExtends.booleanValue()) {
            collectionDataTypeRef.append('?').append(' ').append("extends").append(' ').append(dataTypeReference);
        } else {
            collectionDataTypeRef.append(dataTypeReference);
        }
        collectionDataTypeRef.append('>');
        return collectionDataTypeRef.toString();
    }

    public static IScoutMethodGenerator<?, ?> createDoCollectionSetterVarargs(String name, String dataTypeReference, IType owner) {
        IScoutMethodGenerator<?, ?> generator = ScoutDoMethodGenerator.createDoCollectionSetterCollection(name, dataTypeReference, owner);
        ((IMethodParameterGenerator)generator.parameters().findAny().orElseThrow()).withDataType(dataTypeReference).asVarargs();
        return generator;
    }

    public static IScoutMethodGenerator<?, ?> createDoNodeGetter(CharSequence name, String returnTypeReference, IType owner) {
        return (IScoutMethodGenerator)ScoutDoMethodGenerator.createDoNodeGetter(name, returnTypeReference).withOverrideIfNecessary(true, owner);
    }

    public static IScoutMethodGenerator<?, ?> createDoNodeGetter(CharSequence name, String returnTypeReference) {
        return ScoutDoMethodGenerator.createDoNodeGetterFrom(name, null, a -> returnTypeReference);
    }

    public static <API extends IApiSpecification> IScoutMethodGenerator<?, ?> createDoNodeGetterFrom(CharSequence name, Class<API> api, Function<API, String> returnTypeFunction) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutDoMethodGenerator.create().asPublic()).withReturnTypeFrom(api, returnTypeFunction)).withElementNameFunc(c -> ScoutDoMethodGenerator.computeDoNodeGetterName(c, name, ScoutDoMethodGenerator.computeDoNodeGetterReturnType(c, api, returnTypeFunction)))).withAnnotation(ScoutAnnotationGenerator.createDoConvenienceMethodsGenerated())).withBody(b -> ScoutDoMethodGenerator.computeDoNodeGetterBody(name, ScoutDoMethodGenerator.computeDoNodeGetterReturnType(b.context(), api, returnTypeFunction), b));
    }

    static <API extends IApiSpecification> String computeDoNodeGetterReturnType(IJavaBuilderContext context, Class<API> returnTypeApi, Function<API, String> returnTypeFunction) {
        return (String)new ApiFunction(returnTypeApi, returnTypeFunction).apply(context);
    }

    static String computeDoNodeGetterName(IJavaBuilderContext c, CharSequence doNodeName, CharSequence doNodeType) {
        return ((IScoutApi)c.requireApi(IScoutApi.class)).IDoEntity().computeGetterPrefixFor(doNodeType) + String.valueOf(Strings.capitalize((CharSequence)doNodeName));
    }

    static void computeDoNodeGetterBody(CharSequence name, String returnTypeReference, IScoutMethodBodyBuilder<?> builder) {
        Optional scout22DoApi;
        if ("boolean".equals(returnTypeReference) && (scout22DoApi = builder.context().api(IScoutApi.class).flatMap(scoutApi -> scoutApi.api(IScout22DoApi.class))).isPresent()) {
            ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)builder.returnClause()).append(((IScout22DoApi)scout22DoApi.orElseThrow()).DoEntity().nvlMethodName())).parenthesisOpen()).appendFunc(c -> ScoutDoMethodGenerator.computeDoNodeGetterName(c, name, "java.lang.Boolean"))).parenthesisOpen()).parenthesisClose()).parenthesisClose()).semicolon();
            return;
        }
        ((IScoutMethodBodyBuilder)builder.returnClause()).appendDoNodeGet(name).semicolon();
    }

    static String buildReturnTypeReferenceFor(IType owner) {
        String ref = owner.reference();
        if (!owner.hasTypeParameters()) {
            return ref;
        }
        return owner.typeParameters().map(IJavaElement::elementName).collect(Collectors.joining(", ", ref + "<", ">"));
    }

    public static Stream<IScoutMethodGenerator<?, ?>> createConvenienceMethods(String name, DataObjectNode.DataObjectNodeKind kind, String dataTypeRef, boolean isInherited, ITypeGenerator<?> declaringType, IJavaBuilderContext context) {
        String declaringClassFqn = declaringType.fullyQualifiedName();
        IType hierarchyType = declaringType.getHierarchyType(context);
        return ScoutDoMethodGenerator.createConvenienceMethods(name, kind, dataTypeRef, isInherited, hierarchyType).peek(m -> {
            if (m.elementName(context).orElse("").startsWith("with")) {
                m.withReturnType(declaringClassFqn);
            }
        });
    }

    public static Stream<IScoutMethodGenerator<?, ?>> createConvenienceMethods(String name, DataObjectNode.DataObjectNodeKind kind, String dataTypeRef, boolean isInherited, IType declaringType) {
        if (kind == DataObjectNode.DataObjectNodeKind.VALUE) {
            return ScoutDoMethodGenerator.buildMethodGeneratorsForValue(name, dataTypeRef, isInherited, declaringType);
        }
        return ScoutDoMethodGenerator.buildMethodGeneratorsForCollection(name, kind, dataTypeRef, isInherited, declaringType);
    }

    static Stream<IScoutMethodGenerator<?, ?>> buildMethodGeneratorsForValue(String name, String dataTypeRef, boolean isInherited, IType owner) {
        IScoutMethodGenerator<?, ?> chainedSetter = ScoutDoMethodGenerator.createDoValueSetter(name, dataTypeRef, owner);
        if (isInherited) {
            return Stream.of(chainedSetter);
        }
        IScoutMethodGenerator<?, ?> valueGetter = ScoutDoMethodGenerator.createDoNodeGetter(name, dataTypeRef, owner);
        Stream<IScoutMethodGenerator<?, ?>> additionalGetters = ((IScoutApi)owner.javaEnvironment().requireApi(IScoutApi.class)).IDoEntity().getAdditionalDoNodeGetters(name, dataTypeRef, owner);
        Stream<IScoutMethodGenerator> allMissingGetters = Stream.concat(Stream.of(valueGetter), additionalGetters).filter(gen -> !ScoutDoMethodGenerator.implementedInSuperClass(gen, owner));
        return Stream.concat(Stream.of(chainedSetter), allMissingGetters);
    }

    static Stream<IScoutMethodGenerator<?, ?>> buildMethodGeneratorsForCollection(String name, DataObjectNode.DataObjectNodeKind kind, String dataTypeRef, boolean isInherited, IType owner) {
        IScoutMethodGenerator<?, ?> chainedSetterCollection = ScoutDoMethodGenerator.createDoCollectionSetterCollection(name, dataTypeRef, owner);
        IScoutMethodGenerator<?, ?> chainedSetterArray = ScoutDoMethodGenerator.createDoCollectionSetterVarargs(name, dataTypeRef, owner);
        if (isInherited) {
            return Stream.of(chainedSetterCollection, chainedSetterArray);
        }
        String getterCollectionFqn = switch (kind) {
            case DataObjectNode.DataObjectNodeKind.LIST -> List.class.getName();
            case DataObjectNode.DataObjectNodeKind.SET -> Set.class.getName();
            case DataObjectNode.DataObjectNodeKind.COLLECTION -> Collection.class.getName();
            default -> throw Ensure.newFail((CharSequence)"Unsupported DoNode kind of '{}'.", (Object[])new Object[]{name});
        };
        String collectionGetterReturnTypeReference = getterCollectionFqn + "<" + dataTypeRef + ">";
        IScoutMethodGenerator<?, ?> collectionGetter = ScoutDoMethodGenerator.createDoNodeGetter(name, collectionGetterReturnTypeReference, owner);
        if (ScoutDoMethodGenerator.implementedInSuperClass(collectionGetter, owner)) {
            return Stream.of(chainedSetterCollection, chainedSetterArray);
        }
        return Stream.of(chainedSetterCollection, chainedSetterArray, collectionGetter);
    }

    static boolean implementedInSuperClass(IMethodGenerator<?, ?> method, IType owner) {
        String methodId = method.identifier((IJavaBuilderContext)new JavaBuilderContext(owner.javaEnvironment()));
        return owner.superTypes().withSelf(false).stream().flatMap(t -> t.methods().withMethodIdentifier(methodId).stream()).anyMatch(m -> !Flags.isAbstract((int)m.flags()) || Flags.isDefaultMethod((int)m.flags()));
    }

    public static String convenienceMethodsMarkerComment(String nl) {
        return nl + "/* **************************************************************************" + nl + "   * GENERATED CONVENIENCE METHODS" + nl + "   * *************************************************************************/" + nl;
    }
}

