/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.java.init.JavaInit;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Comment;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.Initializer;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaParameterKind;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.Statement;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.ArrayTypeImpl;
import org.eclipse.jem.java.internal.impl.BlockImpl;
import org.eclipse.jem.java.internal.impl.CommentImpl;
import org.eclipse.jem.java.internal.impl.FieldImpl;
import org.eclipse.jem.java.internal.impl.InitializerImpl;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jem.java.internal.impl.JavaDataTypeImpl;
import org.eclipse.jem.java.internal.impl.JavaPackageImpl;
import org.eclipse.jem.java.internal.impl.JavaParameterImpl;
import org.eclipse.jem.java.internal.impl.MethodImpl;
import org.eclipse.jem.java.internal.impl.StatementImpl;
import org.eclipse.jem.java.util.JavaContext;

public class JavaRefFactoryImpl
extends EFactoryImpl
implements JavaRefFactory {
    private static final char GENERIC_ID_SEPARATOR = '!';
    private static final char GENERIC_SEPARATOR = '.';
    private static final char GENERIC_ID_END = '}';
    private static final char GENERIC_END = '>';
    private static final char GENERIC_ID_START = '{';
    private static final char GENERIC_START = '<';

    public static JavaRefFactory init() {
        try {
            JavaRefFactory theJavaRefFactory = (JavaRefFactory)EPackage.Registry.INSTANCE.getEFactory("java.xmi");
            if (theJavaRefFactory != null) {
                return theJavaRefFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JavaRefFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createJavaClass();
            }
            case 1: {
                return this.createInitializer();
            }
            case 2: {
                return this.createJavaParameter();
            }
            case 3: {
                return this.createMethod();
            }
            case 4: {
                return this.createField();
            }
            case 5: {
                return this.createBlock();
            }
            case 6: {
                return this.createComment();
            }
            case 7: {
                return this.createStatement();
            }
            case 8: {
                return this.createJavaPackage();
            }
            case 9: {
                return this.createJavaDataType();
            }
            case 10: {
                return this.createArrayType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createTypeKindFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createJavaVisibilityKindFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createJavaParameterKindFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createJTypeJavaHelpersFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createJTypeListFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertTypeKindToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertJavaVisibilityKindToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertJavaParameterKindToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertJTypeJavaHelpersToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertJTypeListToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ArrayType createArrayType(JavaHelpers componentType) {
        ArrayType at = this.createArrayType();
        String computedName = String.valueOf(componentType.getQualifiedName()) + "[]";
        at.setName(computedName);
        return at;
    }

    @Override
    public ArrayType createArrayType(JavaHelpers finalComponentType, int dimensions) {
        ArrayType at = this.createArrayType();
        String computedName = finalComponentType.getQualifiedName();
        int i = 0;
        while (i < dimensions) {
            computedName = String.valueOf(computedName) + "[]";
            ++i;
        }
        at.setName(computedName);
        return at;
    }

    public static ResourceSet createJavaContext() {
        return JavaContext.createJavaContext();
    }

    public static Class getReflectionAdapterFactoryClass() {
        return JavaContext.getReflectionAdapterFactoryClass();
    }

    public static void setReflectionAdapterFactoryClass(Class javaReflectionFactoryClass) {
        JavaContext.setReflectionAdapterFactoryClass(javaReflectionFactoryClass);
    }

    @Override
    public Method createMethod() {
        MethodImpl method = new MethodImpl();
        return method;
    }

    @Override
    public JavaClass createJavaClass() {
        JavaClassImpl javaClass = new JavaClassImpl();
        return javaClass;
    }

    @Override
    public Field createField() {
        FieldImpl field = new FieldImpl();
        return field;
    }

    @Override
    public Block createBlock() {
        BlockImpl block = new BlockImpl();
        return block;
    }

    @Override
    public Comment createComment() {
        CommentImpl comment = new CommentImpl();
        return comment;
    }

    @Override
    public Statement createStatement() {
        StatementImpl statement = new StatementImpl();
        return statement;
    }

    @Override
    public Initializer createInitializer() {
        InitializerImpl initializer = new InitializerImpl();
        return initializer;
    }

    @Override
    public JavaParameter createJavaParameter() {
        JavaParameterImpl javaParameter = new JavaParameterImpl();
        return javaParameter;
    }

    @Override
    public ArrayType createArrayType() {
        ArrayTypeImpl arrayType = new ArrayTypeImpl();
        return arrayType;
    }

    public TypeKind createTypeKindFromString(EDataType eDataType, String initialValue) {
        TypeKind result = TypeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTypeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JavaVisibilityKind createJavaVisibilityKindFromString(EDataType eDataType, String initialValue) {
        JavaVisibilityKind result = JavaVisibilityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertJavaVisibilityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JavaParameterKind createJavaParameterKindFromString(EDataType eDataType, String initialValue) {
        JavaParameterKind result = JavaParameterKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertJavaParameterKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JavaHelpers createJTypeJavaHelpersFromString(EDataType eDataType, String initialValue) {
        return (JavaHelpers)super.createFromString(eDataType, initialValue);
    }

    public String convertJTypeJavaHelpersToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public List createJTypeListFromString(EDataType eDataType, String initialValue) {
        return (List)super.createFromString(eDataType, initialValue);
    }

    public String convertJTypeListToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public JavaDataType createJavaDataType() {
        JavaDataTypeImpl javaDataType = new JavaDataTypeImpl();
        return javaDataType;
    }

    @Override
    public JavaPackage createJavaPackage() {
        JavaPackageImpl javaPackage = new JavaPackageImpl();
        return javaPackage;
    }

    @Override
    public JavaRefPackage getJavaRefPackage() {
        return (JavaRefPackage)this.getEPackage();
    }

    public static JavaRefPackage getPackage() {
        return JavaRefPackage.eINSTANCE;
    }

    public static JavaRefFactory getActiveFactory() {
        return JavaRefFactory.eINSTANCE;
    }

    @Override
    public JavaClass createClassRef(String targetName) {
        JavaClass ref = this.createJavaClass();
        ((InternalEObject)ref).eSetProxyURI(this.createTypeURI(targetName));
        return ref;
    }

    @Override
    public JavaHelpers reflectType(String aQualifiedName, EObject relatedObject) {
        ResourceSet rs;
        Resource r = relatedObject.eResource();
        if (r != null && (rs = r.getResourceSet()) != null) {
            return this.reflectType(aQualifiedName, rs);
        }
        return null;
    }

    @Override
    public JavaHelpers reflectType(String aQualifiedName, ResourceSet set) {
        if (aQualifiedName != null) {
            int index = aQualifiedName.lastIndexOf(".");
            if (index > 0) {
                return this.reflectType(aQualifiedName.substring(0, index), aQualifiedName.substring(index + 1, aQualifiedName.length()), set);
            }
            return this.reflectType("", aQualifiedName, set);
        }
        return null;
    }

    @Override
    public JavaHelpers reflectType(String aPackageName, String aTypeName, ResourceSet set) {
        if (aTypeName != null && aPackageName != null) {
            JavaInit.init();
            return (JavaHelpers)set.getEObject(this.createTypeURI(aPackageName, aTypeName), true);
        }
        return null;
    }

    @Override
    public JavaPackage reflectPackage(String packageName, ResourceSet set) {
        if (packageName != null) {
            JavaInit.init();
            return (JavaPackage)set.getEObject(this.createPackageURI(packageName), true);
        }
        return null;
    }

    @Override
    public URI createTypeURI(String aQualifiedName) {
        int pkgNdx;
        int genNdx = aQualifiedName.indexOf(60);
        int n = pkgNdx = genNdx == -1 ? aQualifiedName.lastIndexOf(46) : aQualifiedName.lastIndexOf(46, genNdx);
        if (pkgNdx > -1) {
            return this.createTypeURI(aQualifiedName.substring(0, pkgNdx), genNdx == -1 ? aQualifiedName.substring(pkgNdx + 1) : aQualifiedName.substring(pkgNdx + 1, genNdx));
        }
        return this.createTypeURI(null, aQualifiedName);
    }

    @Override
    public URI createTypeURI(String packageName, String typeName) {
        String[] pkgname = null;
        if (packageName != null && packageName.length() > 0) {
            pkgname = new String[]{packageName};
        }
        return URI.createHierarchicalURI((String)"java", null, null, pkgname, null, (String)this.createTypeName(typeName));
    }

    public String createTypeName(String typeName) {
        int genStart = typeName.indexOf(60);
        if (genStart > -1) {
            char[] chName = new char[typeName.length()];
            typeName.getChars(0, chName.length, chName, 0);
            int i = 0;
            while (i < chName.length) {
                switch (chName[i]) {
                    case '<': {
                        chName[i] = 123;
                        break;
                    }
                    case '>': {
                        chName[i] = 125;
                        break;
                    }
                    case '.': {
                        chName[i] = 33;
                        break;
                    }
                }
                ++i;
            }
            typeName = new String(chName);
        }
        return typeName;
    }

    @Override
    public String getTypeName(URI typeURI) {
        if (this.isTypeURI(typeURI)) {
            return this.primGetTypeName(typeURI.fragment());
        }
        throw new IllegalArgumentException(typeURI.toString());
    }

    public String primGetTypeName(String typeName) {
        int genStart = typeName.indexOf(123);
        if (genStart > -1) {
            char[] chName = new char[typeName.length()];
            typeName.getChars(0, chName.length, chName, 0);
            int i = 0;
            while (i < chName.length) {
                switch (chName[i]) {
                    case '{': {
                        chName[i] = 60;
                        break;
                    }
                    case '}': {
                        chName[i] = 62;
                        break;
                    }
                    case '!': {
                        chName[i] = 46;
                        break;
                    }
                }
                ++i;
            }
            typeName = new String(chName);
        }
        return typeName;
    }

    @Override
    public String getPackageName(URI javaURI) {
        if (this.isTypeURI(javaURI) || this.isPackageURI(javaURI)) {
            if (javaURI.segmentCount() == 1) {
                return javaURI.segment(0);
            }
            if (javaURI.segmentCount() == 0) {
                return "";
            }
            throw new IllegalArgumentException(javaURI.toString());
        }
        throw new IllegalArgumentException(javaURI.toString());
    }

    @Override
    public String getFullTypeName(URI typeURI) {
        String pkgName = this.getPackageName(typeURI);
        if (!this.isTypeURI(typeURI)) {
            throw new IllegalArgumentException(typeURI.toString());
        }
        if (pkgName.length() > 0) {
            return String.valueOf(pkgName) + '.' + this.getTypeName(typeURI);
        }
        return typeURI.fragment();
    }

    @Override
    public URI createPackageURI(String packageName) {
        String[] pkgname = null;
        if (packageName != null && packageName.length() > 0) {
            pkgname = new String[]{packageName};
        }
        return URI.createHierarchicalURI((String)"java", null, null, pkgname, null, (String)"*package");
    }

    @Override
    public boolean isJavaURI(URI uri) {
        return "java".equals(uri.scheme());
    }

    @Override
    public boolean isTypeURI(URI uri) {
        if (this.isJavaURI(uri)) {
            String frag = uri.fragment();
            if (frag != null && !"*package".equals(frag)) {
                int delimNdx = frag.indexOf(46);
                if (delimNdx != -1) {
                    return false;
                }
                delimNdx = frag.indexOf(47);
                return delimNdx == -1;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isPackageURI(URI uri) {
        return this.isJavaURI(uri) && "*package".equals(uri.fragment());
    }
}

