/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.wsfinder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.ws.internal.wsfinder.IWebServiceLocator;
import org.eclipse.wst.ws.internal.wsfinder.WebServiceCategory;
import org.eclipse.wst.ws.internal.wsfinder.WebServiceLocatorRegistry;

public class WebServiceFinder {
    private static WebServiceFinder instance = null;
    private static final String ELEMENT_LOCATOR = "webServiceLocator";
    private static final String ELEMENT_CATEGORY = "webServiceLocatorCategory";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_CATEGORY = "category";

    private WebServiceFinder() {
    }

    public static WebServiceFinder instance() {
        if (instance == null) {
            instance = new WebServiceFinder();
        }
        return instance;
    }

    public Iterator getWebServices(IProgressMonitor monitor) {
        return this.getWebServicesByCategoryId(null, monitor);
    }

    public Iterator getWebServices(IProject[] projects, IProgressMonitor monitor) {
        return this.getWebServicesByCategoryId(null, projects, monitor);
    }

    public Iterator getWebServicesByCategory(WebServiceCategory category, IProgressMonitor monitor) {
        return this.getWebServicesByCategoryId(category == null ? null : category.getId(), monitor);
    }

    public Iterator getWebServicesByCategory(WebServiceCategory category, IProject[] projects, IProgressMonitor monitor) {
        return this.getWebServicesByCategoryId(category == null ? null : category.getId(), projects, monitor);
    }

    public Iterator getWebServicesByCategoryId(String categoryId, IProgressMonitor monitor) {
        return this.getWebServicesByCategoryId(categoryId, null, monitor);
    }

    public Iterator getWebServicesByCategoryId(String categoryId, IProject[] projects, IProgressMonitor monitor) {
        LinkedList webServices = new LinkedList();
        WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
        IConfigurationElement[] regElements = wslr.getConfigElements();
        int i = 0;
        while (i < regElements.length) {
            if (ELEMENT_LOCATOR.equals(regElements[i].getName())) {
                try {
                    Object obj;
                    if ((categoryId == null || categoryId.equals(regElements[i].getAttributeAsIs(ATTRIBUTE_CATEGORY))) && (obj = regElements[i].createExecutableExtension(ATTRIBUTE_CLASS)) instanceof IWebServiceLocator) {
                        List wsList;
                        IWebServiceLocator wsl = (IWebServiceLocator)obj;
                        List list = wsList = projects == null ? wsl.getWebServices(monitor) : wsl.getWebServices(projects, monitor);
                        if (wsList != null) {
                            webServices.addAll(wsList);
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return webServices.iterator();
    }

    public Iterator getWebServiceClients(IProgressMonitor monitor) {
        return this.getWebServiceClientsByCategoryId(null, monitor);
    }

    public Iterator getWebServiceClients(IProject[] projects, IProgressMonitor monitor) {
        return this.getWebServiceClientsByCategoryId(null, projects, monitor);
    }

    public Iterator getWebServiceClientsByCategory(WebServiceCategory category, IProgressMonitor monitor) {
        return this.getWebServiceClientsByCategoryId(category == null ? null : category.getId(), monitor);
    }

    public Iterator getWebServiceClientsByCategory(WebServiceCategory category, IProject[] projects, IProgressMonitor monitor) {
        return this.getWebServiceClientsByCategoryId(category == null ? null : category.getId(), projects, monitor);
    }

    public Iterator getWebServiceClientsByCategoryId(String categoryId, IProgressMonitor monitor) {
        return this.getWebServiceClientsByCategoryId(categoryId, null, monitor);
    }

    public Iterator getWebServiceClientsByCategoryId(String categoryId, IProject[] projects, IProgressMonitor monitor) {
        LinkedList webServiceClients = new LinkedList();
        WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
        IConfigurationElement[] regElements = wslr.getConfigElements();
        int i = 0;
        while (i < regElements.length) {
            if (ELEMENT_LOCATOR.equals(regElements[i].getName())) {
                try {
                    Object obj;
                    if ((categoryId == null || categoryId.equals(regElements[i].getAttributeAsIs(ATTRIBUTE_CATEGORY))) && (obj = regElements[i].createExecutableExtension(ATTRIBUTE_CLASS)) instanceof IWebServiceLocator) {
                        List wsList;
                        IWebServiceLocator wsl = (IWebServiceLocator)obj;
                        List list = wsList = projects == null ? wsl.getWebServiceClients(monitor) : wsl.getWebServiceClients(projects, monitor);
                        if (wsList != null) {
                            webServiceClients.addAll(wsList);
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return webServiceClients.iterator();
    }

    public WebServiceCategory[] getWebServiceCategories() {
        LinkedList<WebServiceCategory> categories = new LinkedList<WebServiceCategory>();
        WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
        IConfigurationElement[] regElements = wslr.getConfigElements();
        int i = 0;
        while (i < regElements.length) {
            if (ELEMENT_CATEGORY.equals(regElements[i].getName())) {
                categories.add(new WebServiceCategory(regElements[i]));
            }
            ++i;
        }
        return categories.toArray(new WebServiceCategory[0]);
    }

    public String[] getWebServiceCategoryIds() {
        LinkedList<String> categories = new LinkedList<String>();
        WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
        IConfigurationElement[] regElements = wslr.getConfigElements();
        int i = 0;
        while (i < regElements.length) {
            String id;
            if (ELEMENT_CATEGORY.equals(regElements[i].getName()) && (id = regElements[i].getAttributeAsIs(ATTRIBUTE_ID)) != null) {
                categories.add(id);
            }
            ++i;
        }
        return categories.toArray(new String[0]);
    }

    public WebServiceCategory getWebServiceCategoryById(String categoryId) {
        WebServiceCategory category = null;
        if (categoryId != null) {
            WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
            IConfigurationElement[] regElements = wslr.getConfigElements();
            int i = 0;
            while (i < regElements.length) {
                String id;
                if (ELEMENT_CATEGORY.equals(regElements[i].getName()) && categoryId.equals(id = regElements[i].getAttributeAsIs(ATTRIBUTE_ID))) {
                    return new WebServiceCategory(regElements[i]);
                }
                ++i;
            }
        }
        return category;
    }
}

