/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;
import org.eclipse.jgit.lib.Repository;

public class ResourceRefreshHandler
implements WorkingTreeModifiedListener {
    public void onWorkingTreeModified(WorkingTreeModifiedEvent event) {
        if (event.isEmpty()) {
            return;
        }
        Repository repo = event.getRepository();
        if (repo == null || repo.isBare()) {
            return;
        }
        Repository cached = RepositoryCache.INSTANCE.getRepository(repo.getDirectory().getAbsoluteFile());
        if (cached == null) {
            return;
        }
        if (GitTraceLocation.REFRESH.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REFRESH.getLocation(), "Triggered refresh for repo: " + String.valueOf(repo));
        }
        try {
            this.refreshRepository(event, event.getRepository().getWorkTree().getAbsoluteFile(), null);
        }
        catch (OperationCanceledException oe) {
            return;
        }
        catch (CoreException e) {
            Activator.error(CoreText.Activator_refreshFailed, e);
        }
    }

    public void refreshRepository(WorkingTreeModifiedEvent event, File workTree, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (event.isEmpty()) {
            progress.done();
            return;
        }
        Map<IPath, IProject> roots = this.getProjectLocations(workTree);
        if (roots.isEmpty()) {
            if (!event.getModified().isEmpty() || !event.getDeleted().isEmpty()) {
                HashSet<String> toRefresh = new HashSet<String>(event.getModified());
                toRefresh.addAll(event.getDeleted());
                this.refreshIndex(event.getRepository(), toRefresh);
            }
            progress.done();
            return;
        }
        Path wt = new Path(workTree.getPath());
        ArrayList<String> needRefresh = new ArrayList<String>();
        Map<IResource, Boolean> toRefresh = this.computeResources(event.getModified(), event.getDeleted(), (IPath)wt, roots, needRefresh, (IProgressMonitor)progress.newChild(1));
        if (toRefresh.isEmpty()) {
            if (!needRefresh.isEmpty()) {
                this.refreshIndex(event.getRepository(), needRefresh);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable operation = innerMonitor -> {
            SubMonitor innerProgress = SubMonitor.convert((IProgressMonitor)innerMonitor, (int)toRefresh.size());
            if (GitTraceLocation.REFRESH.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REFRESH.getLocation(), "Refreshing repository " + String.valueOf(workTree) + " " + toRefresh.size());
            }
            for (Map.Entry entry : toRefresh.entrySet()) {
                if (innerProgress.isCanceled()) break;
                ((IResource)entry.getKey()).refreshLocal((Boolean)entry.getValue() != false ? 2 : 1, (IProgressMonitor)innerProgress.newChild(1));
            }
            if (GitTraceLocation.REFRESH.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REFRESH.getLocation(), "Refreshed repository " + String.valueOf(workTree) + " " + toRefresh.size());
            }
        };
        workspace.run(operation, null, 1, (IProgressMonitor)progress.newChild(1));
        if (!needRefresh.isEmpty()) {
            this.refreshIndex(event.getRepository(), needRefresh);
        }
    }

    private void refreshIndex(Repository repository, Collection<String> toRefresh) {
        IndexDiffCacheEntry cache = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
        if (cache != null) {
            cache.refreshFiles(toRefresh);
        }
    }

    private Map<IPath, IProject> getProjectLocations(File workTree) {
        IProject[] projects = RuleUtil.getProjects(workTree);
        if (projects == null) {
            return Collections.emptyMap();
        }
        HashMap<IPath, IProject> result = new HashMap<IPath, IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IPath projectFilePath;
            IPath path;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (path = project.getLocation()) != null && (projectFilePath = path.append(".project")).toFile().exists()) {
                result.put(path, project);
            }
            ++n2;
        }
        return result;
    }

    private Map<IResource, Boolean> computeResources(Collection<String> modified, Collection<String> deleted, IPath workTree, Map<IPath, IProject> roots, Collection<String> needRefresh, IProgressMonitor monitor) {
        if (GitTraceLocation.REFRESH.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REFRESH.getLocation(), "Calculating refresh for repository " + String.valueOf(workTree) + " " + modified.size() + " " + deleted.size());
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(modified.size() + deleted.size()));
        HashSet fullRefreshes = new HashSet();
        HashMap handled = new HashMap();
        HashMap<IResource, Boolean> result = new HashMap<IResource, Boolean>();
        IWorkspaceRoot eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        Stream.concat(modified.stream(), deleted.stream()).forEach(path -> {
            IPath containerPath;
            boolean isFile;
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            IPath filePath = "/".equals(path) ? workTree : workTree.append(path);
            IProject project = (IProject)roots.get(filePath);
            if (project != null) {
                handled.put(filePath, null);
                result.put((IResource)project, Boolean.FALSE);
                progress.worked(1);
                return;
            }
            if (fullRefreshes.stream().anyMatch(full -> full.isPrefixOf(filePath))) {
                progress.worked(1);
                return;
            }
            IFile eclipseFile = eclipseWorkspace.getFileForLocation(filePath);
            if (eclipseFile != null && !eclipseFile.getProject().isAccessible()) {
                eclipseFile = null;
                URI uri = URIUtil.toURI((IPath)filePath);
                IFile[] files = eclipseWorkspace.findFilesForLocationURI(uri);
                if (files.length > 1) {
                    eclipseFile = Arrays.stream(files).filter(f -> f.getProject().isAccessible()).findFirst().orElse(null);
                }
            }
            if (eclipseFile == null || !roots.keySet().stream().anyMatch(root -> root.isPrefixOf(filePath))) {
                needRefresh.add((String)path);
                progress.worked(1);
                return;
            }
            if (path.endsWith("/")) {
                isFile = false;
                containerPath = filePath.removeTrailingSeparator();
            } else {
                isFile = true;
                containerPath = filePath.removeLastSegments(1);
            }
            if (!handled.containsKey(containerPath)) {
                if (!isFile && containerPath != null) {
                    IContainer container = ResourceRefreshHandler.getContainerForLocation(eclipseWorkspace, containerPath);
                    if (container != null) {
                        IFile file = (IFile)handled.get(containerPath);
                        handled.put(containerPath, null);
                        if (file != null) {
                            result.remove(file);
                        }
                        result.put((IResource)container, Boolean.FALSE);
                    }
                } else if (isFile) {
                    String lastPart = filePath.lastSegment();
                    while (containerPath != null && workTree.isPrefixOf(containerPath)) {
                        IContainer container = ResourceRefreshHandler.getContainerForLocation(eclipseWorkspace, containerPath);
                        if (container == null) {
                            lastPart = containerPath.lastSegment();
                            containerPath = containerPath.removeLastSegments(1);
                            isFile = false;
                            continue;
                        }
                        if (container.getType() == 8) {
                            containerPath = containerPath.append(lastPart);
                            fullRefreshes.add(containerPath);
                            handled.put(containerPath, null);
                        } else if (isFile) {
                            IFile file = container.getFile((IPath)new Path(lastPart));
                            handled.put(containerPath, file);
                            result.put((IResource)file, Boolean.FALSE);
                        } else {
                            container = container.getFolder((IPath)new Path(lastPart));
                            containerPath = containerPath.append(lastPart);
                            fullRefreshes.add(containerPath);
                            handled.put(containerPath, null);
                            result.put((IResource)container, Boolean.TRUE);
                        }
                        break;
                    }
                }
            } else {
                IFile file = (IFile)handled.get(containerPath);
                if (file != null) {
                    handled.put(containerPath, null);
                    result.remove(file);
                    result.put((IResource)file.getParent(), Boolean.FALSE);
                }
            }
            progress.worked(1);
        });
        if (GitTraceLocation.REFRESH.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REFRESH.getLocation(), "Calculated refresh for repository " + String.valueOf(workTree));
        }
        return result;
    }

    private static IContainer getContainerForLocation(IWorkspaceRoot root, @NonNull IPath location) {
        IContainer dir = root.getContainerForLocation(location);
        if (dir == null) {
            return null;
        }
        if (ResourceRefreshHandler.isValid((IResource)dir)) {
            return dir;
        }
        URI uri = URIUtil.toURI((IPath)location);
        IContainer[] containers = root.findContainersForLocationURI(uri);
        return Arrays.stream(containers).filter(ResourceRefreshHandler::isValid).findFirst().orElse(null);
    }

    private static boolean isValid(@NonNull IResource resource) {
        return resource.isAccessible() && resource.getProject().isAccessible() && !resource.isLinked(512);
    }
}

