/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.localstore.PrefixPool;
import org.eclipse.core.internal.resources.InternalWorkspaceJob;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class RefreshJob
extends InternalWorkspaceJob {
    public static final int MAX_RECURSION = 0x40000000;
    public static final int FAST_REFRESH_THRESHOLD = 1000;
    public static final int SLOW_REFRESH_THRESHOLD = 2000;
    public static final int BASE_REFRESH_DEPTH = 1000;
    public static final int DEPTH_INCREASE_STEP = 1000;
    public static final int UPDATE_DELAY = 200;
    private final List<IResource> fRequests = new ArrayList<IResource>(1);
    private PrefixPool pathPrefixHistory;
    private PrefixPool rootPathHistory;
    private final int fastRefreshThreshold;
    private final int slowRefreshThreshold;
    private final int baseRefreshDepth;
    private final int depthIncreaseStep;
    private final int updateDelay;
    private final int maxRecursionDeep;
    private final Workspace workspace;
    private volatile boolean disabled;

    public RefreshJob(Workspace workspace) {
        this(1000, 2000, 1000, 1000, 200, 0x40000000, workspace);
    }

    protected RefreshJob(int fastRefreshThreshold, int slowRefreshThreshold, int baseRefreshDepth, int depthIncreaseStep, int updateDelay, int maxRecursionDeep, Workspace workspace) {
        super(Messages.refresh_jobName, workspace);
        this.fastRefreshThreshold = fastRefreshThreshold;
        this.slowRefreshThreshold = slowRefreshThreshold;
        this.baseRefreshDepth = baseRefreshDepth;
        this.depthIncreaseStep = depthIncreaseStep;
        this.updateDelay = updateDelay;
        this.maxRecursionDeep = maxRecursionDeep;
        this.workspace = workspace;
    }

    private synchronized void addRequest(IResource resource) {
        IPath toAdd = resource.getFullPath();
        Iterator<IResource> it = this.fRequests.iterator();
        while (it.hasNext()) {
            IPath request = it.next().getFullPath();
            if (toAdd.isPrefixOf(request)) {
                it.remove();
                continue;
            }
            if (!request.isPrefixOf(toAdd)) continue;
            return;
        }
        this.fRequests.add(resource);
    }

    private synchronized void addRequests(List<IResource> list) {
        if (!list.isEmpty()) {
            this.fRequests.addAll(0, list);
        }
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_REFRESH;
    }

    protected List<IResource> collectChildrenToDepth(IResource resource, ArrayList<IResource> children, int depth) {
        IResource[] members;
        if (resource.getType() == 1) {
            return children;
        }
        try {
            members = ((IContainer)resource).members();
        }
        catch (CoreException e) {
            return children;
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() != 1) {
                if (depth <= 1) {
                    children.add(member);
                } else {
                    this.collectChildrenToDepth(member, children, depth - 1);
                }
            }
            ++n2;
        }
        return children;
    }

    public PrefixPool getPathPrefixHistory() {
        if (this.pathPrefixHistory == null) {
            this.pathPrefixHistory = new PrefixPool(20);
        }
        return this.pathPrefixHistory;
    }

    public PrefixPool getRootPathHistory() {
        if (this.rootPathHistory == null) {
            this.rootPathHistory = new PrefixPool(20);
        }
        return this.rootPathHistory;
    }

    private synchronized IResource nextRequest() {
        int len = this.fRequests.size();
        if (len == 0) {
            return null;
        }
        return this.fRequests.remove(len - 1);
    }

    public void refresh(IResource resource) {
        if (resource == null || this.disabled) {
            return;
        }
        this.addRequest(resource);
        this.schedule(this.updateDelay);
    }

    @Override
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        String msg = Messages.refresh_refreshErr;
        MultiStatus errors = new MultiStatus("org.eclipse.core.resources", 1, msg, null);
        long longestRefresh = 0L;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            IResource toRefresh;
            if (Policy.DEBUG_AUTO_REFRESH) {
                Policy.debug("Auto-refresh:  starting refresh job");
            }
            int refreshCount = 0;
            int depth = 2;
            IResourceRuleFactory ruleFactory = this.workspace.getRuleFactory();
            while ((toRefresh = this.nextRequest()) != null) {
                ISchedulingRule refreshRule = ruleFactory.refreshRule(toRefresh);
                try {
                    try {
                        subMonitor.setWorkRemaining(Math.max(this.fRequests.size(), 100));
                        Job.getJobManager().beginRule(refreshRule, (IProgressMonitor)subMonitor);
                        ++refreshCount;
                        long refreshTime = -System.currentTimeMillis();
                        toRefresh.refreshLocal(this.baseRefreshDepth + depth, (IProgressMonitor)subMonitor.split(1));
                        if ((refreshTime += System.currentTimeMillis()) > longestRefresh) {
                            longestRefresh = refreshTime;
                        }
                        if (refreshCount % this.depthIncreaseStep == 0) {
                            Thread.yield();
                            if (longestRefresh > (long)this.slowRefreshThreshold && depth > 1) {
                                depth = 1;
                                if (Policy.DEBUG_AUTO_REFRESH) {
                                    Policy.debug("Auto-refresh:  decreased refresh depth to: " + depth);
                                }
                            }
                            if (longestRefresh < (long)this.fastRefreshThreshold) {
                                if ((depth *= 2) <= 0 || depth > this.maxRecursionDeep) {
                                    depth = this.maxRecursionDeep;
                                }
                                if (Policy.DEBUG_AUTO_REFRESH) {
                                    Policy.debug("Auto-refresh:  increased refresh depth to: " + depth);
                                }
                            }
                            longestRefresh = 0L;
                        }
                        this.addRequests(this.collectChildrenToDepth(toRefresh, new ArrayList<IResource>(), depth));
                    }
                    catch (CoreException e) {
                        errors.merge((IStatus)new Status(4, "org.eclipse.core.resources", 1, errors.getMessage(), (Throwable)e));
                        Job.getJobManager().endRule(refreshRule);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Job.getJobManager().endRule(refreshRule);
                    throw throwable;
                }
                Job.getJobManager().endRule(refreshRule);
            }
        }
        finally {
            this.pathPrefixHistory = null;
            this.rootPathHistory = null;
            if (Policy.DEBUG_AUTO_REFRESH) {
                Policy.debug("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean shouldRun() {
        return !this.fRequests.isEmpty();
    }

    public void start() {
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  enabling auto-refresh");
        }
        this.disabled = false;
    }

    public void stop() {
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  disabling auto-refresh");
        }
        this.disabled = true;
        this.cancel();
    }
}

