/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.resource.CacheEventPool;
import org.eclipse.wst.common.internal.emf.resource.ReadAheadHelper;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.xml.sax.Attributes;

public class CacheEventNode {
    public static final String ROOT_NODE = "EMF_ROOT_NODE";
    private String nodeName = null;
    private Translator translator = null;
    private Notifier emfOwner = null;
    private StringBuffer buffer = null;
    private List children = null;
    private int versionID;
    private String[] attributes = null;
    private CacheEventNode parent = null;
    private CacheEventPool containingPool = null;
    private Boolean ignorable = null;

    public CacheEventNode(CacheEventPool containingPool) {
        this.containingPool = containingPool;
    }

    public void init(TranslatorResource resource) {
        this.discard();
        this.setEmfOwner((Notifier)resource);
        this.setTranslator(resource.getRootTranslator());
        this.setVersionID(resource.getVersionID());
        this.nodeName = ROOT_NODE;
    }

    public void init(CacheEventNode parentArg, String nodeNameArg, Attributes attributesArg) {
        this.discard();
        this.nodeName = nodeNameArg;
        this.init(parentArg, attributesArg);
    }

    private void init(CacheEventNode parentRecord, Attributes attributesArg) {
        this.setParent(parentRecord);
        this.setAttributes(attributesArg);
        if (this.parent != null) {
            if (this.parent.translator != null && this.parent.isInDOMPath()) {
                this.setParent(this.parent.getParent());
            }
            this.setVersionID(this.parent.getVersionID());
            if (this.parent.getEmfOwner() != null && this.parent.getTranslator() != null) {
                if (this.parent.getParent() != null) {
                    this.setTranslator(this.parent.getTranslator().findChild(this.nodeName, this.parent.getEmfOwner(), this.getVersionID()));
                } else {
                    this.setTranslator(this.parent.getTranslator());
                }
                if (this.translator == null) {
                    throw new IllegalStateException("Parent Translator (" + String.valueOf(this.parent.getTranslator()) + ") did not find a Child Translator for \"" + this.nodeName + "\".");
                }
                if (this.translator.getReadAheadHelper(this.nodeName) == null && !this.translator.isManagedByParent()) {
                    EObject myEmfOwner = this.translator.createEMFObject(this.getNodeName(), null);
                    this.setEmfOwner((Notifier)myEmfOwner);
                    this.translator.setMOFValue(this.parent.getEmfOwner(), (Object)myEmfOwner);
                }
            }
        }
        this.processAttributes();
    }

    public void commit() {
        if (this.parent == null || this.isIgnorable()) {
            this.discard();
            this.releaseFromContainingPool();
            return;
        }
        ReadAheadHelper helper = null;
        Translator activeTranslator = this.getTranslator();
        Translator parentTranslator = this.getParent().getTranslator();
        if (this.parent != null && this.parent.getEmfOwner() == null) {
            this.parent.appendToBuffer(this);
            helper = this.getParent().getReadAheadHelper();
            if (helper != null) {
                EObject parentOwner = null;
                if (helper.nodeValueIsReadAheadName(this.getNodeName())) {
                    parentOwner = parentTranslator.createEMFObject(this.getParent().getNodeName(), this.getBuffer());
                    this.getParent().updateEMF(parentOwner);
                } else if (helper.nodeNameIsReadAheadName(this.getNodeName())) {
                    parentOwner = parentTranslator.createEMFObject(this.getParent().getNodeName(), this.getNodeName());
                    this.getParent().updateEMF(parentOwner);
                }
            }
        } else {
            if (activeTranslator != null) {
                if (activeTranslator.isManagedByParent()) {
                    Object value = activeTranslator.convertStringToValue(this.getNodeName(), null, this.getBuffer(), this.getParent().getEmfOwner());
                    activeTranslator.setMOFValue(this.getParent().getEmfOwner(), value);
                    this.processAttributes();
                } else {
                    activeTranslator.setTextValueIfNecessary(this.getBuffer(), this.getEmfOwner(), this.getVersionID());
                }
            }
            this.discard();
            this.releaseFromContainingPool();
        }
    }

    private void discard() {
        this.translator = null;
        this.emfOwner = null;
        this.buffer = null;
        if (this.children != null) {
            this.children.clear();
        }
        this.children = null;
        this.attributes = null;
        this.parent = null;
    }

    private void releaseFromContainingPool() {
        if (this.containingPool != null) {
            this.containingPool.releaseNode(this);
        }
    }

    public boolean isIgnorable() {
        if (this.ignorable == null) {
            boolean result = false;
            if (this.translator != null) {
                String domPath;
                result = this.translator.isEmptyContentSignificant() ? false : ((domPath = this.translator.getDOMPath()) != null ? domPath.indexOf(this.nodeName) >= 0 : false);
            }
            this.ignorable = result ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.ignorable;
    }

    public boolean isChildIgnorable(String childNodeName) {
        boolean result = false;
        Translator childTranslator = null;
        if (this.getTranslator() != null && (childTranslator = this.getTranslator().findChild(childNodeName, this.getEmfOwner(), this.getVersionID())) != null) {
            if (childTranslator.isEmptyContentSignificant()) {
                result = false;
            } else {
                String temp = null;
                temp = childTranslator.getDOMPath();
                result = temp != null ? temp.indexOf(childNodeName) >= 0 : false;
            }
        }
        return result;
    }

    public boolean isInDOMPath() {
        boolean result = false;
        if (this.getTranslator() != null) {
            result = this.getNodeName().equals(this.getTranslator().getDOMPath());
        }
        return result;
    }

    public String toString() {
        StringBuffer output = new StringBuffer("CacheEventNode[");
        output.append("nodeName=");
        output.append(this.nodeName);
        output.append("; translator=");
        output.append(this.translator);
        output.append("; emfOwner=");
        try {
            output.append(this.emfOwner);
        }
        catch (RuntimeException runtimeException) {
            output.append("Could not render as string!");
        }
        output.append("; buffer=");
        output.append(this.buffer);
        output.append("; hasChildren=");
        output.append(this.children != null && this.children.size() > 0);
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                output.append("\n\tchildren(");
                output.append(i);
                output.append("): ");
                output.append(this.children.get(i));
                ++i;
            }
        }
        output.append("]");
        return output.toString();
    }

    public void updateEMF(EObject owner) {
        this.setEmfOwner((Notifier)owner);
        if (this.parent != null) {
            this.translator.setMOFValue((EObject)this.parent.getEmfOwner(), (Object)owner);
            this.processAttributes();
        }
        this.updateEMF();
    }

    public void updateEMF() {
        if (this.children == null) {
            return;
        }
        CacheEventNode child = null;
        Translator childTranslator = null;
        Object value = null;
        if (this.getEmfOwner() != null) {
            Notifier parentOwner = this.getEmfOwner();
            Translator parentTranslator = this.getTranslator();
            int i = 0;
            while (i < this.children.size()) {
                child = (CacheEventNode)this.children.get(i);
                if (this.isChildIgnorable(child.getNodeName())) {
                    this.addChildren(child.getChildren());
                } else {
                    childTranslator = parentTranslator.findChild(child.getNodeName(), parentOwner, child.getVersionID());
                    child.setTranslator(childTranslator);
                    value = childTranslator.convertStringToValue(child.getNodeName(), null, child.getBuffer(), parentOwner);
                    childTranslator.setMOFValue(parentOwner, value);
                    if (childTranslator.isObjectMap()) {
                        child.setEmfOwner((Notifier)value);
                        childTranslator.setTextValueIfNecessary(child.getBuffer(), child.getEmfOwner(), this.getVersionID());
                    }
                    child.processAttributes();
                    child.updateEMF();
                }
                child.discard();
                child.releaseFromContainingPool();
                ++i;
            }
            this.children = null;
        }
    }

    public void addChild(CacheEventNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (this.parent != null && this.isIgnorable()) {
            this.parent.addChild(child);
        } else {
            this.children.add(child);
        }
    }

    protected void addChildren(List childrenArg) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.addAll(childrenArg);
    }

    public boolean removeChild(CacheEventNode child) {
        if (this.children == null) {
            return false;
        }
        return this.children.remove(child);
    }

    public List getChildren() {
        return this.children;
    }

    public ReadAheadHelper getReadAheadHelper() {
        if (this.translator != null && this.translator.hasReadAheadNames()) {
            return this.translator.getReadAheadHelper(this.nodeName);
        }
        return null;
    }

    public void setAttributes(Attributes attr) {
        if (attr != null && attr.getLength() > 0) {
            if (this.attributes == null) {
                this.attributes = new String[attr.getLength() * 2];
            }
            int i = 0;
            while (i < attr.getLength()) {
                this.attributes[i] = attr.getQName(i);
                this.attributes[i + attr.getLength()] = attr.getValue(i);
                ++i;
            }
        }
    }

    public void processAttributes() {
        if (this.attributes != null && this.attributes.length > 0 && this.emfOwner != null && this.translator != null) {
            Translator attrTranslator = null;
            int limit = this.attributes.length / 2;
            Object value = null;
            int i = 0;
            while (i < limit) {
                attrTranslator = this.translator.findChild(this.attributes[i], this.emfOwner, this.versionID);
                if (attrTranslator != null) {
                    value = attrTranslator.convertStringToValue(this.attributes[i + limit], (EObject)this.emfOwner);
                    attrTranslator.setMOFValue((EObject)this.emfOwner, value);
                }
                ++i;
            }
            this.attributes = null;
        }
    }

    public void appendToBuffer(char[] data, int start, int length) {
        if (this.parent != null && this.isIgnorable()) {
            this.parent.appendToBuffer(data, start, length);
            return;
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.insert(this.buffer.length(), data, start, length);
    }

    public void appendToBuffer(CacheEventNode record) {
        this.addChild(record);
    }

    public String getBuffer() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toString();
    }

    public Notifier getEmfOwner() {
        return this.emfOwner;
    }

    public CacheEventNode getParent() {
        return this.parent;
    }

    private void setParent(CacheEventNode record) {
        this.parent = record;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setEmfOwner(Notifier notifier) {
        this.emfOwner = notifier;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getVersionID() {
        if (this.parent == null) {
            try {
                return ((TranslatorResource)this.getEmfOwner()).getVersionID();
            }
            catch (RuntimeException runtimeException) {}
        }
        return this.versionID;
    }

    public void setVersionID(int i) {
        this.versionID = i;
    }
}

