/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.ILocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FunctionTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration
implements ILocalDeclaration {
    public LocalVariableBinding binding;
    private boolean isLocal = true;

    public LocalDeclaration(char[] name, int sourceStart, int sourceEnd) {
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.declarationEnd = sourceEnd;
    }

    @Override
    public IAssignment getAssignment() {
        if (this.initialization == null) {
            return null;
        }
        if (this.initialization instanceof FunctionExpression) {
            return new Assignment(new SingleNameReference(this.name, this.sourceStart, this.sourceEnd), this.initialization, this.initialization.sourceEnd);
        }
        return null;
    }

    @Override
    public LocalVariableBinding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(LocalVariableBinding binding) {
        this.binding = binding;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        AbstractVariableDeclaration currVarDecl = this;
        while (currVarDecl != null) {
            if (currVarDecl instanceof LocalDeclaration) {
                flowInfo = currVarDecl.analyseCodeLocal(currentScope, flowContext, flowInfo);
            }
            currVarDecl = currVarDecl.nextLocal;
        }
        return flowInfo;
    }

    public FlowInfo analyseCodeLocal(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.bits |= 0x40000000;
        }
        if (this.initialization != null) {
            int nullStatus = this.initialization.nullStatus(flowInfo);
            this.bits = !(flowInfo = this.initialization.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).isDefinitelyAssigned(this.binding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
            flowInfo.markAsDefinitelyAssigned(this.binding);
            switch (nullStatus) {
                case 1: {
                    flowInfo.markAsDefinitelyNull(this.binding);
                    break;
                }
                case -1: {
                    flowInfo.markAsDefinitelyNonNull(this.binding);
                    break;
                }
                default: {
                    flowInfo.markAsDefinitelyUnknown(this.binding);
                }
            }
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    @Override
    public int getKind() {
        return 4;
    }

    public TypeBinding resolveVarType(BlockScope scope) {
        TypeBinding variableType = null;
        variableType = this.type != null ? this.type.resolveType(scope, true) : (this.inferredType != null ? this.inferredType.resolveType(scope, this) : TypeBinding.UNKNOWN);
        this.checkModifiers();
        return variableType;
    }

    @Override
    public void resolve(BlockScope scope) {
        AbstractVariableDeclaration currVarDecl = this;
        while (currVarDecl != null) {
            if (currVarDecl instanceof LocalDeclaration) {
                currVarDecl.resolveLocal(scope);
            }
            currVarDecl = currVarDecl.nextLocal;
        }
    }

    public void resolveLocal(BlockScope scope) {
        TypeBinding variableType = this.resolveVarType(scope);
        variableType = this.type != null ? this.type.resolveType(scope, true) : (this.inferredType != null ? this.inferredType.resolveType(scope, this) : TypeBinding.UNKNOWN);
        this.checkModifiers();
        Binding varBinding = null;
        varBinding = scope.enclosingMethodScope() == null ? scope.getBinding(this.name, 3, (InvocationSite)this, false) : scope.getLocalBinding(this.name, 3, this, false);
        boolean alreadyDefined = false;
        if (varBinding != null && varBinding.isValidBinding()) {
            VariableBinding existingVariable = (VariableBinding)varBinding;
            if (existingVariable.isFor(this)) {
                if (variableType != null) {
                    existingVariable.type = variableType;
                }
                alreadyDefined = true;
            } else if (existingVariable instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)existingVariable;
                if (localVariableBinding.declaringScope instanceof CompilationUnitScope && scope.enclosingMethodScope() != null) {
                    scope.problemReporter().localVariableHiding(this, existingVariable, false);
                } else {
                    scope.problemReporter().redefineLocal(this);
                }
            } else {
                scope.problemReporter().localVariableHiding(this, existingVariable, false);
            }
        }
        if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
            this.modifiers |= 0x4000000;
        }
        if (this.binding == null || !alreadyDefined) {
            this.binding = new LocalVariableBinding(this, variableType, this.modifiers, false);
            MethodScope methodScope = scope.enclosingMethodScope();
            if (methodScope != null) {
                methodScope.addLocalVariable(this.binding);
            } else {
                scope.compilationUnitScope().addLocalVariable(this.binding);
            }
        }
        if (variableType == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(scope);
            }
            return;
        }
        if (this.initialization != null) {
            TypeBinding initializationType;
            if (this.initialization instanceof ArrayInitializer) {
                initializationType = this.initialization.resolveTypeExpecting(scope, variableType);
                if (initializationType != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationType;
                }
            } else {
                this.initialization.setExpectedType(variableType);
                initializationType = this.initialization.resolveType(scope);
                if (initializationType != null) {
                    MethodBinding existingMethod;
                    if (initializationType.isFunctionType() && (existingMethod = scope.findMethod(this.name, null, false)) != null) {
                        MethodBinding functionBinding = ((FunctionTypeBinding)initializationType).functionBinding;
                        existingMethod.updateFrom(functionBinding);
                    }
                    if (variableType == TypeBinding.UNKNOWN && initializationType != TypeBinding.NULL) {
                        this.binding.type = initializationType;
                    }
                }
            }
            if (this.binding == Assignment.getDirectBinding(this.initialization)) {
                scope.problemReporter().assignmentHasNoEffect(this, this.name);
            }
        }
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        if (this.javadoc != null) {
            this.javadoc.print(indent, output);
        }
        return super.printStatement(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        AbstractVariableDeclaration currVarDecl = this;
        while (currVarDecl != null) {
            if (currVarDecl instanceof LocalDeclaration) {
                currVarDecl.traverseLocal(visitor, scope);
            }
            currVarDecl = currVarDecl.nextLocal;
        }
    }

    private void traverseLocal(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            IAssignment assignment;
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if ((assignment = this.getAssignment()) != null) {
                ((Assignment)assignment).traverse(visitor, scope);
            } else if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    public String getTypeName() {
        if (this.type != null) {
            return this.type.toString();
        }
        if (this.inferredType != null) {
            return new String(this.inferredType.getName());
        }
        return null;
    }

    @Override
    public int getASTType() {
        return 66;
    }

    @Override
    public void setIsType(boolean isType) {
        super.setIsType(isType);
        if (this.getAssignment() != null) {
            this.getAssignment().setIsType(isType);
        }
    }

    @Override
    public boolean isType() {
        return super.isType() || this.getAssignment() != null && this.getAssignment().isType();
    }

    @Override
    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }
}

