/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.ElementAdapter;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.AbstractUDDIElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.BusinessNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegFindTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ResultsTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceInterfaceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;

public class QueryNode
extends UDDINavigatorNode {
    private FormTool regFindTool_;
    private FindAction findAction_;

    public QueryNode(TreeElement element, NodeManager nodeManager, int nodeDepth) {
        super(element, nodeManager, nodeDepth, "uddi/images/query.gif");
        element.addListener((ElementListener)new ElementAdapter(){

            public void relAdded(RelAddEvent event) {
                String rel = event.getOutBoundRelName();
                if (rel.equals("queryResults")) {
                    TreeElement treeElement = (TreeElement)event.getParentElement();
                    QueryNode.this.createChildNode(treeElement);
                }
            }

            public void relRemoved(RelRemoveEvent event) {
                TreeElement treeElement = null;
                if (event.getInBoundRelName().equals("queryResults")) {
                    treeElement = (TreeElement)event.getInboundElement();
                } else if (event.getOutBoundRelName().equals("queryResults")) {
                    treeElement = (TreeElement)event.getOutBoundElement();
                }
                if (treeElement != null) {
                    QueryNode.this.removeChildNode(treeElement);
                }
            }
        });
        this.createChildren();
        this.setVisibilityOfChildren(false);
        this.findAction_ = null;
    }

    private final void createChildren() {
        Vector initialResults = (Vector)this.element_.getPropertyAsObject("initialResults");
        int i = 0;
        while (i < initialResults.size()) {
            Object object = initialResults.elementAt(i);
            AbstractUDDIElement childElement = null;
            if (object instanceof BusinessEntity) {
                childElement = new BusinessElement((BusinessEntity)object, this.element_.getModel());
            } else if (object instanceof BusinessService) {
                childElement = new ServiceElement((BusinessService)object, this.element_.getModel());
            } else if (object instanceof TModel) {
                childElement = new ServiceInterfaceElement((TModel)object, this.element_.getModel());
            }
            if (childElement != null) {
                this.element_.connect((Element)childElement, "queryResults", "owner");
            }
            ++i;
        }
    }

    private final void createChildNode(TreeElement element) {
        UDDINavigatorNode childNode = null;
        if (element instanceof BusinessElement) {
            childNode = new BusinessNode(element, this.nodeManager_, this.nodeDepth_ + 1);
        } else if (element instanceof ServiceElement) {
            childNode = new ServiceNode(element, this.nodeManager_, this.nodeDepth_ + 1);
        } else if (element instanceof ServiceInterfaceElement) {
            childNode = new ServiceInterfaceNode(element, this.nodeManager_, this.nodeDepth_ + 1);
        }
        if (childNode != null) {
            this.addChild(childNode);
        }
    }

    @Override
    protected final void initTools() {
        Controller controller = this.nodeManager_.getController();
        UDDIPerspective uddiPerspective = controller.getUDDIPerspective();
        new ResultsTool(this.toolManager_, controller.getMessage("ALT_RESULTS"));
        this.regFindTool_ = new RegFindTool(this.toolManager_, uddiPerspective.getMessage("ALT_FIND"));
    }

    public final void setFindToolProperties(FindAction findAction) {
        this.findAction_ = findAction;
        this.regFindTool_.updatePropertyTable(findAction.getPropertyTable());
    }

    @Override
    public void addAuthenticationProperties(RegistryElement regElement) {
        ((RegFindTool)this.regFindTool_).addAuthenticationProperties(regElement);
        Vector childNodes = this.getChildNodes();
        int i = 0;
        while (i < childNodes.size()) {
            UDDINavigatorNode navigatorNode = (UDDINavigatorNode)childNodes.elementAt(i);
            navigatorNode.addAuthenticationProperties(regElement);
            ++i;
        }
    }

    public final FindAction getFindAction() {
        return this.findAction_;
    }
}

