/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMavenExecutableLocation;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.core.internal.project.ResourcePomFacade;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IAdapterFactory.class}, property={"adaptableClass=org.eclipse.core.resources.IResource", "adapterNames=org.eclipse.m2e.core.embedder.IPomFacade"})
public class PomFacadeAdapterFactory
implements IAdapterFactory {
    @Reference
    private IMavenProjectRegistry mavenProjectRegistry;
    @Reference
    private PlexusContainerManager containerManager;

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IMavenExecutableLocation.class) {
            if (adaptableObject instanceof IFile) {
                IFile file = (IFile)adaptableObject;
                if (file.getName().equalsIgnoreCase("pom.xml")) {
                    return adapterType.cast(this.getFacadeForPom(file));
                }
                return null;
            }
            if (adaptableObject instanceof IContainer) {
                IContainer container = (IContainer)adaptableObject;
                IMavenExecutableLocation facade = Optional.of(container.getLocation()).map(IPath::toFile).flatMap(basedir -> {
                    IComponentLookup lookup = this.containerManager.getComponentLookup((File)basedir);
                    return IMavenToolbox.of(lookup).locatePom((File)basedir);
                }).map(pomfile -> container.getFile(IPath.fromPortableString((String)pomfile.getName()))).map(this::getFacadeForPom).orElse(null);
                return adapterType.cast(facade);
            }
            return null;
        }
        return null;
    }

    private IMavenExecutableLocation getFacadeForPom(IFile file) {
        IProject project;
        IMavenProjectFacade mavenProjectFacade;
        if (file == null) {
            return null;
        }
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (!file.exists()) {
            return null;
        }
        IContainer parent = file.getParent();
        if (parent instanceof IProject && (mavenProjectFacade = this.mavenProjectRegistry.getProject(project = (IProject)parent)) != null) {
            return mavenProjectFacade;
        }
        return new ResourcePomFacade(file);
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IMavenExecutableLocation.class};
    }
}

