/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class FreeformViewport
extends Viewport {
    public FreeformViewport() {
        super(true);
        this.setLayoutManager(new FreeformViewportLayout());
    }

    @Override
    protected void readjustScrollBars() {
        FreeformFigure ff = this.getFreeformFigure();
        if (ff == null) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        Rectangle bounds = ff.getFreeformExtent().getCopy();
        bounds.union(0, 0, clientArea.width, clientArea.height);
        ff.setFreeformBounds(bounds);
        this.getVerticalRangeModel().setAll(bounds.y, clientArea.height, bounds.bottom());
        this.getHorizontalRangeModel().setAll(bounds.x, clientArea.width, bounds.right());
    }

    @Override
    protected boolean useLocalCoordinates() {
        return true;
    }

    protected FreeformFigure getFreeformFigure() {
        IFigure iFigure = this.getContents();
        if (iFigure instanceof FreeformFigure) {
            FreeformFigure ff = (FreeformFigure)iFigure;
            return ff;
        }
        return null;
    }

    class FreeformViewportLayout
    extends ViewportLayout {
        FreeformViewportLayout() {
        }

        @Override
        protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
            FreeformViewport.this.getFreeformFigure().validate();
            wHint = Math.max(0, wHint);
            hHint = Math.max(0, hHint);
            return FreeformViewport.this.getFreeformFigure().getFreeformExtent().getExpanded(FreeformViewport.this.getInsets()).union(0, 0).union(wHint - 1, hHint - 1).getSize();
        }

        @Override
        protected boolean isSensitiveHorizontally(IFigure parent) {
            return true;
        }

        @Override
        protected boolean isSensitiveVertically(IFigure parent) {
            return true;
        }

        @Override
        public void layout(IFigure figure) {
        }
    }
}

