/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;

public class MediaWikiIdGenerationStrategy
extends IdGenerationStrategy {
    private final Map<String, Integer> anchorReferenceCount = new HashMap<String, Integer>();

    public String generateId(String headingText) {
        Object anchor = MediaWikiIdGenerationStrategy.headingTextToId(headingText);
        Integer previousRefCount = this.anchorReferenceCount.put((String)anchor, 1);
        if (previousRefCount != null) {
            int refCount = previousRefCount + 1;
            this.anchorReferenceCount.put((String)anchor, refCount);
            anchor = (String)anchor + "_" + refCount;
        }
        return anchor;
    }

    static String headingTextToId(String headingText) {
        String escaped = headingText.replaceAll("\\s", "_");
        escaped = URLEncoder.encode(escaped, StandardCharsets.UTF_8);
        return escaped.replace("%3A", ":").replace('%', '.');
    }
}

