/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.minimap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.views.minimap.MinimapMessages;
import org.eclipse.ui.internal.views.minimap.MinimapPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.texteditor.ITextEditor;

public class MultiPageMinimapPage
extends Page {
    private final MultiPageEditorPart fMultiPageEditor;
    private final Map<Object, MinimapPage> fMinimapPageMap;
    private final Set<Object> fUnsupportedEditorPages;
    private final IPageChangedListener fPageChangedListener;
    private PageBook fPageBook;
    private Label fErrorLabel;

    public MultiPageMinimapPage(MultiPageEditorPart multiPageEditor) {
        this.fMultiPageEditor = multiPageEditor;
        this.fMinimapPageMap = new HashMap<Object, MinimapPage>();
        this.fUnsupportedEditorPages = new HashSet<Object>();
        this.fPageChangedListener = e -> {
            Object selectedPage = multiPageEditor.getSelectedPage();
            MinimapPage minimapPage = this.fMinimapPageMap.get(selectedPage);
            if (minimapPage != null) {
                this.fPageBook.showPage(minimapPage.getControl());
                return;
            }
            if (this.fUnsupportedEditorPages.contains(selectedPage)) {
                this.fPageBook.showPage((Control)this.fErrorLabel);
                return;
            }
            if (selectedPage instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)selectedPage;
                minimapPage = MinimapPage.createMinimapPage(textEditor);
            }
            if (minimapPage != null) {
                minimapPage.createControl((Composite)this.fPageBook);
                this.fMinimapPageMap.put(selectedPage, minimapPage);
                this.fPageBook.showPage(minimapPage.getControl());
            } else {
                this.fUnsupportedEditorPages.add(selectedPage);
                this.fPageBook.showPage((Control)this.fErrorLabel);
            }
        };
        multiPageEditor.addPageChangedListener(this.fPageChangedListener);
    }

    public void createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.fErrorLabel = new Label((Composite)this.fPageBook, 0);
        this.fErrorLabel.setText(MinimapMessages.MinimapViewNoMinimap);
        this.fPageChangedListener.pageChanged(null);
    }

    public Control getControl() {
        return this.fPageBook;
    }

    public void setFocus() {
        this.fPageBook.setFocus();
    }

    public void dispose() {
        this.fMultiPageEditor.removePageChangedListener(this.fPageChangedListener);
        this.fMinimapPageMap.values().forEach(MinimapPage::dispose);
        this.fMinimapPageMap.clear();
        this.fUnsupportedEditorPages.clear();
        super.dispose();
    }
}

