/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dltk.internal.debug.ui.interpreters.Messages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class EnvironmentVariableContentProvider
implements ITreeContentProvider {
    private Viewer fViewer;
    private EnvironmentVariable[] fVariables = new EnvironmentVariable[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.fVariables;
    }

    public void setVariables(EnvironmentVariable[] vars) {
        if (vars != null) {
            this.fVariables = new EnvironmentVariable[vars.length];
            int i = 0;
            while (i < vars.length) {
                this.fVariables[i] = new EnvironmentVariable(vars[i]);
                ++i;
            }
        } else {
            this.fVariables = new EnvironmentVariable[0];
        }
        this.fViewer.refresh();
    }

    public EnvironmentVariable[] getVariables() {
        EnvironmentVariable[] variables = new EnvironmentVariable[this.fVariables.length];
        int i = 0;
        while (i < variables.length) {
            variables[i] = new EnvironmentVariable(this.fVariables[i]);
            ++i;
        }
        return variables;
    }

    private Set<EnvironmentVariable> getSelectedLibraries(IStructuredSelection selection) {
        HashSet<EnvironmentVariable> libraries = new HashSet<EnvironmentVariable>();
        for (Object element : selection) {
            if (!(element instanceof EnvironmentVariable)) continue;
            libraries.add((EnvironmentVariable)element);
        }
        return libraries;
    }

    public void up(IStructuredSelection selection) {
        Set<EnvironmentVariable> libraries = this.getSelectedLibraries(selection);
        int i = 0;
        while (i < this.fVariables.length - 1) {
            if (libraries.contains(this.fVariables[i + 1])) {
                EnvironmentVariable temp = this.fVariables[i];
                this.fVariables[i] = this.fVariables[i + 1];
                this.fVariables[i + 1] = temp;
            }
            ++i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void down(IStructuredSelection selection) {
        Set<EnvironmentVariable> libraries = this.getSelectedLibraries(selection);
        int i = this.fVariables.length - 1;
        while (i > 0) {
            if (libraries.contains(this.fVariables[i - 1])) {
                EnvironmentVariable temp = this.fVariables[i];
                this.fVariables[i] = this.fVariables[i - 1];
                this.fVariables[i - 1] = temp;
            }
            --i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void remove(IStructuredSelection selection) {
        ArrayList<EnvironmentVariable> newLibraries = new ArrayList<EnvironmentVariable>();
        int i = 0;
        while (i < this.fVariables.length) {
            newLibraries.add(this.fVariables[i]);
            ++i;
        }
        for (Object element : selection) {
            if (!(element instanceof EnvironmentVariable)) continue;
            newLibraries.remove(element);
        }
        this.fVariables = newLibraries.toArray(new EnvironmentVariable[newLibraries.size()]);
        this.fViewer.refresh();
    }

    public void add(EnvironmentVariable[] libs, IStructuredSelection selection) {
        ArrayList<Object> newLibraries = new ArrayList<Object>(this.fVariables.length + libs.length);
        int i = 0;
        while (i < this.fVariables.length) {
            newLibraries.add(this.fVariables[i]);
            ++i;
        }
        ArrayList<EnvironmentVariable> toAdd = new ArrayList<EnvironmentVariable>(libs.length);
        int i2 = 0;
        while (i2 < libs.length) {
            toAdd.add(new EnvironmentVariable(libs[i2]));
            ++i2;
        }
        if (selection.isEmpty()) {
            newLibraries.addAll(toAdd);
        } else {
            Object element = selection.getFirstElement();
            EnvironmentVariable firstLib = (EnvironmentVariable)element;
            int index = newLibraries.indexOf(firstLib);
            newLibraries.addAll(index, toAdd);
        }
        this.fVariables = newLibraries.toArray(new EnvironmentVariable[newLibraries.size()]);
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object[])libs), true);
    }

    public boolean addVariable(EnvironmentVariable variable) {
        String name = variable.getName();
        ArrayList<EnvironmentVariable> newVars = new ArrayList<EnvironmentVariable>();
        newVars.addAll(Arrays.asList(this.fVariables));
        Iterator i = newVars.iterator();
        while (i.hasNext()) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)i.next();
            if (!existingVariable.getName().equals(name)) continue;
            boolean overWrite = MessageDialog.openQuestion((Shell)this.fViewer.getControl().getShell(), (String)Messages.EnvironmentVariableContentProvider_overwriteVariableTitle, (String)NLS.bind((String)Messages.EnvironmentVariableContentProvider_overwriteVariableMessage, (Object)name));
            if (!overWrite) {
                return false;
            }
            i.remove();
            break;
        }
        newVars.add(new EnvironmentVariable(variable));
        this.fVariables = newVars.toArray(new EnvironmentVariable[newVars.size()]);
        return true;
    }

    public EnvironmentVariable[] getStandins() {
        return this.fVariables;
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }
}

