/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.php.internal.core.util.AbstractDeferredJob;
import org.eclipse.php.internal.core.util.NetworkUtil;

public class NetworkMonitor {
    private Inet4Address publicAddress;
    private List<Inet4Address> privateAddresses;
    private List<Inet4Address> allAddresses;
    private final CountDownLatch latch;
    private final Validator validator = new Validator();
    private final Detector detector = new Detector();

    public NetworkMonitor() {
        this.latch = new CountDownLatch(1);
        this.detector.schedule();
    }

    public void validate(String[] addresses, IHostsValidationListener[] validationListeners) {
        this.validator.validate(addresses, validationListeners);
    }

    public List<Inet4Address> getAllAddresses() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            return new ArrayList<Inet4Address>();
        }
        return this.allAddresses;
    }

    public List<Inet4Address> getPrivateAddresses() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            return new ArrayList<Inet4Address>();
        }
        return this.privateAddresses;
    }

    public Inet4Address getPublicAddress() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return this.publicAddress;
    }

    private class Detector
    extends Job {
        public Detector() {
            super("");
            this.setSystem(true);
            this.setUser(false);
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    ((Detector)Detector.this).NetworkMonitor.this.latch.countDown();
                    Detector.this.removeJobChangeListener((IJobChangeListener)this);
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            NetworkMonitor.this.publicAddress = NetworkUtil.getPublicAddress();
            NetworkMonitor.this.privateAddresses = new ArrayList<Inet4Address>();
            NetworkMonitor.this.privateAddresses.addAll(NetworkUtil.getPrivateAddresses());
            NetworkMonitor.this.allAddresses = new ArrayList<Inet4Address>();
            if (NetworkMonitor.this.publicAddress != null) {
                NetworkMonitor.this.allAddresses.add(NetworkMonitor.this.publicAddress);
            }
            NetworkMonitor.this.allAddresses.addAll(NetworkMonitor.this.privateAddresses);
            NetworkMonitor.this.allAddresses.add(NetworkUtil.LOCALHOST);
            return Status.OK_STATUS;
        }
    }

    public static interface IHostsValidationListener {
        public void validated(List<String> var1);
    }

    private class Validator
    extends AbstractDeferredJob {
        private String[] addresses;
        private IHostsValidationListener[] validationListeners;

        public Validator() {
            super("", 200);
            this.setSystem(true);
            this.setUser(false);
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                NetworkMonitor.this.latch.await();
            }
            catch (InterruptedException v0) {
                return Status.CANCEL_STATUS;
            }
            invalid = new ArrayList<String>();
            var6_3 = this.addresses;
            var5_4 = this.addresses.length;
            var4_5 = 0;
            while (var4_5 < var5_4) {
                block15: {
                    clientHost = var6_3[var4_5];
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!NetworkUtil.isIPv4Address(clientHost) && !clientHost.equalsIgnoreCase("localhost")) {
                        invalid.add(clientHost);
                    } else {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            clientHostAddress = (Inet4Address)InetAddress.getByName(clientHost);
                        }
                        catch (UnknownHostException v1) {
                            invalid.add(clientHost);
                            break block15;
                        }
                        isInvalid = true;
                        if (clientHostAddress != null) {
                            if (!NetworkUtil.isLoopbackAddress(clientHostAddress)) {
                                for (Inet4Address address : NetworkMonitor.this.allAddresses) {
                                    if (!clientHostAddress.getHostAddress().equals(address.getHostAddress())) continue;
                                    isInvalid = false;
                                    ** break;
                                }
                            }
                        } else if (isInvalid) {
                            invalid.add(clientHost);
                        }
                    }
                }
                ++var4_5;
            }
            var6_3 = this.validationListeners;
            var5_4 = this.validationListeners.length;
            var4_5 = 0;
            while (var4_5 < var5_4) {
                validationListener = var6_3[var4_5];
                validationListener.validated(invalid);
                ++var4_5;
            }
            return monitor.isCanceled() != false ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        void validate(String[] addresses, IHostsValidationListener[] validationListeners) {
            this.addresses = addresses;
            this.validationListeners = validationListeners;
            this.defer();
        }
    }
}

