/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.dialogs.AbstractChoicesDialogDelegate;
import org.eclipse.uml2.uml.editor.dialogs.IChoicesDialogDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoicesDialog<T>
extends Dialog {
    protected IContentProvider contentProvider;
    protected Object object;
    protected String displayName;
    protected ItemProvider values;
    protected List<T> choiceOfValues;
    protected TableViewer choiceTableViewer;
    protected TableViewer valuesTableViewer;
    protected EList<T> result;
    protected final IChoicesDialogDelegate<T> delegate;

    public ChoicesDialog(Shell parent, Object object, String displayName, IChoicesDialogDelegate<T> delegate) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.object = object;
        this.displayName = displayName;
        this.delegate = delegate;
        if (delegate instanceof AbstractChoicesDialogDelegate) {
            ((AbstractChoicesDialogDelegate)delegate).setDialog(this);
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(Collections.emptyList());
        this.values = new ItemProvider((AdapterFactory)adapterFactory, (Collection)Collections.EMPTY_LIST);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        this.updateChoiceOfValues();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        ILabelProvider labelProvider = this.delegate.getLabelProvider();
        shell.setText(UMLEditorPlugin.INSTANCE.getString("_UI_ChoicesDialog_title", new Object[]{this.displayName, labelProvider.getText(this.object)}));
        shell.setImage(labelProvider.getImage(this.object));
    }

    public void updateChoiceOfValues() {
        this.choiceOfValues = new ArrayList<T>(this.delegate.getChoiceOfValues());
        if (this.values != null) {
            this.values.getChildren().retainAll(this.choiceOfValues);
        }
        if (this.choiceTableViewer != null) {
            this.choiceTableViewer.setInput((Object)new ItemProvider(this.choiceOfValues));
        }
        if (this.valuesTableViewer != null) {
            this.valuesTableViewer.refresh();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Button downButton;
        Button upButton;
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Text patternText = null;
        Group filterGroupComposite = new Group(contents, 0);
        filterGroupComposite.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_pattern_group"));
        filterGroupComposite.setLayout((Layout)new GridLayout(2, false));
        filterGroupComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        Label label = new Label((Composite)filterGroupComposite, 0);
        label.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_pattern_label"));
        patternText = new Text((Composite)filterGroupComposite, 2176);
        patternText.setLayoutData((Object)new GridData(768));
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(this.delegate.getChoicesLabelText());
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        Table choiceTable = new Table(choiceComposite, 2050);
        GridData choiceTableGridData = new GridData();
        choiceTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        choiceTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        choiceTableGridData.verticalAlignment = 4;
        choiceTableGridData.horizontalAlignment = 4;
        choiceTableGridData.grabExcessHorizontalSpace = true;
        choiceTableGridData.grabExcessVerticalSpace = true;
        choiceTable.setLayoutData((Object)choiceTableGridData);
        this.choiceTableViewer = new TableViewer(choiceTable);
        this.choiceTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new AdapterFactoryImpl()));
        this.configureLabelProvider(this.choiceTableViewer);
        final PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        this.choiceTableViewer.addFilter((ViewerFilter)filter);
        if (patternText != null) {
            patternText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    filter.setPattern(((Text)e.widget).getText());
                    ChoicesDialog.this.choiceTableViewer.refresh();
                }
            });
        }
        this.choiceTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !ChoicesDialog.this.values.getChildren().contains(element);
            }
        });
        this.choiceTableViewer.setInput((Object)new ItemProvider(this.choiceOfValues));
        Composite controlButtons = new Composite(contents, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        final Button addButton = new Button(controlButtons, 8);
        addButton.setText(this.delegate.getAddButtonText());
        addButton.setImage(ExtendedImageRegistry.getInstance().getImage(UMLEditorPlugin.INSTANCE.getImage("full/etool16/ArrowRight.gif")));
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)addButtonGridData);
        final Button removeButton = new Button(controlButtons, 8);
        removeButton.setText(this.delegate.getRemoveButtonText());
        removeButton.setImage(ExtendedImageRegistry.getInstance().getImage(UMLEditorPlugin.INSTANCE.getImage("full/etool16/ArrowLeft.gif")));
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        boolean allowReorder = this.delegate.allowsReordering();
        Button button = upButton = allowReorder ? new Button(controlButtons, 8) : null;
        if (allowReorder) {
            upButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Up_label"));
            upButton.setImage(ExtendedImageRegistry.getInstance().getImage(UMLEditorPlugin.INSTANCE.getImage("full/etool16/ArrowUp.gif")));
            GridData upButtonGridData = new GridData();
            upButtonGridData.verticalAlignment = 4;
            upButtonGridData.horizontalAlignment = 4;
            upButton.setLayoutData((Object)upButtonGridData);
        }
        Button button2 = downButton = allowReorder ? new Button(controlButtons, 8) : null;
        if (allowReorder) {
            downButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Down_label"));
            downButton.setImage(ExtendedImageRegistry.getInstance().getImage(UMLEditorPlugin.INSTANCE.getImage("full/etool16/ArrowDown.gif")));
            GridData downButtonGridData = new GridData();
            downButtonGridData.verticalAlignment = 4;
            downButtonGridData.horizontalAlignment = 4;
            downButton.setLayoutData((Object)downButtonGridData);
        }
        Composite valuesComposite = new Composite(contents, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalAlignment = 0x1000008;
        valuesComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 1;
        valuesComposite.setLayout((Layout)layout2);
        Label valuesLabel = new Label(valuesComposite, 0);
        valuesLabel.setText(this.delegate.getValuesLabelText());
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        valuesLabel.setLayoutData((Object)featureLabelGridData);
        Table valuesTable = new Table(valuesComposite, 2050);
        GridData featureTableGridData = new GridData();
        featureTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        featureTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        featureTableGridData.verticalAlignment = 4;
        featureTableGridData.horizontalAlignment = 4;
        featureTableGridData.grabExcessHorizontalSpace = true;
        featureTableGridData.grabExcessVerticalSpace = true;
        valuesTable.setLayoutData((Object)featureTableGridData);
        this.valuesTableViewer = new TableViewer(valuesTable);
        this.valuesTableViewer.setContentProvider(this.contentProvider);
        this.configureLabelProvider(this.valuesTableViewer);
        this.valuesTableViewer.setInput((Object)this.values);
        final EList children = this.values.getChildren();
        if (!children.isEmpty()) {
            this.valuesTableViewer.setSelection((ISelection)new StructuredSelection(children.get(0)));
        }
        this.choiceTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (addButton.isEnabled()) {
                    addButton.notifyListeners(13, null);
                }
            }
        });
        this.valuesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (removeButton.isEnabled()) {
                    removeButton.notifyListeners(13, null);
                }
            }
        });
        if (allowReorder) {
            upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)ChoicesDialog.this.valuesTableViewer.getSelection();
                    int minIndex = 0;
                    for (Object value : selection) {
                        int index = children.indexOf(value);
                        children.move(Math.max(index - 1, minIndex++), value);
                    }
                }
            });
            downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)ChoicesDialog.this.valuesTableViewer.getSelection();
                    int maxIndex = children.size() - 1;
                    List objects = selection.toList();
                    ListIterator i = objects.listIterator(objects.size());
                    while (i.hasPrevious()) {
                        Object value = i.previous();
                        int index = children.indexOf(value);
                        children.move(Math.min(index + 1, maxIndex--), value);
                    }
                }
            });
        }
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ChoicesDialog.this.choiceTableViewer.getSelection();
                for (Object value : selection) {
                    if (children.contains(value)) continue;
                    children.add(value);
                }
                ChoicesDialog.this.valuesTableViewer.refresh();
                ChoicesDialog.this.valuesTableViewer.setSelection((ISelection)selection);
                ChoicesDialog.this.choiceTableViewer.refresh();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ChoicesDialog.this.valuesTableViewer.getSelection();
                Object firstValue = null;
                for (Object value : selection) {
                    if (firstValue == null) {
                        firstValue = value;
                    }
                    children.remove(value);
                }
                if (!children.isEmpty()) {
                    ChoicesDialog.this.valuesTableViewer.setSelection((ISelection)new StructuredSelection(children.get(0)));
                }
                ChoicesDialog.this.choiceTableViewer.refresh();
                ChoicesDialog.this.choiceTableViewer.setSelection((ISelection)selection);
            }
        });
        this.choiceTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                addButton.setEnabled(ChoicesDialog.this.delegate.canAdd((IStructuredSelection)event.getSelection(), ChoicesDialog.this.getValues()));
            }
        });
        this.valuesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(ChoicesDialog.this.delegate.canRemove((IStructuredSelection)event.getSelection(), ChoicesDialog.this.getChoices()));
            }
        });
        if (this.delegate.hasAdditionalControls()) {
            Composite additional = new Composite(contents, 0);
            additional.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
            additional.setLayout((Layout)new FillLayout());
            this.delegate.createAdditionalControls(additional);
        }
        return contents;
    }

    protected void configureLabelProvider(TableViewer viewer) {
        ILabelProvider labelProvider = this.delegate.createLabelProvider((Viewer)viewer);
        if (labelProvider instanceof CellLabelProvider) {
            final TableViewerColumn column = new TableViewerColumn(viewer, 16384);
            column.setLabelProvider((CellLabelProvider)labelProvider);
            viewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    column.getColumn().setWidth(((Control)e.widget).getSize().x);
                }
            });
        } else {
            viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    protected Collection<T> getChoices() {
        return this.choiceOfValues;
    }

    protected EList<T> getValues() {
        Class<T> type = this.delegate.getElementType();
        BasicEList result = new BasicEList(this.values.getChildren().size());
        for (Object next : this.values.getChildren()) {
            if (!type.isInstance(next)) continue;
            result.add(type.cast(next));
        }
        return result;
    }

    protected void okPressed() {
        EList<T> values = this.getValues();
        if (this.delegate.okPressed((Collection<T>)values)) {
            this.result = values;
            super.okPressed();
        }
    }

    public boolean close() {
        this.contentProvider.dispose();
        return super.close();
    }

    public EList<T> getResult() {
        return this.result;
    }
}

