/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IBranchDeletionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.IObjectTypeMapper;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.Batch;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class HorizontalBranchingMappingStrategy
extends AbstractHorizontalMappingStrategy
implements IBranchDeletionSupport {
    @Override
    public boolean hasAuditSupport() {
        return true;
    }

    @Override
    public boolean hasBranchingSupport() {
        return true;
    }

    @Override
    public boolean hasDeltaSupport() {
        return false;
    }

    @Override
    protected IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    @Override
    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMapping(this, containingClass, feature);
    }

    @Override
    public String getListJoin(String attrTable, String listTable) {
        String join = this.getListJoinBasic(attrTable, listTable);
        return this.modifyListJoin(attrTable, listTable, join, false);
    }

    @Override
    protected String getListJoinForRawExport(String attrTable, String listTable) {
        String join = this.getListJoinBasic(attrTable, listTable);
        return this.modifyListJoin(attrTable, listTable, join, true);
    }

    protected String getListJoinBasic(String attrTable, String listTable) {
        return super.getListJoin(attrTable, listTable);
    }

    protected String modifyListJoin(String attrTable, String listTable, String join, boolean forRawExport) {
        join = String.valueOf(join) + " AND " + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION);
        join = String.valueOf(join) + "=" + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION);
        join = String.valueOf(join) + " AND " + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH);
        join = String.valueOf(join) + "=" + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_BRANCH);
        return join;
    }

    @Override
    protected void rawImportReviseOldRevisions(IDBConnection connection, IDBTable table, OMMonitor monitor) {
        String sqlUpdate = "UPDATE " + table + " SET " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_REVISED) + "=? WHERE " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + "=? AND " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH) + "=? AND " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + "=?";
        String sqlQuery = "SELECT cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + ", cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH) + ", cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + ", cdo2." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_CREATED) + " FROM " + table + " cdo1, " + table + " cdo2 WHERE cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + "=cdo2." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + " AND cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH) + "=cdo2." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH) + " AND (cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + "=cdo2." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + "-1 OR (cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + "+cdo2." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + "=-1 AND cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + ">cdo2." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + ")) AND cdo1." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_REVISED) + "=0";
        IIDHandler idHandler = this.getStore().getIDHandler();
        IDBPreparedStatement stmtUpdate = connection.prepareStatement(sqlUpdate, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBPreparedStatement stmtQuery = connection.prepareStatement(sqlQuery, 1004, 1007, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            resultSet = stmtQuery.executeQuery();
            int size = DBUtil.getRowCount((ResultSet)resultSet);
            if (size == 0) {
                return;
            }
            try {
                monitor.begin((double)(2 * size));
                while (resultSet.next()) {
                    CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                    int branch = resultSet.getInt(2);
                    int version = resultSet.getInt(3);
                    long revised = resultSet.getLong(4) - 1L;
                    stmtUpdate.setLong(1, revised);
                    idHandler.setCDOID((PreparedStatement)stmtUpdate, 2, id);
                    stmtUpdate.setInt(3, branch);
                    stmtUpdate.setInt(4, version);
                    stmtUpdate.addBatch();
                    monitor.worked();
                }
                OMMonitor.Async async = monitor.forkAsync((double)size);
                try {
                    stmtUpdate.executeBatch();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmtQuery);
            DBUtil.close((Statement)stmtUpdate);
            monitor.done();
        }
    }

    @Override
    protected void rawImportUnreviseNewRevisions(IDBConnection connection, IDBTable table, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        String sql = "UPDATE " + table + " SET " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_REVISED) + "=0 WHERE " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH) + ">=0 AND " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_CREATED) + "<=" + toCommitTime + " AND " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_REVISED) + ">" + toCommitTime + " AND " + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + ">0";
        IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                monitor.begin();
                OMMonitor.Async async = monitor.forkAsync();
                try {
                    stmt.executeUpdate();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
            monitor.done();
        }
    }

    @Override
    public void deleteBranches(IDBStoreAccessor accessor, Batch batch, String idList) {
        for (IClassMapping classMapping : this.getClassMappings().values()) {
            if (!(classMapping instanceof IBranchDeletionSupport)) continue;
            ((IBranchDeletionSupport)((Object)classMapping)).deleteBranches(accessor, batch, idList);
        }
        IObjectTypeMapper objectTypeMapper = this.getObjectTypeMapper();
        if (objectTypeMapper instanceof IBranchDeletionSupport) {
            ((IBranchDeletionSupport)((Object)objectTypeMapper)).deleteBranches(accessor, batch, idList);
        }
    }
}

